/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.client.model;

import com.mojang.math.Vector3f;
import ht.tuber.math.Vector3;
import java.util.Arrays;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;

public class ModelUtil {
    private static final ResourceLocation UNKNOWN_RESOURCE = new ResourceLocation("treechop", "dynamic");

    public static BakedQuad makeQuad(TextureAtlasSprite sprite, Vector3 posFrom, Vector3 posTo, Direction orientation, Direction culling) {
        return ModelUtil.makeQuad(sprite, posFrom, posTo, orientation, culling, ModelUtil.getUVsForQuad(posFrom, posTo, orientation), 0);
    }

    private static float[] getUVsForQuad(Vector3 posFrom, Vector3 posTo, Direction orientation) {
        float[] fArray;
        Vector3f posFrom3f = ModelUtil.toVector3f(posFrom);
        Vector3f posTo3f = ModelUtil.toVector3f(posTo);
        switch (orientation) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case UP: 
            case DOWN: {
                float[] fArray2 = new float[4];
                fArray2[0] = posFrom3f.m_122239_();
                fArray2[1] = posFrom3f.m_122269_();
                fArray2[2] = posTo3f.m_122239_();
                fArray = fArray2;
                fArray2[3] = posTo3f.m_122269_();
                break;
            }
            case EAST: 
            case WEST: {
                float[] fArray3 = new float[4];
                fArray3[0] = posFrom3f.m_122269_();
                fArray3[1] = posFrom3f.m_122260_();
                fArray3[2] = posTo3f.m_122269_();
                fArray = fArray3;
                fArray3[3] = posTo3f.m_122260_();
                break;
            }
            case NORTH: 
            case SOUTH: {
                float[] fArray4 = new float[4];
                fArray4[0] = posFrom3f.m_122239_();
                fArray4[1] = posFrom3f.m_122260_();
                fArray4[2] = posTo3f.m_122239_();
                fArray = fArray4;
                fArray4[3] = posTo3f.m_122260_();
            }
        }
        return fArray;
    }

    public static BakedQuad makeQuad(TextureAtlasSprite sprite, Vector3 posFrom, Vector3 posTo, Direction orientation, Direction culling, float[] uvs, int uvRotation) {
        return new FaceBakery().m_111600_(ModelUtil.toVector3f(posFrom), ModelUtil.toVector3f(posTo), new BlockElementFace(culling, -1, "", new BlockFaceUV(uvs, uvRotation)), sprite, orientation, (ModelState)BlockModelRotation.X0_Y0, null, true, UNKNOWN_RESOURCE);
    }

    public static BakedQuad trimQuad(BakedQuad quad, Vector3 corner1, Vector3 corner2) {
        Vector3 mins = new Vector3(Math.min(corner1.x(), corner2.x()), Math.min(corner1.y(), corner2.y()), Math.min(corner1.z(), corner2.z()));
        Vector3 maxes = new Vector3(Math.max(corner1.x(), corner2.x()), Math.max(corner1.y(), corner2.y()), Math.max(corner1.z(), corner2.z()));
        int[] vertexData = ModelUtil.trimQuadVertices(quad.m_111303_(), mins, maxes);
        return new BakedQuad(vertexData, quad.m_111305_(), quad.m_111306_(), quad.m_173410_(), quad.m_111307_());
    }

    private static int[] trimQuadVertices(int[] vertexData, Vector3 mins, Vector3 maxes) {
        int vertexSize = vertexData.length / 4;
        Vertex oldV1 = ModelUtil.getVertex(vertexData, 0, vertexSize);
        Vertex oldV2 = ModelUtil.getVertex(vertexData, 1, vertexSize);
        Vertex oldV3 = ModelUtil.getVertex(vertexData, 2, vertexSize);
        Vertex oldV4 = ModelUtil.getVertex(vertexData, 3, vertexSize);
        Vertex newV1 = ModelUtil.lerpVertexUVsInTriangle(oldV1.xyz().clamp(mins, maxes), oldV1, oldV2, oldV3);
        Vertex newV2 = ModelUtil.lerpVertexUVsInTriangle(oldV2.xyz().clamp(mins, maxes), oldV1, oldV2, oldV3);
        Vertex newV3 = ModelUtil.lerpVertexUVsInTriangle(oldV3.xyz().clamp(mins, maxes), oldV1, oldV2, oldV3);
        Vertex newV4 = ModelUtil.lerpVertexUVsInTriangle(oldV4.xyz().clamp(mins, maxes), oldV1, oldV2, oldV3);
        int[] newVertexData = Arrays.copyOf(vertexData, vertexData.length);
        ModelUtil.setVertex(newVertexData, 0, vertexSize, newV1);
        ModelUtil.setVertex(newVertexData, 1, vertexSize, newV2);
        ModelUtil.setVertex(newVertexData, 2, vertexSize, newV3);
        ModelUtil.setVertex(newVertexData, 3, vertexSize, newV4);
        return newVertexData;
    }

    private static Vertex lerpVertexUVsInTriangle(Vector3 pos, Vertex v1, Vertex v2, Vertex v3) {
        Vector3 v1Weights = ModelUtil.getLerpWeightsInSimplex(pos, v1.xyz(), v2.xyz(), v3.xyz());
        double u = v1Weights.dot(v1.u, v2.u, v3.u);
        double v = v1Weights.dot(v1.v, v2.v, v3.v);
        return new Vertex(pos.x, pos.y, pos.z, u, v);
    }

    private static Vector3 getLerpWeightsInSimplex(Vector3 pos, Vector3 v1, Vector3 v2, Vector3 v3) {
        Vector3 side1 = v2.subtract(v1);
        Vector3 side2 = v3.subtract(v1);
        Vector3 normal = side2.cross(side1).normalize();
        double offset = pos.subtract(v1).dot(normal);
        Vector3 p = pos.subtract(normal.scale(offset));
        Vector3 f1 = v1.subtract(p);
        Vector3 f2 = v2.subtract(p);
        Vector3 f3 = v3.subtract(p);
        Vector3 va = side1.cross(side2);
        Vector3 va1 = f2.cross(f3);
        Vector3 va2 = f3.cross(f1);
        Vector3 va3 = f1.cross(f2);
        double a = va.length();
        double w1 = va1.length() / a * Math.signum(va.dot(va1));
        double w2 = va2.length() / a * Math.signum(va.dot(va2));
        double w3 = va3.length() / a * Math.signum(va.dot(va3));
        return new Vector3(w1, w2, w3);
    }

    private static Vertex getVertex(int[] vertexData, int index, int vertexSize) {
        int i = index * vertexSize;
        float x = Float.intBitsToFloat(vertexData[i]) * 16.0f;
        float y = Float.intBitsToFloat(vertexData[i + 1]) * 16.0f;
        float z = Float.intBitsToFloat(vertexData[i + 2]) * 16.0f;
        float u = Float.intBitsToFloat(vertexData[i + 4]);
        float v = Float.intBitsToFloat(vertexData[i + 5]);
        return new Vertex(x, y, z, u, v);
    }

    private static void setVertex(int[] vertexData, int index, int vertexSize, Vertex vertex) {
        int i = index * vertexSize;
        vertexData[i] = Float.floatToIntBits((float)vertex.x / 16.0f);
        vertexData[i + 1] = Float.floatToIntBits((float)vertex.y / 16.0f);
        vertexData[i + 2] = Float.floatToIntBits((float)vertex.z / 16.0f);
        vertexData[i + 4] = Float.floatToIntBits((float)vertex.u);
        vertexData[i + 5] = Float.floatToIntBits((float)vertex.v);
    }

    public static BakedQuad translateQuad(BakedQuad quad, Vector3 translation) {
        int[] vertexData = Arrays.copyOf(quad.m_111303_(), quad.m_111303_().length);
        ModelUtil.translateVertex(vertexData, 0, translation);
        ModelUtil.translateVertex(vertexData, 1, translation);
        ModelUtil.translateVertex(vertexData, 2, translation);
        ModelUtil.translateVertex(vertexData, 3, translation);
        return new BakedQuad(vertexData, quad.m_111305_(), quad.m_111306_(), quad.m_173410_(), quad.m_111307_());
    }

    private static void translateVertex(int[] vertexData, int index, Vector3 translation) {
        int vertexSize = vertexData.length / 4;
        Vertex vertex = ModelUtil.getVertex(vertexData, index, vertexSize);
        ModelUtil.setVertex(vertexData, index, vertexSize, new Vertex(vertex.x + translation.x, vertex.y + translation.y, vertex.z + translation.z, vertex.u, vertex.v));
    }

    private static Vector3f toVector3f(Vector3 vec) {
        return new Vector3f((float)vec.x, (float)vec.y, (float)vec.z);
    }

    private record Vertex(double x, double y, double z, double u, double v) {
        public Vector3 xyz() {
            return new Vector3(this.x, this.y, this.z);
        }
    }
}

