/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.common;

import ht.treechop.common.capabilities.ChopSettingsCapability;
import ht.treechop.common.capabilities.ChopSettingsProvider;
import ht.treechop.common.chop.ChopUtil;
import ht.treechop.common.config.ConfigHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="treechop", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ForgeCommon {
    @SubscribeEvent
    public static void onTagsUpdated(TagsUpdatedEvent event) {
        ConfigHandler.updateTags();
    }

    @SubscribeEvent
    public static void onBreakEvent(BlockEvent.BreakEvent event) {
        ServerLevel level;
        LevelAccessor levelAccessor;
        block5: {
            block4: {
                if (event.isCanceled() || !((levelAccessor = event.getLevel()) instanceof ServerLevel)) break block4;
                level = (ServerLevel)levelAccessor;
                levelAccessor = event.getPlayer();
                if (levelAccessor instanceof ServerPlayer) break block5;
            }
            return;
        }
        ServerPlayer agent = (ServerPlayer)levelAccessor;
        ItemStack tool = event.getPlayer().m_21205_();
        BlockState blockState = event.getState();
        BlockPos pos = event.getPos();
        if (ChopUtil.chop(agent, level, pos, blockState, tool, event)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        ResourceLocation loc = new ResourceLocation("treechopchop_settings_capability");
        Entity entity = (Entity)event.getObject();
        if (entity instanceof FakePlayer) {
            event.addCapability(loc, (ICapabilityProvider)new ChopSettingsProvider(ConfigHandler.fakePlayerChopSettings.get()));
        } else {
            event.addCapability(loc, (ICapabilityProvider)new ChopSettingsProvider());
        }
    }

    @SubscribeEvent
    public void registerCaps(RegisterCapabilitiesEvent event) {
        event.register(ChopSettingsCapability.class);
    }
}

