/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.common.chop;

import ht.treechop.TreeChop;
import ht.treechop.api.IChoppableBlock;
import ht.treechop.api.IChoppingItem;
import ht.treechop.api.IFellableBlock;
import ht.treechop.api.IStrippableBlock;
import ht.treechop.api.TreeData;
import ht.treechop.common.chop.Chop;
import ht.treechop.common.chop.ChopDataImpl;
import ht.treechop.common.chop.ChopResult;
import ht.treechop.common.config.ChopCountingAlgorithm;
import ht.treechop.common.config.ConfigHandler;
import ht.treechop.common.settings.ChopSettings;
import ht.treechop.common.util.AxeAccessor;
import ht.treechop.common.util.BlockNeighbors;
import ht.treechop.common.util.BlockUtil;
import ht.treechop.common.util.ClassUtil;
import ht.treechop.common.util.TreeDataImpl;
import ht.treechop.server.Server;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class ChopUtil {
    public static boolean isBlockALog(Level level, BlockPos pos) {
        return ChopUtil.isBlockALog(level, pos, level.m_8055_(pos));
    }

    public static boolean isBlockALog(Level level, BlockPos pos, BlockState blockState) {
        return ChopUtil.isBlockChoppable((BlockGetter)level, pos, blockState);
    }

    public static boolean isBlockChoppable(Level level, BlockPos pos) {
        return ChopUtil.isBlockChoppable((BlockGetter)level, pos, level.m_8055_(pos));
    }

    public static boolean isBlockChoppable(BlockGetter level, BlockPos pos, BlockState blockState) {
        return ClassUtil.getChoppableBlock(level, pos, blockState) != null;
    }

    public static boolean isBlockLeaves(Level level, BlockPos pos) {
        return ChopUtil.isBlockLeaves(level.m_8055_(pos));
    }

    public static boolean isBlockLeaves(BlockState blockState) {
        if (ConfigHandler.COMMON.leavesBlocks.get().contains(blockState.m_60734_())) {
            return (Boolean)ConfigHandler.COMMON.ignorePersistentLeaves.get() == false || !blockState.m_61138_((Property)LeavesBlock.f_54419_) || (Boolean)blockState.m_61143_((Property)LeavesBlock.f_54419_) == false;
        }
        return false;
    }

    public static Set<BlockPos> getConnectedBlocks(Collection<BlockPos> startingPoints, Function<BlockPos, Stream<BlockPos>> searchOffsetsSupplier, int maxNumBlocks, AtomicInteger iterationCounter) {
        HashSet<BlockPos> connectedBlocks = new HashSet<BlockPos>();
        List<Object> newConnectedBlocks = new LinkedList<BlockPos>(startingPoints);
        iterationCounter.set(0);
        do {
            connectedBlocks.addAll(newConnectedBlocks);
            if (connectedBlocks.size() >= maxNumBlocks) break;
            newConnectedBlocks = newConnectedBlocks.stream().flatMap(blockPos -> ((Stream)searchOffsetsSupplier.apply((BlockPos)blockPos)).filter(pos1 -> !connectedBlocks.contains(pos1))).limit(maxNumBlocks - connectedBlocks.size()).collect(Collectors.toList());
            iterationCounter.incrementAndGet();
        } while (!newConnectedBlocks.isEmpty());
        return connectedBlocks;
    }

    public static Set<BlockPos> getConnectedBlocks(Collection<BlockPos> startingPoints, Function<BlockPos, Stream<BlockPos>> searchOffsetsSupplier, int maxNumBlocks) {
        return ChopUtil.getConnectedBlocks(startingPoints, searchOffsetsSupplier, maxNumBlocks, new AtomicInteger());
    }

    public static List<BlockPos> getTreeLeaves(Level level, Collection<BlockPos> treeBlocks) {
        AtomicInteger iterationCounter = new AtomicInteger();
        HashSet leaves = new HashSet();
        int maxDistance = (Integer)ConfigHandler.COMMON.maxBreakLeavesDistance.get();
        int maxNumLeavesBlocks = (Integer)ConfigHandler.COMMON.maxNumLeavesBlocks.get();
        ChopUtil.getConnectedBlocks(treeBlocks, pos1 -> {
            BlockState blockState = level.m_8055_(pos1);
            return (ChopUtil.isBlockLeaves(blockState) && !(blockState.m_60734_() instanceof LeavesBlock) ? BlockNeighbors.ADJACENTS_AND_BELOW_ADJACENTS : BlockNeighbors.ADJACENTS).asStream((BlockPos)pos1).filter(pos2 -> ChopUtil.markLeavesToDestroyAndKeepLooking(level, pos2, iterationCounter, leaves, maxDistance));
        }, maxNumLeavesBlocks, iterationCounter);
        if (leaves.size() >= maxNumLeavesBlocks) {
            TreeChop.LOGGER.warn(String.format("Max number of leaves reached: %d >= %d blocks", leaves.size(), maxNumLeavesBlocks));
        }
        return new ArrayList<BlockPos>(leaves);
    }

    private static boolean markLeavesToDestroyAndKeepLooking(Level level, BlockPos pos, AtomicInteger iterationCounter, Set<BlockPos> leavesToDestroy, int maxDistance) {
        BlockState blockState = level.m_8055_(pos);
        if (ChopUtil.isBlockLeaves(blockState)) {
            if (blockState.m_60734_() instanceof LeavesBlock ? iterationCounter.get() + 1 > (Integer)blockState.m_61143_((Property)LeavesBlock.f_54418_) : iterationCounter.get() >= maxDistance) {
                return false;
            }
            leavesToDestroy.add(pos);
            return true;
        }
        return false;
    }

    public static int numChopsToFell(int supportSize) {
        return ((ChopCountingAlgorithm)((Object)ConfigHandler.COMMON.chopCountingAlgorithm.get())).calculate(supportSize);
    }

    public static int numChopsToFell(Level level, Set<BlockPos> supportedBlocks) {
        int treeSize = Math.max(supportedBlocks.stream().map(pos -> {
            Double d;
            Block patt6139$temp = level.m_8055_(pos).m_60734_();
            if (patt6139$temp instanceof IFellableBlock) {
                IFellableBlock block = (IFellableBlock)patt6139$temp;
                d = block.getSupportFactor((BlockGetter)level, (BlockPos)pos, level.m_8055_(pos));
            } else {
                d = 1.0;
            }
            return d;
        }).reduce(Double::sum).orElse(1.0).intValue(), 1);
        return ChopUtil.numChopsToFell(treeSize);
    }

    public static ChopResult getChopResult(Level level, BlockPos blockPos, ChopSettings chopSettings, int numChops, boolean fellIfPossible, Predicate<BlockPos> logCondition) {
        return fellIfPossible ? ChopUtil.getChopResult(level, blockPos, chopSettings, numChops, logCondition) : ChopUtil.tryToChopWithoutFelling(level, blockPos, numChops);
    }

    private static ChopResult getChopResult(Level level, BlockPos blockPos, ChopSettings chopSettings, int numChops, Predicate<BlockPos> logCondition) {
        int maxNumTreeBlocks = (Integer)ConfigHandler.COMMON.maxNumTreeBlocks.get();
        TreeData tree = ChopUtil.getTreeBlocks(level, blockPos, logCondition, maxNumTreeBlocks);
        if (tree.getLogBlocksOrEmpty().size() >= maxNumTreeBlocks) {
            TreeChop.LOGGER.warn("Max tree size {} reached (not including leaves)", (Object)maxNumTreeBlocks);
        }
        if (tree.isAProperTree(chopSettings.getTreesMustHaveLeaves())) {
            Set<BlockPos> supportedBlocks = tree.getLogBlocks().orElse(Collections.emptySet());
            return ChopUtil.getChopResult(level, blockPos, supportedBlocks, numChops);
        }
        return ChopResult.IGNORED;
    }

    public static TreeData getTreeBlocks(Level level, BlockPos blockPos, int maxNumTreeBlocks) {
        return ChopUtil.getTreeBlocks(level, blockPos, pos -> ChopUtil.isBlockALog(level, pos), maxNumTreeBlocks);
    }

    public static TreeData getTreeBlocks(Level level, BlockPos blockPos, Predicate<BlockPos> logCondition, int maxNumTreeBlocks) {
        if (!logCondition.test(blockPos)) {
            return new TreeDataImpl();
        }
        TreeData detectData = TreeChop.platform.detectTreeEvent(level, null, blockPos, level.m_8055_(blockPos), false);
        if (detectData.getLogBlocks().isPresent()) {
            return detectData;
        }
        Set<BlockPos> supportedBlocks = ChopUtil.getConnectedBlocks(Collections.singletonList(blockPos), somePos -> BlockNeighbors.HORIZONTAL_AND_ABOVE.asStream((BlockPos)somePos).peek(pos -> detectData.setLeaves(detectData.hasLeaves() || ChopUtil.isBlockLeaves(level, pos))).filter(logCondition), maxNumTreeBlocks);
        detectData.setLogBlocks(supportedBlocks);
        return detectData;
    }

    private static ChopResult getChopResult(Level level, BlockPos target, Set<BlockPos> supportedBlocks, int numChops) {
        int numChopsToFell;
        if (supportedBlocks.isEmpty()) {
            return ChopResult.IGNORED;
        }
        BlockState blockState = level.m_8055_(target);
        int currentNumChops = ChopUtil.getNumChops(level, target, blockState);
        if (currentNumChops + numChops < (numChopsToFell = ChopUtil.numChopsToFell(level, supportedBlocks))) {
            HashSet nearbyUnchoppedBlocks = new HashSet();
            Set<BlockPos> nearbyChoppableBlocks = ChopUtil.collectChoppedBlocks(level, target, blockPos -> {
                if (ChopUtil.isBlockChoppable(level, blockPos)) {
                    nearbyUnchoppedBlocks.add(blockPos);
                }
            });
            int totalNumChops = ChopUtil.getNumChops(level, nearbyChoppableBlocks) + numChops;
            if (totalNumChops >= numChopsToFell) {
                List<BlockPos> choppedLogsSortedByY = nearbyChoppableBlocks.stream().sorted(Comparator.comparingInt(Vec3i::m_123342_)).toList();
                for (BlockPos pos : choppedLogsSortedByY) {
                    int chops = ChopUtil.getNumChops(level, pos);
                    supportedBlocks.add(pos);
                    if (chops <= numChopsToFell) continue;
                    break;
                }
            } else {
                nearbyChoppableBlocks.remove(target);
                return ChopUtil.gatherChops(level, target, numChops, Stream.concat(nearbyChoppableBlocks.stream(), nearbyUnchoppedBlocks.stream()));
            }
        }
        Chop chop = new Chop(target, numChops);
        return new ChopResult(level, Collections.singletonList(chop), supportedBlocks);
    }

    @NotNull
    public static Set<BlockPos> collectChoppedBlocks(Level level, BlockPos target) {
        return ChopUtil.collectChoppedBlocks(level, target, x -> {});
    }

    @NotNull
    private static Set<BlockPos> collectChoppedBlocks(Level level, BlockPos target, Consumer<BlockPos> neighborPeeker) {
        return ChopUtil.getConnectedBlocks(Collections.singletonList(target), pos -> BlockNeighbors.ADJACENTS_AND_DIAGONALS.asStream((BlockPos)pos).filter(checkPos -> {
            if (ChopUtil.getNumChops(level, checkPos) > 0) {
                return true;
            }
            neighborPeeker.accept((BlockPos)checkPos);
            return false;
        }), 64);
    }

    private static ChopResult gatherChops(Level level, BlockPos target, int numChops, Stream<BlockPos> nearbyChoppableBlocks) {
        List sortedChoppableBlocks;
        Stack<Chop> chops = new Stack<Chop>();
        int numChopsLeft = ChopUtil.gatherChopAndGetNumChopsRemaining(level, target, numChops, chops);
        if (numChopsLeft > 0 && (sortedChoppableBlocks = nearbyChoppableBlocks.filter(pos -> {
            BlockState blockState = level.m_8055_(pos);
            if (blockState.m_60734_() instanceof IChoppableBlock) {
                return ChopUtil.getNumChops(level, pos, blockState) < ChopUtil.getMaxNumChops(level, pos, blockState);
            }
            return pos.m_123342_() >= target.m_123342_();
        }).sorted(Comparator.comparingInt(a -> ChopUtil.chopDistance(target, a))).collect(Collectors.toList())).size() > 0) {
            int nextChoiceDistance = ChopUtil.chopDistance(target, (BlockPos)sortedChoppableBlocks.get(0));
            int candidateStartIndex = 0;
            int n = sortedChoppableBlocks.size();
            for (int i = 0; i <= n; ++i) {
                BlockPos nextTarget;
                if (i != n && ChopUtil.chopDistance(target, (BlockPos)sortedChoppableBlocks.get(i)) <= nextChoiceDistance) continue;
                List candidates = sortedChoppableBlocks.subList(candidateStartIndex, i);
                Collections.shuffle(candidates);
                Iterator iterator = candidates.iterator();
                while (iterator.hasNext() && (numChopsLeft = ChopUtil.gatherChopAndGetNumChopsRemaining(level, nextTarget = (BlockPos)iterator.next(), numChopsLeft, chops)) > 0) {
                }
                if (numChopsLeft <= 0) break;
                candidateStartIndex = i;
            }
        }
        return new ChopResult(level, chops, Collections.emptyList());
    }

    private static int gatherChopAndGetNumChopsRemaining(Level level, BlockPos targetPos, int numChops, List<Chop> choppedBlocks) {
        BlockState blockStateBeforeChopping = level.m_8055_(targetPos);
        if (!(blockStateBeforeChopping.m_60734_() instanceof IChoppableBlock) && ChopUtil.isBlockSurrounded(level, targetPos)) {
            return numChops;
        }
        int adjustedNumChops = ChopUtil.adjustNumChops(level, targetPos, blockStateBeforeChopping, numChops, false);
        if (adjustedNumChops > 0) {
            choppedBlocks.add(new Chop(targetPos, adjustedNumChops));
        }
        return numChops - adjustedNumChops;
    }

    private static boolean isBlockSurrounded(Level level, BlockPos pos) {
        return Stream.of(pos.m_122024_(), pos.m_122012_(), pos.m_122029_(), pos.m_122019_()).allMatch(neighborPos -> ChopUtil.isBlockALog(level, neighborPos));
    }

    public static int adjustNumChops(Level level, BlockPos blockPos, BlockState blockState, int numChops, boolean destructive) {
        IChoppableBlock choppableBlock = ClassUtil.getChoppableBlock((BlockGetter)level, blockPos, blockState);
        if (choppableBlock != null) {
            if (destructive) {
                return numChops;
            }
            int currentNumChops = choppableBlock.getNumChops((BlockGetter)level, blockPos, blockState);
            int maxNondestructiveChops = choppableBlock.getMaxNumChops((BlockGetter)level, blockPos, blockState) - currentNumChops;
            return Math.min(maxNondestructiveChops, numChops);
        }
        return 0;
    }

    public static int getMaxNumChops(Level level, BlockPos blockPos, BlockState blockState) {
        IChoppableBlock choppableBlock = ClassUtil.getChoppableBlock((BlockGetter)level, blockPos, blockState);
        return choppableBlock != null ? choppableBlock.getMaxNumChops((BlockGetter)level, blockPos, blockState) : 0;
    }

    public static int getNumChops(Level level, BlockPos pos) {
        return ChopUtil.getNumChops(level, pos, level.m_8055_(pos));
    }

    public static int getNumChops(Level level, BlockPos pos, BlockState blockState) {
        int n;
        Block block = blockState.m_60734_();
        if (block instanceof IChoppableBlock) {
            IChoppableBlock choppableBlock = (IChoppableBlock)block;
            n = choppableBlock.getNumChops((BlockGetter)level, pos, blockState);
        } else {
            n = 0;
        }
        return n;
    }

    public static int getNumChops(Level level, Set<BlockPos> positions) {
        return positions.stream().map(pos -> Pair.of((Object)pos, (Object)level.m_8055_(pos))).map(posAndblockState -> {
            Integer n;
            Block patt16592$temp = ((BlockState)posAndblockState.getRight()).m_60734_();
            if (patt16592$temp instanceof IChoppableBlock) {
                IChoppableBlock choppableBlock = (IChoppableBlock)patt16592$temp;
                n = choppableBlock.getNumChops((BlockGetter)level, (BlockPos)posAndblockState.getLeft(), (BlockState)posAndblockState.getRight());
            } else {
                n = 0;
            }
            return n;
        }).reduce(Integer::sum).orElse(0);
    }

    private static ChopResult tryToChopWithoutFelling(Level level, BlockPos blockPos, int numChops) {
        return ChopUtil.isBlockChoppable(level, blockPos) ? new ChopResult(level, Collections.singletonList(new Chop(blockPos, numChops)), Collections.emptyList()) : ChopResult.IGNORED;
    }

    public static int chopDistance(BlockPos a, BlockPos b) {
        return a.m_123333_((Vec3i)b);
    }

    public static boolean canChopWithTool(Player player, Level level, BlockPos pos) {
        return ChopUtil.canChopWithTool(player, player.m_21205_(), level, pos, level.m_8055_(pos));
    }

    public static boolean canChopWithTool(Player player, ItemStack tool, Level level, BlockPos pos, BlockState blockState) {
        return !((Boolean)ConfigHandler.COMMON.mustUseCorrectToolForDrops.get() != false && blockState.m_60834_() && !tool.m_41735_(blockState) || (Boolean)ConfigHandler.COMMON.mustUseFastBreakingTool.get() != false && !(tool.m_41691_(blockState) > 1.0f) || !ConfigHandler.canChopWithTool(player, tool, level, pos, blockState));
    }

    public static int getNumChopsByTool(ItemStack tool, BlockState blockState) {
        IChoppingItem choppingItem = ClassUtil.getChoppingItem(tool.m_41720_());
        if (choppingItem != null) {
            return choppingItem.getNumChops(tool, blockState);
        }
        return 1;
    }

    public static boolean playerWantsToChop(Player player, ChopSettings chopSettings) {
        if (((Boolean)ConfigHandler.COMMON.enabled.get()).booleanValue() && (player != null && !player.m_7500_() || chopSettings.getChopInCreativeMode())) {
            return chopSettings.getChoppingEnabled() ^ chopSettings.getSneakBehavior().shouldChangeChopBehavior((Entity)player);
        }
        return false;
    }

    public static boolean playerWantsToFell(Player player, ChopSettings chopSettings) {
        return chopSettings.getFellingEnabled() ^ chopSettings.getSneakBehavior().shouldChangeFellBehavior((Entity)player);
    }

    public static boolean chop(ServerPlayer agent, ServerLevel level, BlockPos pos, BlockState blockState, ItemStack tool, Object trigger) {
        ChopSettings chopSettings = Server.instance().getPlayerChopData((Player)agent).getSettings();
        if (!(ChopUtil.isBlockChoppable((BlockGetter)level, pos, blockState) && ChopUtil.playerWantsToChop((Player)agent, chopSettings) && ChopUtil.canChopWithTool((Player)agent, tool, (Level)level, pos, blockState))) {
            return false;
        }
        ChopDataImpl chopData = new ChopDataImpl(ChopUtil.getNumChopsByTool(tool, blockState), ChopUtil.playerWantsToFell((Player)agent, chopSettings));
        boolean doChop = TreeChop.platform.startChopEvent(agent, level, pos, blockState, chopData, trigger);
        if (!doChop) {
            return false;
        }
        ChopResult chopResult = ChopUtil.getChopResult((Level)level, pos, chopSettings, chopData.getNumChops(), chopData.getFelling(), logPos -> ChopUtil.isBlockALog((Level)level, logPos));
        if (chopResult != ChopResult.IGNORED) {
            boolean felled = chopResult.apply(pos, agent, tool, (Boolean)ConfigHandler.COMMON.breakLeaves.get());
            TreeChop.platform.finishChopEvent(agent, level, pos, blockState, chopData, felled);
            tool.m_41686_((Level)level, blockState, pos, (Player)agent);
            return !felled;
        }
        return false;
    }

    public static BlockState getStrippedState(BlockAndTintGetter level, BlockPos pos, BlockState state) {
        return ChopUtil.getStrippedState(level, pos, state, state);
    }

    public static BlockState getStrippedState(BlockAndTintGetter level, BlockPos pos, BlockState state, BlockState fallback) {
        BlockState strippedState;
        BlockState blockState = strippedState = AxeAccessor.isStripped(state.m_60734_()) ? state : AxeAccessor.getStripped(state);
        if (strippedState == null && (strippedState = TreeChop.platform.getStrippedState(level, pos, state)) == null) {
            IStrippableBlock strippableBlock = ClassUtil.getStrippableBlock(state.m_60734_());
            if (strippableBlock != null) {
                return strippableBlock.getStrippedState((BlockGetter)level, pos, state);
            }
            strippedState = ConfigHandler.inferredStrippedStates.get().get(state.m_60734_());
        }
        return strippedState != null ? BlockUtil.copyStateProperties(strippedState, state) : fallback;
    }
}

