/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.compat;

import ht.treechop.TreeChop;
import ht.treechop.client.Client;
import ht.treechop.client.settings.ClientChopSettings;
import ht.treechop.common.block.ChoppedLogBlock;
import ht.treechop.common.registry.ForgeModBlocks;
import ht.treechop.compat.WailaUtil;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec2;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.IWailaClientRegistration;
import snownee.jade.api.IWailaPlugin;
import snownee.jade.api.WailaPlugin;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.IElement;

@WailaPlugin
public class Jade
implements IWailaPlugin,
IBlockComponentProvider {
    public static final ResourceLocation SHOW_TREE_BLOCKS = new ResourceLocation("treechop", "show_tree_block_counts");
    public static final ResourceLocation SHOW_NUM_CHOPS_REMAINING = new ResourceLocation("treechop", "show_num_chops_remaining");
    private static final ResourceLocation UID = TreeChop.resource("plugin");

    public void registerClient(IWailaClientRegistration registrar) {
        registrar.registerBlockComponent((IBlockComponentProvider)this, Block.class);
        registrar.registerBlockIcon((IBlockComponentProvider)this, ChoppedLogBlock.class);
        registrar.addConfig(SHOW_TREE_BLOCKS, true);
        registrar.addConfig(SHOW_NUM_CHOPS_REMAINING, true);
    }

    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        Jade.changeBlockName(tooltip, accessor);
        Level level = accessor.getLevel();
        BlockPos pos = accessor.getPosition();
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        ClientChopSettings chopSettings = Client.getChopSettings();
        boolean showNumBlocks = config.get(SHOW_TREE_BLOCKS);
        boolean showChopsRemaining = config.get(SHOW_NUM_CHOPS_REMAINING);
        if (WailaUtil.playerWantsTreeInfo(level, pos, (Player)player, chopSettings, showNumBlocks, showChopsRemaining)) {
            Optional tiles = Optional.empty();
            WailaUtil.addTreeInfo(level, pos, showNumBlocks, showChopsRemaining, arg_0 -> ((ITooltip)tooltip).add(arg_0), stack -> {
                IElement icon = tooltip.getElementHelper().item(stack, 1.0f, Integer.toString(stack.m_41613_()));
                tiles.orElseGet(LinkedList::new).add(icon.translate(new Vec2(0.0f, -1.5f)));
            });
        }
    }

    private static void changeBlockName(ITooltip tooltip, BlockAccessor accessor) {
        block3: {
            ResourceLocation OBJECT_NAME_COMPONENT_KEY = new ResourceLocation("somtin", "somtin");
            try {
                BlockEntity blockEntity = accessor.getBlockEntity();
                if (!(blockEntity instanceof ChoppedLogBlock.MyEntity)) break block3;
                ChoppedLogBlock.MyEntity choppedEntity = (ChoppedLogBlock.MyEntity)blockEntity;
                String choppedLogName = ((Block)ForgeModBlocks.CHOPPED_LOG.get()).m_49954_().getString();
                List siblings = ((IElement)tooltip.get(OBJECT_NAME_COMPONENT_KEY).get(0)).getMessage().m_7360_();
                int n = siblings.size();
                for (int i = 0; i < n; ++i) {
                    if (!((Component)siblings.get(i)).getString().matches(choppedLogName)) continue;
                    siblings.set(i, WailaUtil.getPrefixedBlockName(choppedEntity));
                    break;
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    public ResourceLocation getUid() {
        return UID;
    }
}

