/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.compat;

import com.mojang.blaze3d.vertex.PoseStack;
import ht.treechop.TreeChop;
import ht.treechop.common.block.ChoppedLogBlock;
import ht.treechop.common.settings.ChopSettings;
import ht.treechop.compat.WailaUtil;
import ht.treechop.server.Server;
import java.util.Optional;
import mcjty.theoneprobe.api.IElement;
import mcjty.theoneprobe.api.IElementFactory;
import mcjty.theoneprobe.api.IItemStyle;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ITextStyle;
import mcjty.theoneprobe.api.ITheOneProbe;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.apiimpl.elements.ElementHorizontal;
import mcjty.theoneprobe.apiimpl.elements.ElementItemLabel;
import mcjty.theoneprobe.apiimpl.elements.ElementText;
import mcjty.theoneprobe.apiimpl.elements.ElementVertical;
import mcjty.theoneprobe.apiimpl.styles.TextStyle;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class TheOneProbeInfoProvider
implements IProbeInfoProvider {
    private static final boolean SHOW_TREE_BLOCKS = true;
    private static final boolean SHOW_NUM_CHOPS_REMAINING = true;
    private static final ResourceLocation ID = TreeChop.resource("tree_info");
    private static ITheOneProbe theProbe;

    public static Void register(ITheOneProbe probe) {
        theProbe = probe;
        probe.registerProvider((IProbeInfoProvider)new TheOneProbeInfoProvider());
        probe.registerElementFactory(new IElementFactory(){

            public IElement createElement(FriendlyByteBuf buffer) {
                return DeferredTreeDataElement.decode(buffer);
            }

            public ResourceLocation getId() {
                return ID;
            }
        });
        return null;
    }

    public ResourceLocation getID() {
        return ID;
    }

    public void addProbeInfo(ProbeMode probeMode, IProbeInfo builder, Player player, Level level, BlockState blockState, IProbeHitData iProbeHitData) {
        this.changeBlockName(builder, level, iProbeHitData.getPos());
        BlockPos blockPos = iProbeHitData.getPos();
        ChopSettings chopSettings = Server.instance().getPlayerChopData(player).getSettings();
        if (WailaUtil.playerWantsTreeInfo(level, blockPos, player, chopSettings, true, true)) {
            builder.element((IElement)new DeferredTreeDataElement(iProbeHitData.getPos()));
        }
    }

    private void changeBlockName(IProbeInfo builder, Level level, BlockPos pos) {
        try {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof ChoppedLogBlock.MyEntity) {
                ElementVertical blockNameAndMod;
                Object e;
                ElementHorizontal iconAndBlockInfo;
                Object e2;
                ChoppedLogBlock.MyEntity choppedEntity = (ChoppedLogBlock.MyEntity)blockEntity;
                Object e3 = builder.getElements().get(0);
                if (e3 instanceof ElementHorizontal && (e2 = (iconAndBlockInfo = (ElementHorizontal)e3).getElements().get(1)) instanceof ElementVertical && (e = (blockNameAndMod = (ElementVertical)e2).getElements().get(0)) instanceof ElementItemLabel) {
                    ElementItemLabel label = (ElementItemLabel)e;
                    blockNameAndMod.getElements().set(0, new ElementText((Component)WailaUtil.getPrefixedBlockName(choppedEntity), (ITextStyle)new TextStyle().height(Integer.valueOf(label.getHeight()))));
                }
            }
        }
        catch (NoClassDefFoundError | NoSuchMethodError | NullPointerException throwable) {
            // empty catch block
        }
    }

    private static void addTreeDataElements(IProbeInfo builder, Level level, BlockPos blockPos) {
        IItemStyle itemStyle = builder.defaultItemStyle();
        Optional tiles = Optional.empty();
        WailaUtil.addTreeInfo(level, blockPos, true, true, arg_0 -> ((IProbeInfo)builder).text(arg_0), stack -> tiles.orElseGet(() -> ((IProbeInfo)builder).horizontal()).item(stack, itemStyle));
    }

    private record DeferredTreeDataElement(BlockPos pos) implements IElement
    {
        public void toBytes(FriendlyByteBuf buffer) {
            buffer.m_130064_(this.pos);
        }

        public static IElement decode(FriendlyByteBuf buffer) {
            ElementVertical elements = new ElementVertical(theProbe.getStyleManager().layoutStylePadded(2));
            BlockPos pos = buffer.m_130135_();
            TheOneProbeInfoProvider.addTreeDataElements((IProbeInfo)elements, (Level)Minecraft.m_91087_().f_91073_, pos);
            return elements;
        }

        public ResourceLocation getID() {
            return ID;
        }

        public void render(PoseStack poseStack, int i, int i1) {
        }

        public int getWidth() {
            return 0;
        }

        public int getHeight() {
            return 0;
        }
    }
}

