/*
 * Decompiled with CFR 0.152.
 */
package ht.tuber.graph;

import ht.tuber.graph.DirectedGraph;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

public abstract class AbstractGraph<T>
implements DirectedGraph<T> {
    private final Map<T, List<T>> nodesAndEdges;

    public AbstractGraph() {
        this(new HashMap());
    }

    public AbstractGraph(Map<T, List<T>> nodesAndEdges) {
        this.nodesAndEdges = nodesAndEdges;
    }

    @Override
    public Stream<T> getNeighbors(T node) {
        List<T> neighbors = this.nodesAndEdges.get(node);
        return neighbors != null ? neighbors.stream() : Stream.empty();
    }

    protected void add(T lower, T upper) {
        List neighbors = this.nodesAndEdges.computeIfAbsent(lower, k -> new ArrayList());
        if (!neighbors.contains(upper)) {
            neighbors.add(upper);
        }
    }
}

