/*
 * Decompiled with CFR 0.152.
 */
package ht.tuber.graph;

import ht.tuber.graph.DirectedGraph;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class FilteredGraph<T>
implements DirectedGraph<T> {
    private final DirectedGraph<T> source;
    private final Predicate<T> condition;

    public FilteredGraph(DirectedGraph<T> graph, Predicate<T> condition) {
        this.source = graph;
        this.condition = condition;
    }

    @Override
    public Stream<T> getNeighbors(T node) {
        if (this.condition.test(node)) {
            return this.source.getNeighbors(node).filter(this.condition);
        }
        return Stream.empty();
    }
}

