/*
 * Decompiled with CFR 0.152.
 */
package ht.tuber.graph;

import ht.tuber.graph.DirectedGraph;
import ht.tuber.graph.FloodFill;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class FloodFillImpl<T>
implements FloodFill<T> {
    private final DirectedGraph<T> graph;
    private final Predicate<T> filter;
    private final Set<T> memory = new HashSet<T>();
    private final Queue<T> nextNodes = new ArrayDeque<T>();

    public FloodFillImpl(DirectedGraph<T> graph, Predicate<T> filter) {
        this.graph = graph;
        this.filter = filter;
    }

    @Override
    public Stream<T> fill(T start) {
        return this.fill((Collection<T>)List.of(start));
    }

    @Override
    public Stream<T> fill(Collection<T> starts) {
        starts.forEach(this::visitNode);
        return Stream.iterate(this.nextNodes.poll(), Objects::nonNull, ignored -> this.nextNodes.poll()).peek(node -> this.graph.getNeighbors(node).forEach(neighbor -> {
            if (!this.memory.contains(neighbor)) {
                this.visitNode(neighbor);
            }
        }));
    }

    private void visitNode(T node) {
        this.memory.add(node);
        if (this.filter.test(node)) {
            this.nextNodes.add(node);
        }
    }
}

