/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.client.gui.element;

import ht.treechop.client.gui.element.NestedGui;
import ht.treechop.client.gui.util.GUIUtil;
import ht.treechop.client.gui.widget.StickyWidget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.class_2561;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4587;
import net.minecraft.class_6382;

public class ExclusiveButtonsGui
extends NestedGui {
    private final List<class_339> widgets;
    private final Supplier<class_2561> tooltipSupplier;

    protected ExclusiveButtonsGui(Collection<class_339> widgets, Supplier<class_2561> tooltipSupplier) {
        super(0, 0, 0, 0, (class_2561)class_2561.method_43473());
        this.widgets = new ArrayList<class_339>(widgets);
        this.tooltipSupplier = tooltipSupplier;
    }

    @Override
    public void expand(int width) {
        if (this.getMinimumWidth() < width) {
            int targetWidth = width / this.widgets.size();
            List smallerWidgets = this.widgets.stream().filter(widget -> widget.method_25368() <= targetWidth).collect(Collectors.toList());
            List biggerWidgets = this.widgets.stream().filter(widget -> widget.method_25368() > targetWidth).collect(Collectors.toList());
            int totalWidthForSmallers = width - biggerWidgets.stream().map(class_339::method_25368).reduce(Integer::sum).orElse(0);
            int i = 0;
            for (class_339 widget2 : smallerWidgets) {
                double lower = (double)i / (double)smallerWidgets.size();
                double upper = (double)(i + 1) / (double)smallerWidgets.size();
                int widgetWidth = (int)((double)totalWidthForSmallers * (upper - lower));
                widget2.method_25358(widgetWidth);
                ++i;
            }
        }
    }

    public List<? extends class_364> method_25396() {
        return this.widgets;
    }

    public void method_48579(class_4587 poseStack, int mouseX, int mouseY, float partialTicks) {
        int x = this.getBox().getLeft();
        int y = this.getBox().getTop();
        int maxX = x;
        int maxY = y;
        for (class_339 widget : this.widgets) {
            widget.method_46421(maxX);
            widget.method_46419(y);
            widget.method_25394(poseStack, mouseX, mouseY, partialTicks);
            maxX = Math.max(maxX, maxX + widget.method_25368());
            maxY = Math.max(maxY, y + widget.method_25364());
        }
        boolean bl = this.field_22762 = mouseX >= x && mouseY >= y && mouseX < maxX && mouseY < maxY;
        if (this.method_25367()) {
            GUIUtil.showTooltip(mouseX, mouseY, this.tooltipSupplier.get());
        }
    }

    @Override
    public int getMinimumWidth() {
        return this.widgets.stream().map(class_339::method_25368).reduce(Integer::sum).orElse(0);
    }

    @Override
    public int getMinimumHeight() {
        return this.widgets.stream().map(class_339::method_25364).reduce(Integer::max).orElse(0);
    }

    protected void method_47399(class_6382 narrationElementOutput) {
    }

    public static class Builder {
        private final List<Option> options = new LinkedList<Option>();

        public Builder add(class_2561 name, Runnable onPress, Supplier<StickyWidget.State> stateSupplier) {
            this.options.add(new Option(name, onPress, stateSupplier));
            return this;
        }

        public ExclusiveButtonsGui build(Supplier<class_2561> tooltipSupplier) {
            List<class_339> widgets = this.options.stream().map(option -> new StickyWidget(0, 0, 0, 0, option.name, option.onPress, option.stateSupplier)).collect(Collectors.toList());
            return new ExclusiveButtonsGui(widgets, tooltipSupplier);
        }

        private static class Option {
            private final class_2561 name;
            private final Runnable onPress;
            private final Supplier<StickyWidget.State> stateSupplier;

            public Option(class_2561 name, Runnable onPress, Supplier<StickyWidget.State> stateSupplier) {
                this.name = name;
                this.onPress = onPress;
                this.stateSupplier = stateSupplier;
            }
        }
    }
}

