/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.common.chop;

import ht.treechop.TreeChop;
import ht.treechop.api.IChoppableBlock;
import ht.treechop.api.IChoppingItem;
import ht.treechop.api.IFellableBlock;
import ht.treechop.api.IStrippableBlock;
import ht.treechop.api.TreeData;
import ht.treechop.common.block.ChoppedLogBlock;
import ht.treechop.common.chop.Chop;
import ht.treechop.common.chop.ChopDataImpl;
import ht.treechop.common.chop.ChopResult;
import ht.treechop.common.chop.ChopTreeResult;
import ht.treechop.common.chop.FellTreeResult;
import ht.treechop.common.chop.LazyTreeData;
import ht.treechop.common.config.ChopCounting;
import ht.treechop.common.config.ConfigHandler;
import ht.treechop.common.settings.ChopSettings;
import ht.treechop.common.util.AxeAccessor;
import ht.treechop.common.util.BlockNeighbors;
import ht.treechop.common.util.BlockUtil;
import ht.treechop.common.util.ClassUtil;
import ht.treechop.common.util.TreeDataImpl;
import ht.treechop.server.Server;
import ht.tuber.graph.DirectedGraph;
import ht.tuber.graph.GraphUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2397;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class ChopUtil {
    public static boolean isBlockALog(class_1937 level, class_2338 pos) {
        return ChopUtil.isBlockALog(level, pos, level.method_8320(pos));
    }

    public static boolean isBlockALog(class_1937 level, class_2338 pos, class_2680 blockState) {
        return ChopUtil.isBlockChoppable((class_1922)level, pos, blockState);
    }

    public static boolean isBlockChoppable(class_1937 level, class_2338 pos) {
        return ChopUtil.isBlockChoppable((class_1922)level, pos, level.method_8320(pos));
    }

    public static boolean isBlockChoppable(class_1922 level, class_2338 pos, class_2680 blockState) {
        return ClassUtil.getChoppableBlock(level, pos, blockState) != null;
    }

    public static boolean isBlockLeaves(class_1937 level, class_2338 pos) {
        return ChopUtil.isBlockLeaves(level.method_8320(pos));
    }

    public static boolean isBlockLeaves(class_2680 blockState) {
        if (ConfigHandler.COMMON.leavesBlocks.get().contains(blockState.method_26204())) {
            return (Boolean)ConfigHandler.COMMON.ignorePersistentLeaves.get() == false || !blockState.method_28498((class_2769)class_2397.field_11200) || (Boolean)blockState.method_11654((class_2769)class_2397.field_11200) == false;
        }
        return false;
    }

    public static boolean enoughChopsToFell(int chops, double support) {
        return ChopCounting.calculate((int)support) <= chops;
    }

    public static int numChopsToFell(class_1937 level, Stream<class_2338> logs) {
        int support = Math.max(logs.map(pos -> ChopUtil.getSupportFactor(level, pos)).reduce(Double::sum).orElse(1.0).intValue(), 1);
        return ChopCounting.calculate(support);
    }

    public static Optional<Double> getSupportFactor(class_1937 level, Stream<class_2338> blocks) {
        return blocks.map(pos -> ChopUtil.getSupportFactor(level, pos)).reduce(Double::sum);
    }

    public static double getSupportFactor(class_1937 level, class_2338 pos) {
        return ChopUtil.getSupportFactor(level, pos, level.method_8320(pos));
    }

    private static double getSupportFactor(class_1937 level, class_2338 pos, class_2680 state) {
        double d;
        class_2248 class_22482 = level.method_8320(pos).method_26204();
        if (class_22482 instanceof IFellableBlock) {
            IFellableBlock block = (IFellableBlock)class_22482;
            d = block.getSupportFactor((class_1922)level, pos, state);
        } else {
            d = 1.0;
        }
        return d;
    }

    public static ChopResult getChopResult(class_1937 level, class_2338 origin, ChopSettings chopSettings, int numChops, boolean fellIfPossible) {
        return fellIfPossible ? ChopUtil.getChopResult(level, origin, chopSettings, numChops) : ChopUtil.tryToChopWithoutFelling(level, origin, numChops);
    }

    private static ChopResult getChopResult(class_1937 level, class_2338 origin, ChopSettings chopSettings, int numChops) {
        DirectedGraph<class_2338> world = BlockNeighbors.HORIZONTAL_AND_ABOVE::asStream;
        Set<class_2338> base = ChopUtil.getTreeBase(level, origin);
        int baseChops = base.stream().map(pos -> ChopUtil.getNumChops(level, pos)).reduce(Integer::sum).orElse(0);
        Predicate<class_2338> logFilter = pos -> ChopUtil.isBlockALog(level, pos);
        TreeData tree = ChopUtil.getTree(level, origin, base, world, logFilter, pos -> ChopUtil.isBlockLeaves(level, pos), (Integer)ConfigHandler.COMMON.maxNumTreeBlocks.get(), baseChops);
        if (tree.isAProperTree(chopSettings.getTreesMustHaveLeaves())) {
            return ChopUtil.getChopResult(level, origin, tree, base, world, logFilter, numChops);
        }
        return ChopResult.IGNORED;
    }

    public static TreeData getTree(class_1937 level, class_2338 blockPos, int maxNumTreeBlocks) {
        Set<class_2338> base = ChopUtil.getTreeBase(level, blockPos);
        int baseChops = base.stream().map(pos -> ChopUtil.getNumChops(level, pos)).reduce(Integer::sum).orElse(0);
        return ChopUtil.getTree(level, blockPos, base, BlockNeighbors.HORIZONTAL_AND_ABOVE::asStream, pos -> ChopUtil.isBlockALog(level, pos), pos -> ChopUtil.isBlockLeaves(level, pos), maxNumTreeBlocks, baseChops);
    }

    public static TreeData getTree(class_1937 level, class_2338 origin, Set<class_2338> base, DirectedGraph<class_2338> world, Predicate<class_2338> logFilter, Predicate<class_2338> leavesFilter, int maxNumTreeBlocks, int numChops) {
        if (base.isEmpty()) {
            return TreeDataImpl.empty(level);
        }
        LazyTreeData treeData = new LazyTreeData(level, base, world, logFilter, leavesFilter, maxNumTreeBlocks, numChops);
        return TreeChop.platform.detectTreeEvent(level, null, origin, level.method_8320(origin), treeData);
    }

    @NotNull
    private static Set<class_2338> getTreeBase(class_1937 level, class_2338 blockPos) {
        HashSet<class_2338> base = new HashSet<class_2338>();
        if (ChopUtil.isBlockChoppable(level, blockPos)) {
            DirectedGraph<class_2338> adjacentWorld = BlockNeighbors.ADJACENTS_AND_DIAGONALS::asStream;
            base.add(blockPos);
            GraphUtil.flood(GraphUtil.filterNeighbors(adjacentWorld, pos -> ChopUtil.getNumChops(level, pos) > 0), blockPos, class_2382::method_10264).fill().forEach(base::add);
        }
        return base;
    }

    private static ChopResult getChopResult(class_1937 level, class_2338 origin, TreeData tree, Set<class_2338> base, DirectedGraph<class_2338> world, Predicate<class_2338> logFilter, int numChops) {
        if (tree.streamLogs().findFirst().isEmpty()) {
            return ChopResult.IGNORED;
        }
        if (tree.readyToFell(tree.getChops() + numChops)) {
            return new FellTreeResult(level, tree);
        }
        return new ChopTreeResult(level, ChopUtil.spillChops(level, origin, base, world, logFilter, numChops));
    }

    private static List<Chop> spillChops(class_1937 level, class_2338 origin, Set<class_2338> base, DirectedGraph<class_2338> treeGraph, Predicate<class_2338> logFilter, int numChops) {
        Stack<Chop> chops = new Stack<Chop>();
        AtomicInteger chopsLeft = new AtomicInteger(numChops);
        if (chopsLeft.get() > 0) {
            GraphUtil.flood(GraphUtil.filter(treeGraph, logFilter), base, a -> ChopUtil.blockDistance(origin, a) * 32 + RandomUtils.nextInt((int)0, (int)32)).fill().takeWhile(pos -> {
                chopsLeft.set(ChopUtil.gatherChopAndGetNumChopsRemaining(level, pos, chopsLeft.get(), chops));
                return chopsLeft.get() > 0;
            }).count();
        }
        return chops;
    }

    private static int gatherChopAndGetNumChopsRemaining(class_1937 level, class_2338 targetPos, int numChops, List<Chop> choppedBlocks) {
        class_2680 blockStateBeforeChopping = level.method_8320(targetPos);
        if (!(blockStateBeforeChopping.method_26204() instanceof IChoppableBlock) && ChopUtil.isBlockSurrounded(level, targetPos)) {
            return numChops;
        }
        int adjustedNumChops = ChopUtil.adjustNumChops(level, targetPos, blockStateBeforeChopping, numChops, false);
        if (adjustedNumChops > 0) {
            choppedBlocks.add(new Chop(targetPos, adjustedNumChops));
        }
        return numChops - adjustedNumChops;
    }

    private static boolean isBlockSurrounded(class_1937 level, class_2338 pos) {
        return Stream.of(pos.method_10067(), pos.method_10095(), pos.method_10078(), pos.method_10072()).allMatch(neighborPos -> ChopUtil.isBlockALog(level, neighborPos));
    }

    public static int adjustNumChops(class_1937 level, class_2338 blockPos, class_2680 blockState, int numChops, boolean destructive) {
        IChoppableBlock choppableBlock = ClassUtil.getChoppableBlock((class_1922)level, blockPos, blockState);
        if (choppableBlock != null) {
            if (destructive) {
                return numChops;
            }
            int currentNumChops = choppableBlock.getNumChops((class_1922)level, blockPos, blockState);
            int maxNondestructiveChops = choppableBlock.getMaxNumChops((class_1922)level, blockPos, blockState) - currentNumChops;
            return Math.min(maxNondestructiveChops, numChops);
        }
        return 0;
    }

    public static int getMaxNumChops(class_1937 level, class_2338 blockPos, class_2680 blockState) {
        IChoppableBlock choppableBlock = ClassUtil.getChoppableBlock((class_1922)level, blockPos, blockState);
        return choppableBlock != null ? choppableBlock.getMaxNumChops((class_1922)level, blockPos, blockState) : 0;
    }

    public static int getNumChops(class_1937 level, class_2338 pos) {
        return ChopUtil.getNumChops(level, pos, level.method_8320(pos));
    }

    public static int getNumChops(class_1937 level, class_2338 pos, class_2680 blockState) {
        int n;
        class_2248 block = blockState.method_26204();
        if (block instanceof IChoppableBlock) {
            IChoppableBlock choppableBlock = (IChoppableBlock)block;
            n = choppableBlock.getNumChops((class_1922)level, pos, blockState);
        } else {
            n = 0;
        }
        return n;
    }

    public static int getNumChops(class_1937 level, Set<class_2338> positions) {
        return positions.stream().map(pos -> Pair.of((Object)pos, (Object)level.method_8320(pos))).map(posAndblockState -> {
            Integer n;
            class_2248 patt10545$temp = ((class_2680)posAndblockState.getRight()).method_26204();
            if (patt10545$temp instanceof IChoppableBlock) {
                IChoppableBlock choppableBlock = (IChoppableBlock)patt10545$temp;
                n = choppableBlock.getNumChops((class_1922)level, (class_2338)posAndblockState.getLeft(), (class_2680)posAndblockState.getRight());
            } else {
                n = 0;
            }
            return n;
        }).reduce(Integer::sum).orElse(0);
    }

    private static ChopResult tryToChopWithoutFelling(class_1937 level, class_2338 blockPos, int numChops) {
        return ChopUtil.isBlockChoppable(level, blockPos) ? new ChopTreeResult(level, Collections.singletonList(new Chop(blockPos, numChops))) : ChopResult.IGNORED;
    }

    public static int blockDistance(class_2338 a, class_2338 b) {
        return a.method_19455((class_2382)b);
    }

    public static int horizontalBlockDistance(class_2338 a, class_2338 b) {
        return new class_2382(a.method_10263(), 0, a.method_10260()).method_19455(new class_2382(b.method_10263(), 0, b.method_10260()));
    }

    public static boolean canChopWithTool(class_1657 player, class_1937 level, class_2338 pos) {
        return ChopUtil.canChopWithTool(player, player.method_6047(), level, pos, level.method_8320(pos));
    }

    public static boolean canChopWithTool(class_1657 player, class_1799 tool, class_1937 level, class_2338 pos, class_2680 blockState) {
        return !((Boolean)ConfigHandler.COMMON.mustUseCorrectToolForDrops.get() != false && blockState.method_29291() && !tool.method_7951(blockState) || (Boolean)ConfigHandler.COMMON.mustUseFastBreakingTool.get() != false && !(tool.method_7924(blockState) > 1.0f) || !ConfigHandler.canChopWithTool(player, tool, level, pos, blockState));
    }

    public static int getNumChopsByTool(class_1799 tool, class_2680 blockState) {
        IChoppingItem choppingItem = ClassUtil.getChoppingItem(tool.method_7909());
        if (choppingItem != null) {
            return choppingItem.getNumChops(tool, blockState);
        }
        return 1;
    }

    public static boolean playerWantsToChop(class_1657 player, ChopSettings chopSettings) {
        if (((Boolean)ConfigHandler.COMMON.enabled.get()).booleanValue() && (player != null && !player.method_7337() || chopSettings.getChopInCreativeMode())) {
            return chopSettings.getChoppingEnabled() ^ chopSettings.getSneakBehavior().shouldChangeChopBehavior((class_1297)player);
        }
        return false;
    }

    public static boolean playerWantsToFell(class_1657 player, ChopSettings chopSettings) {
        return chopSettings.getFellingEnabled() ^ chopSettings.getSneakBehavior().shouldChangeFellBehavior((class_1297)player);
    }

    public static boolean chop(class_3222 agent, class_3218 level, class_2338 pos, class_2680 blockState, class_1799 tool, Object trigger) {
        ChopSettings chopSettings = Server.instance().getPlayerChopData((class_1657)agent).getSettings();
        if (!(ChopUtil.isBlockChoppable((class_1922)level, pos, blockState) && ChopUtil.playerWantsToChop((class_1657)agent, chopSettings) && ChopUtil.canChopWithTool((class_1657)agent, tool, (class_1937)level, pos, blockState))) {
            return false;
        }
        ChopDataImpl chopData = new ChopDataImpl(ChopUtil.getNumChopsByTool(tool, blockState), ChopUtil.playerWantsToFell((class_1657)agent, chopSettings));
        boolean doChop = TreeChop.platform.startChopEvent(agent, level, pos, blockState, chopData, trigger);
        if (!doChop) {
            return false;
        }
        ChopResult chopResult = ChopUtil.getChopResult((class_1937)level, pos, chopSettings, chopData.getNumChops(), chopData.getFelling());
        if (chopResult != ChopResult.IGNORED) {
            chopResult.apply(pos, agent, tool, (Boolean)ConfigHandler.COMMON.breakLeaves.get());
            TreeChop.platform.finishChopEvent(agent, level, pos, blockState, chopData, chopResult);
            tool.method_7952((class_1937)level, blockState, pos, (class_1657)agent);
            boolean felled = chopResult instanceof FellTreeResult;
            return !felled;
        }
        return false;
    }

    public static class_2680 getStrippedState(class_1920 level, class_2338 pos, class_2680 state) {
        return ChopUtil.getStrippedState(level, pos, state, state);
    }

    public static class_2680 getStrippedState(class_1920 level, class_2338 pos, class_2680 state, class_2680 fallback) {
        class_2680 strippedState;
        class_2680 class_26802 = strippedState = AxeAccessor.isStripped(state.method_26204()) ? state : AxeAccessor.getStripped(state);
        if (strippedState == null && (strippedState = TreeChop.platform.getStrippedState(level, pos, state)) == null) {
            IStrippableBlock strippableBlock = ClassUtil.getStrippableBlock(state.method_26204());
            if (strippableBlock != null) {
                return strippableBlock.getStrippedState((class_1922)level, pos, state);
            }
            strippedState = ConfigHandler.inferredStrippedStates.get().get(state.method_26204());
        }
        return strippedState != null ? BlockUtil.copyStateProperties(strippedState, state) : fallback;
    }

    public static class_2248 getLogBlock(class_1937 level, class_2338 pos) {
        return ChopUtil.getLogBlock(level, pos, level.method_8320(pos));
    }

    public static class_2248 getLogBlock(class_1937 level, class_2338 pos, class_2680 state) {
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof ChoppedLogBlock.MyEntity) {
            ChoppedLogBlock.MyEntity entity = (ChoppedLogBlock.MyEntity)class_25862;
            return entity.getOriginalState().method_26204();
        }
        return state.method_26204();
    }
}

