/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.common.chop;

import ht.treechop.api.TreeData;
import ht.treechop.common.chop.ChopResult;
import java.util.Comparator;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1934;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2397;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3610;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class FellTreeResult
implements ChopResult {
    public static final int MAX_NUM_FELLING_EFFECTS = 32;
    private final class_1937 level;
    private final TreeData tree;

    public FellTreeResult(class_1937 level, TreeData tree) {
        this.level = level;
        this.tree = tree;
    }

    @Override
    public void apply(class_2338 targetPos, class_3222 player, class_1799 tool, boolean breakLeaves) {
        class_3218 serverLevel;
        class_1934 gameType = player.field_13974.method_14257();
        class_1937 class_19372 = this.level;
        if (class_19372 instanceof class_3218 && !(serverLevel = (class_3218)class_19372).method_8320(targetPos).method_26215() && !player.method_21701((class_1937)serverLevel, targetPos, gameType)) {
            Consumer<class_2338> blockBreaker = FellTreeResult.makeBlockBreaker(player, serverLevel);
            this.breakLogs(player, serverLevel, gameType, blockBreaker, targetPos);
            if (breakLeaves) {
                this.breakLeaves(player, serverLevel, gameType, blockBreaker);
            }
        }
    }

    @NotNull
    private static Consumer<class_2338> makeBlockBreaker(class_3222 player, class_3218 level) {
        if (player.method_7337()) {
            class_2680 air = class_2246.field_10124.method_9564();
            return pos -> level.method_8501(pos, air);
        }
        return pos -> FellTreeResult.harvestWorldBlock(null, (class_1937)level, pos, class_1799.field_8037);
    }

    private void breakLogs(class_3222 player, class_3218 level, class_1934 gameType, Consumer<class_2338> blockBreaker, class_2338 targetPos) {
        long maxNumEffects = 4L;
        AtomicInteger i = new AtomicInteger(0);
        PriorityQueue<Pair> effects = new PriorityQueue<Pair>(Comparator.comparing(pair -> ((class_2338)pair.getLeft()).method_10264()));
        this.tree.streamLogs().filter(pos -> !pos.equals((Object)targetPos) && !player.method_21701((class_1937)level, targetPos, gameType)).forEach(pos -> {
            FellTreeResult.collectSomeBlocks(effects, pos, level.method_8320(pos), i, 3);
            blockBreaker.accept((class_2338)pos);
        });
        effects.stream().limit(4L).forEach(posState -> FellTreeResult.playBlockBreakEffects((class_1937)level, (class_2338)posState.getLeft(), (class_2680)posState.getRight()));
    }

    private void breakLeaves(class_3222 player, class_3218 level, class_1934 gameType, Consumer<class_2338> blockBreaker) {
        long maxNumEffects = 5L;
        AtomicInteger i = new AtomicInteger(0);
        PriorityQueue<Pair> effects = new PriorityQueue<Pair>(Comparator.comparing(pair -> ((class_2338)pair.getLeft()).method_10264()));
        Consumer<class_2338> leavesBreaker = pos -> {
            if (!player.method_21701((class_1937)level, pos, gameType)) {
                class_2680 state = level.method_8320(pos);
                if (FellTreeResult.isVanillaLeaves(state)) {
                    this.decayLeavesInsteadOfBreaking(level, (class_2338)pos, state);
                } else {
                    blockBreaker.accept((class_2338)pos);
                }
                if (player.method_5707(pos.method_46558()) > 9.0) {
                    FellTreeResult.collectSomeBlocks(effects, pos, state, i, 8);
                }
            }
        };
        this.tree.streamLeaves().forEach(leavesBreaker);
        effects.stream().limit(5L).forEach(posState -> FellTreeResult.playBlockBreakEffects((class_1937)level, (class_2338)posState.getLeft(), (class_2680)posState.getRight()));
    }

    private static void collectSomeBlocks(Queue<Pair<class_2338, class_2680>> collection, class_2338 pos, class_2680 state, AtomicInteger counter, int period) {
        if (counter.getAndIncrement() % period == 0) {
            collection.add((Pair<class_2338, class_2680>)Pair.of((Object)pos, (Object)state));
        }
    }

    private static void playBlockBreakEffects(class_1937 level, class_2338 pos, class_2680 state) {
        level.method_20290(2001, pos, class_2248.method_9507((class_2680)state));
    }

    private static void harvestWorldBlock(class_1297 agent, class_1937 level, class_2338 pos, class_1799 tool) {
        class_2680 blockState = level.method_8320(pos);
        if (level instanceof class_3218) {
            class_3610 fluidStateOrAir = level.method_8316(pos);
            blockState.method_26204().method_9585((class_1936)level, pos, blockState);
            class_2248.method_9511((class_2680)blockState, (class_1937)level, (class_2338)pos, (class_2586)level.method_8321(pos), (class_1297)agent, (class_1799)tool);
            level.method_8501(pos, fluidStateOrAir.method_15759());
        }
    }

    private void decayLeavesInsteadOfBreaking(class_3218 level, class_2338 pos, class_2680 state) {
        class_2680 decayingState = (class_2680)((class_2680)state.method_11657((class_2769)class_2397.field_11200, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)class_2397.field_11199, (Comparable)Integer.valueOf(7));
        decayingState.method_26199(level, pos, level.field_9229);
    }

    private static boolean isVanillaLeaves(class_2680 blockState) {
        return blockState.method_28498((class_2769)class_2397.field_11199);
    }
}

