/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.common.chop;

import ht.treechop.api.AbstractTreeData;
import ht.treechop.common.chop.ChopUtil;
import ht.treechop.common.config.ConfigHandler;
import ht.treechop.common.util.BlockNeighbors;
import ht.tuber.graph.DirectedGraph;
import ht.tuber.graph.FloodFill;
import ht.tuber.graph.FloodFillImpl;
import ht.tuber.graph.GraphUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2397;
import net.minecraft.class_2680;
import net.minecraft.class_2769;

public class LazyTreeData
extends AbstractTreeData {
    private final class_1937 level;
    private final int chops;
    private final int maxNumLogs;
    private double mass = 0.0;
    private boolean overrideLeaves = false;
    private Set<class_2338> logs = new HashSet<class_2338>(){

        @Override
        public boolean add(class_2338 blockPos) {
            if (super.add(blockPos)) {
                LazyTreeData.this.mass += ChopUtil.getSupportFactor(LazyTreeData.this.level, blockPos);
                return true;
            }
            return false;
        }
    };
    private final Set<class_2338> leaves = new HashSet<class_2338>(){

        @Override
        public boolean add(class_2338 blockPos) {
            return super.add(blockPos);
        }
    };
    private FloodFill<class_2338> generator;

    public LazyTreeData(class_1937 level, Collection<class_2338> base, DirectedGraph<class_2338> logGraph, Predicate<class_2338> logFilter, Predicate<class_2338> leavesFilter, int maxNumLogs, int chops) {
        this.level = level;
        this.chops = chops;
        this.maxNumLogs = maxNumLogs;
        this.logs.addAll(base);
        DirectedGraph<class_2338> world = GraphUtil.filter(logGraph, this::gatherLog, pos -> this.check((class_2338)pos, logFilter, leavesFilter));
        this.generator = GraphUtil.flood(world, base, class_2382::method_10264);
    }

    private boolean gatherLog(class_2338 pos) {
        this.logs.add(pos);
        return true;
    }

    private boolean check(class_2338 pos, Predicate<class_2338> logFilter, Predicate<class_2338> leavesFilter) {
        if (leavesFilter.test(pos)) {
            this.leaves.add(pos);
        }
        return logFilter.test(pos);
    }

    @Override
    public boolean hasLeaves() {
        if (this.overrideLeaves || !this.leaves.isEmpty()) {
            return true;
        }
        return this.generator.fill().anyMatch(p -> !this.leaves.isEmpty() || this.overrideLeaves);
    }

    @Override
    public void setLogBlocks(Set<class_2338> logBlocks) {
        this.logs = logBlocks;
        this.mass = ChopUtil.getSupportFactor(this.level, this.logs.stream()).orElse(1.0);
        this.generator = new FloodFillImpl<class_2338>(List.of(), a -> Stream.empty(), a -> 0);
    }

    @Override
    public void setLeaves(boolean hasLeaves) {
        this.overrideLeaves = hasLeaves;
    }

    @Override
    public Stream<class_2338> streamLogs() {
        return Stream.concat(this.logs.stream(), this.generator.fill()).limit(this.maxNumLogs);
    }

    @Override
    public Stream<class_2338> streamLeaves() {
        this.streamLogs().forEach(a -> {});
        LinkedList<class_2338> allLeaves = new LinkedList<class_2338>();
        this.forEachLeaves(allLeaves, allLeaves::add);
        return allLeaves.stream();
    }

    private void forEachLeaves(List<class_2338> firstLeaves, Consumer<class_2338> forEach) {
        this.leaves.stream().filter(pos -> this.leavesHasExactDistance(this.level.method_8320(pos), 1)).forEach(forEach);
        AtomicInteger distance = new AtomicInteger();
        DirectedGraph<class_2338> distancedLeavesGraph = GraphUtil.filterNeighbors(BlockNeighbors.ADJACENTS::asStream, pos -> {
            class_2680 state = this.level.method_8320(pos);
            return ChopUtil.isBlockLeaves(state) && this.leavesHasAtLeastDistance(state, distance.get());
        });
        FloodFillImpl<class_2338> flood = new FloodFillImpl<class_2338>(firstLeaves, distancedLeavesGraph, a -> 0);
        int maxDistance = (Integer)ConfigHandler.COMMON.maxBreakLeavesDistance.get();
        for (int i = 2; i < maxDistance; ++i) {
            distance.set(i);
            flood.fillOnce(forEach);
        }
    }

    @Override
    public boolean readyToFell(int numChops) {
        if (!ChopUtil.enoughChopsToFell(numChops, this.mass)) {
            return false;
        }
        return this.generator.fill().allMatch(ignored -> ChopUtil.enoughChopsToFell(numChops, this.mass));
    }

    @Override
    public int getChops() {
        return this.chops;
    }

    public class_1937 getLevel() {
        return this.level;
    }

    public Collection<class_2338> getIncompleteLogs() {
        return this.logs;
    }

    public Collection<class_2338> getIncompleteLeaves() {
        return this.leaves;
    }

    private boolean leavesHasExactDistance(class_2680 state, int distance) {
        return state.method_28500((class_2769)class_2397.field_11200).orElse(true) != false ? true : state.method_28500((class_2769)class_2397.field_11199).orElse(distance) == distance;
    }

    private boolean leavesHasAtLeastDistance(class_2680 state, int distance) {
        return state.method_28500((class_2769)class_2397.field_11200).orElse(true) != false ? true : state.method_28500((class_2769)class_2397.field_11199).orElse(distance) >= distance;
    }
}

