/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.common.network;

import ht.treechop.TreeChop;
import ht.treechop.client.Client;
import ht.treechop.common.network.ConfirmedSetting;
import ht.treechop.common.network.CustomPacket;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

public class ServerConfirmSettingsPacket
implements CustomPacket {
    public static final class_2960 ID = TreeChop.resource("server_confirm_settings");
    private final List<ConfirmedSetting> settings;

    public ServerConfirmSettingsPacket(List<ConfirmedSetting> settings) {
        this.settings = settings;
    }

    @Override
    public class_2540 encode(class_2540 buffer) {
        buffer.writeInt(this.settings.size());
        this.settings.forEach(setting -> setting.encode(buffer));
        return buffer;
    }

    public static ServerConfirmSettingsPacket decode(class_2540 buffer) {
        int numSettings = buffer.readInt();
        List<ConfirmedSetting> settings = IntStream.range(0, numSettings).mapToObj($ -> ConfirmedSetting.decode(buffer)).collect(Collectors.toList());
        return new ServerConfirmSettingsPacket(settings);
    }

    public static void handle(ServerConfirmSettingsPacket message) {
        message.settings.forEach(ServerConfirmSettingsPacket::processSingleSetting);
    }

    private static void processSingleSetting(ConfirmedSetting setting) {
        Client.getChopSettings().accept(setting.getField(), setting.getValue());
        setting.event.run(setting);
    }

    @Override
    public class_2960 getId() {
        return ID;
    }
}

