/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.common.util;

import ht.treechop.TreeChop;
import ht.treechop.api.IChoppableBlock;
import ht.treechop.api.IChoppingItem;
import ht.treechop.api.ICylinderBlock;
import ht.treechop.api.IFellableBlock;
import ht.treechop.api.IStrippableBlock;
import ht.treechop.api.ITreeChopBlockBehavior;
import ht.treechop.common.config.ConfigHandler;
import javax.annotation.Nullable;
import net.minecraft.class_1792;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;

public class ClassUtil {
    @Nullable
    public static IChoppableBlock getChoppableBlock(class_1922 level, class_2338 blockPos, class_2680 blockState) {
        IChoppableBlock choppableBlock = ClassUtil.getChoppableBlockUnchecked(blockState.method_26204());
        return choppableBlock != null && choppableBlock.isChoppable(level, blockPos, blockState) ? choppableBlock : null;
    }

    @Nullable
    public static IChoppableBlock getChoppableBlockUnchecked(class_2248 block) {
        if (block instanceof IChoppableBlock) {
            IChoppableBlock choppableBlock = (IChoppableBlock)block;
            return choppableBlock;
        }
        ITreeChopBlockBehavior iTreeChopBlockBehavior = TreeChop.api.getRegisteredChoppableBlockBehavior(block);
        if (iTreeChopBlockBehavior instanceof IChoppableBlock) {
            IChoppableBlock choppableBlock = (IChoppableBlock)iTreeChopBlockBehavior;
            return choppableBlock;
        }
        if (ConfigHandler.COMMON.choppableBlocks.get().contains(block)) {
            return (IChoppableBlock)TreeChop.platform.getChoppedLogBlock();
        }
        return null;
    }

    @Nullable
    public static IFellableBlock getFellableBlock(class_2248 block) {
        if (block instanceof IFellableBlock) {
            IFellableBlock fellableBlock = (IFellableBlock)block;
            return fellableBlock;
        }
        ITreeChopBlockBehavior iTreeChopBlockBehavior = TreeChop.api.getRegisteredChoppableBlockBehavior(block);
        if (iTreeChopBlockBehavior instanceof IFellableBlock) {
            IFellableBlock fellableBlock = (IFellableBlock)iTreeChopBlockBehavior;
            return fellableBlock;
        }
        return null;
    }

    @Nullable
    public static ICylinderBlock getCylinderBlock(class_2248 block) {
        if (block instanceof ICylinderBlock) {
            ICylinderBlock cylinderBlock = (ICylinderBlock)block;
            return cylinderBlock;
        }
        ITreeChopBlockBehavior iTreeChopBlockBehavior = TreeChop.api.getRegisteredChoppableBlockBehavior(block);
        if (iTreeChopBlockBehavior instanceof ICylinderBlock) {
            ICylinderBlock cylinderBlock = (ICylinderBlock)iTreeChopBlockBehavior;
            return cylinderBlock;
        }
        return null;
    }

    public static IStrippableBlock getStrippableBlock(class_2248 block) {
        if (block instanceof IStrippableBlock) {
            IStrippableBlock strippableBlock = (IStrippableBlock)block;
            return strippableBlock;
        }
        ITreeChopBlockBehavior iTreeChopBlockBehavior = TreeChop.api.getRegisteredChoppableBlockBehavior(block);
        if (iTreeChopBlockBehavior instanceof IStrippableBlock) {
            IStrippableBlock strippableBlock = (IStrippableBlock)iTreeChopBlockBehavior;
            return strippableBlock;
        }
        return null;
    }

    public static IChoppingItem getChoppingItem(class_1792 item) {
        if (item instanceof IChoppingItem) {
            IChoppingItem choppingItem = (IChoppingItem)item;
            return choppingItem;
        }
        return TreeChop.api.getRegisteredChoppingItemBehavior(item);
    }
}

