/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.compat;

import ht.treechop.api.TreeData;
import ht.treechop.common.chop.ChopUtil;
import ht.treechop.common.chop.LazyTreeData;
import ht.treechop.common.config.ConfigHandler;
import ht.treechop.common.config.Lazy;
import ht.treechop.common.util.BlockNeighbors;
import ht.tuber.graph.DirectedGraph;
import ht.tuber.graph.GraphUtil;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;

public abstract class MushroomCapDetection {
    private static final Lazy<Set<class_2248>> stems = new Lazy<Set>(ConfigHandler.RELOAD, () -> ConfigHandler.getMushroomStems().collect(Collectors.toSet()));
    private static final Lazy<Set<class_2248>> caps = new Lazy<Set>(ConfigHandler.RELOAD, () -> ConfigHandler.getMushroomCaps().collect(Collectors.toSet()));

    private static boolean isStem(class_1937 level, class_2338 pos) {
        return stems.get().contains(ChopUtil.getLogBlock(level, pos));
    }

    private static boolean isCap(class_1937 level, class_2338 pos) {
        return caps.get().contains(level.method_8320(pos).method_26204());
    }

    static TreeData detectHugeShrooms(final class_1937 level, final class_2338 origin, TreeData treeData) {
        if (MushroomCapDetection.isStem(level, origin) && treeData instanceof LazyTreeData) {
            LazyTreeData lazyTree = (LazyTreeData)treeData;
            return new LazyTreeData(lazyTree.getLevel(), lazyTree.getIncompleteLogs(), BlockNeighbors.HORIZONTAL_AND_ABOVE::asStream, pos -> MushroomCapDetection.isStem(level, pos), pos -> MushroomCapDetection.isCap(level, pos), (Integer)ConfigHandler.COMMON.maxNumTreeBlocks.get(), lazyTree.getChops()){

                @Override
                public Stream<class_2338> streamLeaves() {
                    this.streamLogs().forEach(a -> {});
                    int breakDistance = (Integer)ConfigHandler.COMMON.maxBreakLeavesDistance.get();
                    DirectedGraph<class_2338> cap = GraphUtil.filter(BlockNeighbors.ADJACENTS_AND_BELOW_ADJACENTS::asStream, pos -> MushroomCapDetection.isCap(level, pos) && ChopUtil.horizontalBlockDistance(origin, pos) < breakDistance);
                    return GraphUtil.flood(cap, this.getIncompleteLeaves()).fill().limit(((Integer)ConfigHandler.COMMON.maxNumLeavesBlocks.get()).intValue());
                }
            };
        }
        return treeData;
    }
}

