/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.common;

import ht.treechop.api.ChopData;
import ht.treechop.api.ChopDataImmutable;
import ht.treechop.api.ChopEvent;
import ht.treechop.api.TreeData;
import ht.treechop.common.chop.ChopResult;
import ht.treechop.common.chop.FellTreeResult;
import ht.treechop.common.platform.ModLoader;
import ht.treechop.common.platform.Platform;
import ht.treechop.common.registry.ForgeModBlocks;
import ht.treechop.common.util.TreeDataImpl;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.ForgeRegistries;

public class ForgePlatform
implements Platform {
    @Override
    public boolean isDedicatedServer() {
        return FMLEnvironment.dist.isDedicatedServer();
    }

    @Override
    public boolean uses(ModLoader loader) {
        return loader == ModLoader.FORGE;
    }

    @Override
    public TreeData detectTreeEvent(Level level, ServerPlayer agent, BlockPos blockPos, BlockState blockState, TreeData treeData) {
        ChopEvent.DetectTreeEvent event = new ChopEvent.DetectTreeEvent(level, agent, blockPos, blockState, treeData);
        boolean canceled = MinecraftForge.EVENT_BUS.post((Event)event);
        treeData = event.getTreeData().orElse(null);
        return canceled || treeData == null ? TreeDataImpl.empty(level) : treeData;
    }

    @Override
    public boolean startChopEvent(ServerPlayer agent, ServerLevel level, BlockPos pos, BlockState blockState, ChopData chopData, Object trigger) {
        ChopEvent.StartChopEvent startChopEvent = new ChopEvent.StartChopEvent((Level)level, agent, pos, blockState, chopData, trigger);
        boolean canceled = MinecraftForge.EVENT_BUS.post((Event)startChopEvent);
        return !canceled;
    }

    @Override
    public void finishChopEvent(ServerPlayer agent, ServerLevel level, BlockPos pos, BlockState blockState, ChopDataImmutable chopData, ChopResult chopResult) {
        MinecraftForge.EVENT_BUS.post((Event)new ChopEvent.FinishChopEvent((Level)level, (Player)agent, pos, blockState, chopData, chopResult instanceof FellTreeResult));
    }

    @Override
    public Block getChoppedLogBlock() {
        return (Block)ForgeModBlocks.CHOPPED_LOG.get();
    }

    @Override
    public BlockEntityType<?> getChoppedLogBlockEntity() {
        return (BlockEntityType)ForgeModBlocks.CHOPPED_LOG_ENTITY.get();
    }

    @Override
    public ResourceLocation getResourceLocationForBlock(Block block) {
        return ForgeRegistries.BLOCKS.getKey((Object)block);
    }

    @Override
    public ResourceLocation getResourceLocationForItem(Item item) {
        return ForgeRegistries.ITEMS.getKey((Object)item);
    }

    @Override
    public BlockState getStrippedState(BlockAndTintGetter level, BlockPos pos, BlockState state) {
        try {
            if (level instanceof Level) {
                Level realLevel = (Level)level;
                BlockHitResult fakeHitResult = BlockHitResult.m_82426_((Vec3)Vec3.f_82478_, (Direction)Direction.DOWN, (BlockPos)pos);
                return state.getToolModifiedState(new UseOnContext(realLevel, null, InteractionHand.MAIN_HAND, ItemStack.f_41583_, fakeHitResult), ToolActions.AXE_STRIP, true);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return null;
    }
}

