/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.common.util;

import java.util.Arrays;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;

public class BlockNeighbors {
    protected final BlockPos[] blocks;
    public static final BlockNeighbors UP = new BlockNeighbors(new BlockPos[]{new BlockPos(Direction.UP.m_122436_())});
    public static final BlockNeighbors DOWN = new BlockNeighbors(new BlockPos[]{new BlockPos(Direction.DOWN.m_122436_())});
    public static final BlockNeighbors HORIZONTAL_ADJACENTS = new BlockNeighbors(new BlockPos[]{new BlockPos(-1, 0, 0), new BlockPos(0, 0, -1), new BlockPos(1, 0, 0), new BlockPos(0, 0, 1)});
    public static final BlockNeighbors HORIZONTAL_DIAGONALS = new BlockNeighbors((BlockPos[])Stream.of(new BlockPos(-1, 0, -1), new BlockPos(-1, 0, 1), new BlockPos(1, 0, -1), new BlockPos(1, 0, 1)).toArray(BlockPos[]::new));
    public static final BlockNeighbors VERTICAL_ADJACENTS = BlockNeighbors.join(UP, DOWN);
    public static final BlockNeighbors ADJACENTS = BlockNeighbors.join(HORIZONTAL_ADJACENTS, VERTICAL_ADJACENTS);
    public static final BlockNeighbors HORIZONTAL = BlockNeighbors.join(HORIZONTAL_ADJACENTS, HORIZONTAL_DIAGONALS);
    public static final BlockNeighbors ABOVE = BlockNeighbors.join(UP, BlockNeighbors.offset((Vec3i)new BlockPos(0, 1, 0), HORIZONTAL));
    public static final BlockNeighbors HORIZONTAL_AND_ABOVE = BlockNeighbors.join(HORIZONTAL, ABOVE);
    public static final BlockNeighbors BELOW = BlockNeighbors.join(DOWN, BlockNeighbors.offset((Vec3i)new BlockPos(0, -1, 0), HORIZONTAL));
    public static final BlockNeighbors ADJACENTS_AND_DIAGONALS = BlockNeighbors.join(ABOVE, HORIZONTAL, BELOW);
    public static final BlockNeighbors ADJACENTS_AND_BELOW_ADJACENTS = BlockNeighbors.join(ADJACENTS, BELOW);

    public BlockNeighbors(BlockPos[] blocks) {
        this.blocks = blocks;
    }

    public static BlockNeighbors join(BlockNeighbors ... neighbors) {
        return new BlockNeighbors((BlockPos[])Arrays.stream(neighbors).flatMap(BlockNeighbors::asStream).distinct().toArray(BlockPos[]::new));
    }

    protected static BlockNeighbors offset(Vec3i offset, BlockNeighbors neighbors) {
        return new BlockNeighbors((BlockPos[])neighbors.asStream().map(p -> p.m_121955_(offset)).toArray(BlockPos[]::new));
    }

    protected Stream<BlockPos> asStream() {
        return Arrays.stream(this.blocks);
    }

    public Stream<BlockPos> asStream(BlockPos pos) {
        return Arrays.stream(this.blocks).map(arg_0 -> ((BlockPos)pos).m_121955_(arg_0));
    }
}

