/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.compat;

import ht.treechop.api.TreeData;
import ht.treechop.common.chop.ChopUtil;
import ht.treechop.common.chop.LazyTreeData;
import ht.treechop.common.config.ConfigHandler;
import ht.treechop.common.config.Lazy;
import ht.treechop.common.util.BlockNeighbors;
import ht.tuber.graph.DirectedGraph;
import ht.tuber.graph.GraphUtil;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public abstract class MushroomCapDetection {
    private static final Lazy<Set<Block>> stems = new Lazy<Set>(ConfigHandler.RELOAD, () -> ConfigHandler.getMushroomStems().collect(Collectors.toSet()));
    private static final Lazy<Set<Block>> caps = new Lazy<Set>(ConfigHandler.RELOAD, () -> ConfigHandler.getMushroomCaps().collect(Collectors.toSet()));

    private static boolean isStem(Level level, BlockPos pos) {
        return stems.get().contains(ChopUtil.getLogBlock(level, pos));
    }

    private static boolean isCap(Level level, BlockPos pos) {
        return caps.get().contains(level.m_8055_(pos).m_60734_());
    }

    static TreeData detectHugeShrooms(final Level level, final BlockPos origin, TreeData treeData) {
        if (MushroomCapDetection.isStem(level, origin) && treeData instanceof LazyTreeData) {
            LazyTreeData lazyTree = (LazyTreeData)treeData;
            return new LazyTreeData(lazyTree.getLevel(), lazyTree.getIncompleteLogs(), BlockNeighbors.HORIZONTAL_AND_ABOVE::asStream, pos -> MushroomCapDetection.isStem(level, pos), pos -> MushroomCapDetection.isCap(level, pos), (Integer)ConfigHandler.COMMON.maxNumTreeBlocks.get(), lazyTree.getChops()){

                @Override
                public Stream<BlockPos> streamLeaves() {
                    this.streamLogs().forEach(a -> {});
                    int breakDistance = (Integer)ConfigHandler.COMMON.maxBreakLeavesDistance.get();
                    DirectedGraph<BlockPos> cap = GraphUtil.filter(BlockNeighbors.ADJACENTS_AND_BELOW_ADJACENTS::asStream, pos -> MushroomCapDetection.isCap(level, pos) && ChopUtil.horizontalBlockDistance(origin, pos) < breakDistance);
                    return GraphUtil.flood(cap, this.getIncompleteLeaves()).fill().limit(((Integer)ConfigHandler.COMMON.maxNumLeavesBlocks.get()).intValue());
                }
            };
        }
        return treeData;
    }
}

