/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.client;

import ht.treechop.TreeChop;
import ht.treechop.client.gui.screen.ClientSettingsScreen;
import ht.treechop.client.settings.ClientChopSettings;
import ht.treechop.common.block.ChoppedLogBlock;
import ht.treechop.common.config.ConfigHandler;
import ht.treechop.common.network.ClientRequestSettingsPacket;
import ht.treechop.common.network.CustomPacket;
import ht.treechop.common.settings.ChopSettings;
import ht.treechop.common.settings.Permissions;
import ht.treechop.common.settings.SettingsField;
import ht.treechop.common.settings.SneakBehavior;
import ht.treechop.common.util.TreeCache;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_638;

public abstract class Client {
    protected static final Permissions serverPermissions = new Permissions();
    public static TreeCache treeCache = new TreeCache();
    protected static Client instance;
    protected static final ClientChopSettings chopSettings;

    public static void requestSetting(SettingsField field, Object value) {
        Client.instance().sendToServer(new ClientRequestSettingsPacket(field, value));
    }

    public static void toggleChopping() {
        boolean newValue = chopSettings.get(SettingsField.CHOPPING, Boolean.class) == false;
        chopSettings.set(SettingsField.CHOPPING, newValue);
    }

    public static void toggleFelling() {
        boolean newValue = chopSettings.get(SettingsField.FELLING, Boolean.class) == false;
        chopSettings.set(SettingsField.FELLING, newValue);
    }

    public static void cycleSneakBehavior() {
        SneakBehavior newValue = (Boolean)ConfigHandler.CLIENT.showFellingOptions.get() != false ? chopSettings.getSneakBehavior().cycle() : (chopSettings.getSneakBehavior() == SneakBehavior.NONE ? SneakBehavior.INVERT_CHOPPING : SneakBehavior.NONE);
        chopSettings.set(SettingsField.SNEAK_BEHAVIOR, (Object)newValue);
    }

    public static ClientChopSettings getChopSettings() {
        return chopSettings;
    }

    public static void setChoppingIndicatorVisibility(boolean showChoppingIndicator) {
        ConfigHandler.CLIENT.showChoppingIndicators.set((Object)showChoppingIndicator);
    }

    public static boolean isChoppingIndicatorEnabled() {
        return (Boolean)ConfigHandler.CLIENT.showChoppingIndicators.get();
    }

    public static void toggleSettingsOverlay() {
        class_310 minecraft = class_310.method_1551();
        if (minecraft.field_1755 instanceof ClientSettingsScreen) {
            minecraft.field_1755.method_25419();
        } else {
            minecraft.method_1507((class_437)new ClientSettingsScreen());
        }
    }

    public static void updatePermissions(Permissions permissions) {
        serverPermissions.copy(permissions);
    }

    public static Permissions getServerPermissions() {
        return serverPermissions;
    }

    public static Client instance() {
        return instance;
    }

    protected static void syncOnJoin() {
        TreeChop.LOGGER.info("Sending chop settings sync request");
        chopSettings.copyFrom(ConfigHandler.CLIENT.getChopSettings());
        Client.instance().sendToServer(new ClientRequestSettingsPacket(chopSettings));
    }

    public static void handleUpdateChopsPacket(class_2338 pos, class_2487 tag) {
        class_2586 class_25862;
        class_638 level = class_310.method_1551().field_1687;
        if (level != null && (class_25862 = level.method_8321(pos)) instanceof ChoppedLogBlock.MyEntity) {
            ChoppedLogBlock.MyEntity entity = (ChoppedLogBlock.MyEntity)class_25862;
            entity.method_11014(tag);
        }
    }

    public static class_1657 getPlayer() {
        return class_310.method_1551().field_1724;
    }

    abstract void sendToServer(CustomPacket var1);

    static {
        chopSettings = new ClientChopSettings(){

            @Override
            public ChopSettings set(SettingsField field, Object value) {
                treeCache.invalidate();
                return super.set(field, value);
            }
        };
    }
}

