/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.client.gui.screen;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import ht.treechop.TreeChop;
import ht.treechop.TreeChopException;
import ht.treechop.client.Client;
import ht.treechop.client.gui.util.Sprite;
import ht.treechop.client.settings.ClientChopSettings;
import ht.treechop.common.chop.ChopUtil;
import ht.treechop.common.config.ConfigHandler;
import net.minecraft.class_1306;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3965;
import net.minecraft.class_638;
import net.minecraft.class_746;

public class ChopIndicator {
    private static final double IMAGE_SCALE = 1.0;

    public static void render(class_332 gui, int windowWidth, int windowHeight) {
        class_310 minecraft = class_310.method_1551();
        class_239 mouseOver = minecraft.field_1765;
        class_746 player = minecraft.field_1724;
        try {
            class_2338 blockPos;
            if (Client.isChoppingIndicatorEnabled() && player != null && !player.method_7325() && minecraft.field_1687 != null && minecraft.field_1755 == null && mouseOver != null && mouseOver.method_17783() == class_239.class_240.field_1332 && mouseOver instanceof class_3965 && ChopUtil.playerWantsToChop((class_1657)player, Client.getChopSettings()) && ChopIndicator.blockCanBeChopped(blockPos = ((class_3965)mouseOver).method_17777())) {
                RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.ONE_MINUS_DST_COLOR, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_COLOR, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ZERO);
                RenderSystem.setShaderTexture((int)0, (class_2960)Sprite.TEXTURE_PATH);
                boolean mirror = player.method_6068() == class_1306.field_6182;
                int indicatorCenterX = windowWidth / 2 + (Integer)ConfigHandler.CLIENT.indicatorXOffset.get() * (mirror ? -1 : 1);
                int indicatorCenterY = windowHeight / 2 + (Integer)ConfigHandler.CLIENT.indicatorYOffset.get();
                Sprite sprite = ChopUtil.playerWantsToFell((class_1657)player, Client.getChopSettings()) ? Sprite.CHOP_INDICATOR : Sprite.NO_FELL_INDICATOR;
                int imageWidth = (int)((double)sprite.width * 1.0);
                int imageHeight = (int)((double)sprite.height * 1.0);
                sprite.blit(gui, indicatorCenterX - imageWidth / 2, indicatorCenterY - imageHeight / 2, imageWidth, imageHeight, mirror);
                RenderSystem.defaultBlendFunc();
            }
        }
        catch (Exception e) {
            TreeChop.cry(e);
        }
    }

    public static boolean blockCanBeChopped(class_2338 pos) throws TreeChopException {
        boolean wantToChop;
        class_310 minecraft = class_310.method_1551();
        class_746 player = minecraft.field_1724;
        class_638 level = minecraft.field_1687;
        ClientChopSettings chopSettings = Client.getChopSettings();
        if (player == null || level == null) {
            return false;
        }
        boolean bl = wantToChop = ChopUtil.canChopWithTool((class_1657)player, (class_1937)level, pos) && ChopUtil.playerWantsToChop((class_1657)minecraft.field_1724, chopSettings);
        if (wantToChop) {
            if (ChopUtil.playerWantsToFell((class_1657)player, chopSettings)) {
                return ChopIndicator.isAProperTree(pos, level, chopSettings);
            }
            return ChopUtil.isBlockChoppable((class_1937)level, pos);
        }
        return false;
    }

    private static boolean isAProperTree(class_2338 pos, class_638 level, ClientChopSettings chopSettings) throws TreeChopException {
        try {
            return Client.treeCache.getTree((class_1937)level, pos).isAProperTree(chopSettings.getTreesMustHaveLeaves());
        }
        catch (Exception e) {
            throw new TreeChopException(String.format("Parameters: %s, %s, %s", pos, level, chopSettings), e);
        }
    }
}

