/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.server;

import ht.treechop.common.network.ClientRequestSettingsPacket;
import ht.treechop.common.network.CustomPacket;
import ht.treechop.common.settings.ChoppingEntity;
import ht.treechop.common.settings.SyncedChopData;
import ht.treechop.server.Server;
import io.netty.buffer.Unpooled;
import net.fabricmc.api.DedicatedServerModInitializer;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class FabricServer
extends Server
implements DedicatedServerModInitializer {
    public void onInitializeServer() {
    }

    public static void initialize() {
        FabricServer instance = new FabricServer();
        instance.registerPackets();
        Server.instance = instance;
        ServerPlayerEvents.AFTER_RESPAWN.register((oldPlayer, newPlayer, alive) -> {
            SyncedChopData chopSettings = instance.getPlayerChopData((class_1657)oldPlayer);
            ((ChoppingEntity)newPlayer).setChopData(chopSettings);
        });
    }

    private void registerPackets() {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)ClientRequestSettingsPacket.ID, (server, player, handler, buffer, sender) -> {
            ClientRequestSettingsPacket packet = ClientRequestSettingsPacket.decode(buffer);
            server.execute(() -> ClientRequestSettingsPacket.handle(packet, player, reply -> this.replyTo(sender, reply)));
        });
    }

    private void replyTo(PacketSender sender, CustomPacket packet) {
        class_2540 buffer = new class_2540(Unpooled.buffer());
        sender.sendPacket(packet.getId(), packet.encode(buffer));
    }

    @Override
    public void broadcast(class_3218 level, class_2338 pos, CustomPacket packet) {
        for (class_3222 player : PlayerLookup.tracking((class_3218)level, (class_2338)pos)) {
            FabricServer.instance().sendTo(player, packet);
        }
    }

    @Override
    public void sendTo(class_3222 player, CustomPacket packet) {
        class_2540 buffer = new class_2540(Unpooled.buffer());
        ServerPlayNetworking.send((class_3222)player, (class_2960)packet.getId(), (class_2540)packet.encode(buffer));
    }
}

