/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.common.util;

import ht.treechop.api.TreeData;
import ht.treechop.common.chop.ChopUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class TreeCache {
    private final SingleBlockCache<TreeData> singleBlockCache = new SingleBlockCache();

    public TreeData getTree(Level level, BlockPos pos, int maxNumTreeBlocks) {
        TreeData tree = this.singleBlockCache.get((BlockGetter)level, pos);
        if (tree == null) {
            tree = ChopUtil.getTreeBlocks(level, pos, maxNumTreeBlocks);
            this.singleBlockCache.put((BlockGetter)level, pos, tree);
        }
        return tree;
    }

    public void invalidate() {
        this.singleBlockCache.invalidate();
    }

    private static class SingleBlockCache<T> {
        private T value;
        private BlockGetter level;
        private BlockState blockState;
        private BlockPos pos;

        private SingleBlockCache() {
        }

        public T get(BlockGetter level, BlockPos pos) {
            if (level == this.level && pos.equals((Object)this.pos) && level.m_8055_(pos).equals(this.blockState)) {
                return this.value;
            }
            return null;
        }

        public void put(BlockGetter level, BlockPos pos, T value) {
            this.value = value;
            this.level = level;
            this.pos = pos;
            this.blockState = level.m_8055_(pos);
        }

        public void clear(BlockGetter level, BlockPos pos) {
            if (level == this.level & pos.equals((Object)this.pos)) {
                this.value = null;
                this.blockState = Blocks.f_50016_.m_49966_();
            }
        }

        public void invalidate() {
            this.level = null;
            this.value = null;
            this.blockState = Blocks.f_50016_.m_49966_();
        }
    }
}

