/*
 * Decompiled with CFR 0.152.
 */
package mod.uncharted;

import java.util.Random;
import mod.uncharted.UnchartedConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.lwjgl.opengl.GL11;

public class GuiBiomePanel
extends AbstractGui {
    private Minecraft mc;
    private Biome biomePanel;
    private ResourceLocation biomeTexture;
    private ResourceLocation biomeTextureStatic;
    private ResourceLocation biomeTextureOverlay;
    private boolean transitionUp;
    private float timer;
    private int posX;
    private int posY;
    private int timerMax;
    private String[] biomeName = new String[]{"", "", ""};
    private String entering = "ENTERING...WORLD";
    private boolean smallFrame = true;
    private float scale = 1.0f;
    private int height = 256;
    private boolean borderLower = true;
    private boolean borderLeft = false;
    private boolean animated = false;
    private String[] stringlist = new String[]{"beach"};
    private int listindex = 0;

    public GuiBiomePanel(Minecraft mc) {
        this.mc = mc;
        this.biomePanel = Biomes.field_76779_k;
        this.transitionUp = true;
        this.timer = 0.0f;
        this.timerMax = 200;
        this.posX = 0;
        this.posY = 0;
        this.biomeTexture = new ResourceLocation("uncharted", "textures/static.png");
        this.biomeTextureStatic = new ResourceLocation("uncharted", "textures/static.png");
        this.biomeTextureOverlay = new ResourceLocation("uncharted", "textures/overlay.png");
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onTravel);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onRenderExperienceBar);
        this.smallFrame = UnchartedConfig.smallFrame;
        this.scale = (float)UnchartedConfig.scale / 100.0f;
        this.borderLower = UnchartedConfig.borderLower;
        this.borderLeft = UnchartedConfig.borderLeft;
        if (this.smallFrame) {
            this.height = 32;
            this.timerMax -= 56;
        } else {
            this.height = 64;
        }
    }

    private void LoadBiome() {
        Texture texture = this.mc.func_110434_K().func_229267_b_(new ResourceLocation("uncharted", "textures/biomes/" + this.stringlist[this.listindex] + ".png"));
        if (texture instanceof DynamicTexture) {
            ++this.listindex;
            if (this.listindex == this.stringlist.length) {
                this.biomeTexture = this.biomeTextureStatic;
                this.animated = true;
                this.listindex = 0;
            }
        } else {
            this.biomeTexture = new ResourceLocation("uncharted", "textures/biomes/" + this.stringlist[this.listindex] + ".png");
            this.animated = false;
        }
    }

    @SubscribeEvent
    public void onTravel(LivingEvent.LivingUpdateEvent event) {
        boolean newBiome = false;
        if (event.getEntity() instanceof PlayerEntity) {
            if (event.getEntity().field_71093_bK == DimensionType.field_223227_a_) {
                if (event.getEntity().field_70170_p.func_175710_j(event.getEntity().func_180425_c()) && this.biomePanel != event.getEntity().field_70170_p.func_226691_t_(event.getEntity().func_180425_c())) {
                    newBiome = true;
                }
            } else if (this.biomePanel != event.getEntity().field_70170_p.func_226691_t_(event.getEntity().func_180425_c())) {
                newBiome = true;
            }
        }
        if (newBiome) {
            this.biomePanel = event.getEntity().field_70170_p.func_226691_t_(event.getEntity().func_180425_c());
            this.transitionUp = true;
            String translatedKey = I18n.func_135052_a((String)this.biomePanel.func_210773_k(), (Object[])new Object[0]);
            this.entering = I18n.func_135052_a((String)"gui.uncharted.entering", (Object[])new Object[0]);
            this.biomeName = translatedKey.split(" ");
            String[] templist = this.biomePanel.getRegistryName().func_110623_a().split("_");
            if (templist.length > 1) {
                this.stringlist = new String[templist.length + 1];
                this.stringlist[0] = this.biomePanel.getRegistryName().func_110623_a();
                System.arraycopy(templist, 0, this.stringlist, 1, templist.length);
            } else {
                this.stringlist = new String[1];
                this.stringlist[0] = this.biomePanel.getRegistryName().func_110623_a();
            }
            this.listindex = 0;
        }
    }

    @SubscribeEvent
    public void onRenderExperienceBar(RenderGameOverlayEvent event) {
        if (event.isCancelable() || event.getType() != RenderGameOverlayEvent.ElementType.HELMET) {
            return;
        }
        if (this.transitionUp) {
            if (this.timer >= (float)this.timerMax) {
                this.timer = this.timerMax;
                this.transitionUp = false;
            } else {
                this.timer += 1.0f;
            }
        } else {
            this.timer = this.timer <= 0.0f ? 0.0f : (this.timer -= 1.0f);
        }
        if (this.timer > 0.0f) {
            this.LoadBiome();
            int v = 150;
            if (this.smallFrame) {
                v -= 56;
            }
            int u = this.timer > (float)v ? v / 2 : (int)(this.timer / 2.0f);
            this.posX = this.borderLeft ? 10 : this.mc.func_228018_at_().func_198107_o() - 10 - 128;
            this.posY = this.borderLower ? this.mc.func_228018_at_().func_198087_p() - u + 8 : -(this.height + 10) + u;
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)2896);
            this.mc.func_110434_K().func_110577_a(this.biomeTextureOverlay);
            this.blit(this.posX - 4, this.posY - 4, 0, this.smallFrame ? 128 : 0, 136, 72);
            this.mc.func_110434_K().func_110577_a(this.biomeTexture);
            if (this.animated) {
                Random r = new Random();
                this.blit(this.posX, this.posY + (this.smallFrame ? 1 : 0), r.nextInt(128), r.nextInt(192), 128, this.height);
            } else {
                this.blit(this.posX, this.posY + (this.smallFrame ? 1 : 0), 0, this.smallFrame ? 16 : 0, 128, this.height);
            }
            GL11.glPushMatrix();
            GL11.glScalef((float)this.scale, (float)this.scale, (float)this.scale);
            this.DrawString(this.entering, this.posX + 2, this.posY + 2, false);
            for (int i = 0; i < this.biomeName.length; ++i) {
                this.DrawString(this.biomeName[i], this.posX + 124, this.posY + this.height - 10 * this.biomeName.length + i * 10, true);
            }
            GL11.glPopMatrix();
        }
    }

    private void DrawString(String text, int posX, int posY, boolean rightsided) {
        if (rightsided) {
            this.drawRightAlignedString(this.mc.field_71466_p, text, (int)((float)posX / this.scale), (int)((float)posY / this.scale), 0);
            this.drawRightAlignedString(this.mc.field_71466_p, text, (int)((float)(posX + 1) / this.scale), (int)((float)(posY + 1) / this.scale), 0xFFFFFF);
        } else {
            this.drawString(this.mc.field_71466_p, text, (int)((float)posX / this.scale), (int)((float)posY / this.scale), 0);
            this.drawString(this.mc.field_71466_p, text, (int)((float)(posX + 1) / this.scale), (int)((float)(posY + 1) / this.scale), 0xFFFFFF);
        }
    }
}

