/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.unionlib;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.network.play.NetworkPlayerInfo;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Cape {
    private static final ExecutorService THREAD_POOL = new ThreadPoolExecutor(0, 2, 1L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>());
    private static final Logger logger = LogManager.getLogger((String)"unionlib");

    public static void queuePlayerCapeReplacement(AbstractClientPlayerEntity player) {
        String displayName = player.func_145748_c_().getString();
        logger.info("Queueing cape replacement for " + displayName);
        THREAD_POOL.submit(() -> {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                logger.fatal("Cape delay thread for " + displayName + " interrupted");
                return;
            }
            Minecraft.func_71410_x().func_213165_a(() -> Cape.replacePlayerCape(player));
        });
    }

    private static void replacePlayerCape(AbstractClientPlayerEntity player) {
        String displayName = player.func_145748_c_().getString();
        NetworkPlayerInfo playerInfo = player.func_175155_b();
        if (playerInfo == null) {
            logger.info("NetworkPlayerInfo of " + displayName + " is null. Cannot add cape");
            return;
        }
        Map playerTextures = playerInfo.field_187107_a;
        playerTextures.put(MinecraftProfileTexture.Type.CAPE, new ResourceLocation("unionlib", "textures/cape/cape" + Cape.capeTexture(player) + ".png"));
        logger.info("Looking for cape texture at " + new ResourceLocation("unionlib", "textures/cape/cape" + Cape.capeTexture(player) + ".png").func_110623_a());
        logger.info("Replaced cape of " + displayName);
    }

    public static boolean doesPlayerNeedCape(AbstractClientPlayerEntity player) {
        return Cape.capeTexture(player) != 0;
    }

    public static int capeTexture(AbstractClientPlayerEntity player) {
        if (PlayerEntity.func_146094_a((GameProfile)player.func_146103_bH()).equals(UUID.fromString("4da67eb9-7966-4aa3-b2f6-7ee90bf606d2"))) {
            return 10;
        }
        if (PlayerEntity.func_146094_a((GameProfile)player.func_146103_bH()).equals(UUID.fromString("b4640bf0-c41d-3c36-b901-fd2d90b54431"))) {
            return 9;
        }
        if (PlayerEntity.func_146094_a((GameProfile)player.func_146103_bH()).equals(UUID.fromString("986e2557-0d63-37ec-acd8-20f952a01923"))) {
            return 3;
        }
        if (PlayerEntity.func_146094_a((GameProfile)player.func_146103_bH()).equals(UUID.fromString("e2401a9b-d035-3821-b275-03f8b4339b02"))) {
            return 7;
        }
        if (PlayerEntity.func_146094_a((GameProfile)player.func_146103_bH()).equals(UUID.fromString("74649178-0bc8-3661-8503-68ca5190d4bb"))) {
            return 8;
        }
        if (player.func_145748_c_().getString().equals("Dev")) {
            return 1;
        }
        return 0;
    }
}

