/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.unionlib.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.ConfigFormat;
import com.electronwill.nightconfig.core.EnumGetMethod;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.stereowalker.unionlib.config.CommentedEnum;
import com.stereowalker.unionlib.config.UnionConfig;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLPaths;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ConfigBuilder {
    private static Map<String, ForgeConfigSpec.ConfigValue<?>> values = new HashMap();
    private static final List<Class<?>> configs = Lists.newArrayList();
    private static final Map<Class<?>, ForgeConfigSpec.Builder> client_builder = Maps.newHashMap();
    public static final Map<Class<?>, ForgeConfigSpec> client_config = Maps.newHashMap();
    private static final Map<Class<?>, ForgeConfigSpec.Builder> common_builder = Maps.newHashMap();
    public static final Map<Class<?>, ForgeConfigSpec> common_config = Maps.newHashMap();
    private static final Map<Class<?>, ForgeConfigSpec.Builder> server_builder = Maps.newHashMap();
    public static final Map<Class<?>, ForgeConfigSpec> server_config = Maps.newHashMap();
    private static final Joiner LINE_JOINER = Joiner.on((String)"\n");
    private static final Joiner DOT_JOINER = Joiner.on((String)".");
    private static final Splitter DOT_SPLITTER = Splitter.on((String)".");

    private static ForgeConfigSpec.ConfigValue<?> getConfigValue(UnionConfig config, UnionConfig.Entry configEntry) {
        return values.get(config.name() + "=" + configEntry.group() + "." + configEntry.name());
    }

    public static void read(Class<?> configClass) {
        if (configClass.isAnnotationPresent(UnionConfig.class)) {
            UnionConfig config = configClass.getAnnotation(UnionConfig.class);
            for (Field field : configClass.getFields()) {
                UnionConfig.Entry configEntry = field.getAnnotation(UnionConfig.Entry.class);
                if (configEntry == null) continue;
                try {
                    if (ConfigBuilder.getConfigValue(config, configEntry).get() instanceof Double && field.get(null) instanceof Float) {
                        field.set(null, Float.valueOf(((Double)ConfigBuilder.getConfigValue(config, configEntry).get()).floatValue()));
                        continue;
                    }
                    field.set(null, ConfigBuilder.getConfigValue(config, configEntry).get());
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void write(Class<?> configClass) {
        if (configClass.isAnnotationPresent(UnionConfig.class)) {
            UnionConfig config = configClass.getAnnotation(UnionConfig.class);
            for (Field field : configClass.getFields()) {
                UnionConfig.Entry configEntry = field.getAnnotation(UnionConfig.Entry.class);
                if (configEntry == null || ConfigBuilder.getConfigValue(config, configEntry) == null) continue;
                try {
                    ConfigBuilder.getConfigValue(config, configEntry).set(field.get(null));
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static boolean hasConfigType(Class<?> configClass, ModConfig.Type type) {
        if (configClass.isAnnotationPresent(UnionConfig.class)) {
            for (Field field : configClass.getFields()) {
                UnionConfig.Entry configEntry = field.getAnnotation(UnionConfig.Entry.class);
                if (configEntry == null || configEntry.type() != type) continue;
                return true;
            }
        }
        return false;
    }

    private static void init(Class<?> configClass, ForgeConfigSpec.Builder server, ForgeConfigSpec.Builder common, ForgeConfigSpec.Builder client) {
        if (configClass.isAnnotationPresent(UnionConfig.class)) {
            UnionConfig config = configClass.getAnnotation(UnionConfig.class);
            for (Field field : configClass.getFields()) {
                UnionConfig.Entry configEntry = field.getAnnotation(UnionConfig.Entry.class);
                if (configEntry == null) continue;
                ForgeConfigSpec.Builder builder = configEntry.type() == ModConfig.Type.CLIENT ? client : (configEntry.type() == ModConfig.Type.SERVER ? server : common);
                try {
                    ForgeConfigSpec.ConfigValue conf;
                    String enumComment = "";
                    if (field.get(null) instanceof CommentedEnum && field.get(null) instanceof Enum) {
                        enumComment = ((CommentedEnum)field.get(null)).getConfigComment();
                    }
                    enumComment = enumComment + "\n";
                    String j = "\n###########################################";
                    String k = "\n-------------------------------------------";
                    String h = j + "\n";
                    if (field.isAnnotationPresent(UnionConfig.Comment.class)) {
                        String comment = field.getAnnotation(UnionConfig.Comment.class).comment()[0];
                        if (field.getAnnotation(UnionConfig.Comment.class).comment().length > 1) {
                            for (int i = 1; i < field.getAnnotation(UnionConfig.Comment.class).comment().length; ++i) {
                                comment = comment + "\n" + field.getAnnotation(UnionConfig.Comment.class).comment()[i];
                            }
                        }
                        builder = builder.comment(h + comment + k + enumComment + "Default: " + field.get(null) + k);
                    } else {
                        builder = builder.comment(h + enumComment + "Default: " + field.get(null) + k);
                    }
                    if (field.get(null) instanceof Boolean) {
                        conf = builder.define(configEntry.group() + ".Boolean: " + configEntry.name(), (Object)((Boolean)field.get(null)));
                    } else if (field.get(null) instanceof Enum) {
                        Enum defaultValue = (Enum)field.get(null);
                        List acceptableValues = Arrays.asList(defaultValue.getDeclaringClass().getEnumConstants());
                        conf = builder.defineEnum(ConfigBuilder.split(configEntry.group() + ".Enum: " + configEntry.name()), Enum.valueOf(defaultValue.getDeclaringClass(), defaultValue.name()), EnumGetMethod.NAME_IGNORECASE, obj -> {
                            if (obj instanceof Enum) {
                                return acceptableValues.contains(obj);
                            }
                            if (obj == null) {
                                return false;
                            }
                            try {
                                return acceptableValues.contains(EnumGetMethod.NAME_IGNORECASE.get(obj, defaultValue.getDeclaringClass()));
                            }
                            catch (ClassCastException | IllegalArgumentException e) {
                                return false;
                            }
                        });
                    } else if (field.get(null) instanceof String) {
                        conf = builder.define(configEntry.group() + ".String: " + configEntry.name(), (Object)((String)field.get(null)));
                    } else if (field.isAnnotationPresent(UnionConfig.Range.class)) {
                        UnionConfig.Range range = field.getAnnotation(UnionConfig.Range.class);
                        Double min = range.min();
                        Double max = range.max();
                        conf = field.get(null) instanceof Integer ? builder.defineInRange(configEntry.group() + ".Integer: " + configEntry.name(), (Comparable)((Integer)field.get(null)), (Comparable)Integer.valueOf(min.intValue()), (Comparable)Integer.valueOf(max.intValue()), Integer.class) : (field.get(null) instanceof Float ? builder.defineInRange(configEntry.group() + ".Float: " + configEntry.name(), (Comparable)((Float)field.get(null)), (Comparable)Float.valueOf(min.floatValue()), (Comparable)Float.valueOf(max.floatValue()), Float.class) : (field.get(null) instanceof Long ? builder.defineInRange(configEntry.group() + ".Long: " + configEntry.name(), (Comparable)((Long)field.get(null)), (Comparable)Long.valueOf(min.longValue()), (Comparable)Long.valueOf(max.longValue()), Long.class) : (field.get(null) instanceof Short ? builder.defineInRange(configEntry.group() + ".Short: " + configEntry.name(), (Comparable)((Short)field.get(null)), (Comparable)Short.valueOf(min.shortValue()), (Comparable)Short.valueOf(max.shortValue()), Short.class) : (field.get(null) instanceof Byte ? builder.defineInRange(configEntry.group() + ".Byte: " + configEntry.name(), (Comparable)((Byte)field.get(null)), (Comparable)Byte.valueOf(min.byteValue()), (Comparable)Byte.valueOf(max.byteValue()), Byte.class) : builder.defineInRange(configEntry.group() + ".Double: " + configEntry.name(), (Comparable)((Double)field.get(null)), (Comparable)min, (Comparable)max, Double.class)))));
                    } else {
                        conf = builder.define(configEntry.group() + "." + configEntry.name(), field.get(null));
                    }
                    values.put(config.name() + "=" + configEntry.group() + "." + configEntry.name(), conf);
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void registerConfig(Class<?> configClass) {
        if (configClass.isAnnotationPresent(UnionConfig.class)) {
            configs.add(configClass);
            client_builder.put(configClass, new ForgeConfigSpec.Builder());
            common_builder.put(configClass, new ForgeConfigSpec.Builder());
            server_builder.put(configClass, new ForgeConfigSpec.Builder());
        }
        ConfigBuilder.registerConfigurations(configClass);
        ConfigBuilder.loadConfigs(configClass);
    }

    public static void loadConfig(ForgeConfigSpec config, String path, String fileName) {
        File configFile = new File(path, fileName);
        configFile.getParentFile().mkdirs();
        System.out.println(path);
        CommentedFileConfig file = (CommentedFileConfig)CommentedFileConfig.builder((File)configFile).sync().autosave().preserveInsertionOrder().onFileNotFound((newfile, configFormat) -> ConfigBuilder.setupConfigFile(configFile, newfile, configFormat)).writingMode(WritingMode.REPLACE).build();
        file.load();
        config.setConfig((CommentedConfig)file);
    }

    private static boolean setupConfigFile(File path, Path file, ConfigFormat<?> conf) throws IOException {
        Path p = Paths.get(path.getPath(), new String[0]);
        if (Files.exists(p, new LinkOption[0])) {
            Files.copy(p, file, new CopyOption[0]);
        } else {
            Files.createFile(file, new FileAttribute[0]);
            conf.initEmptyFile(file);
        }
        return true;
    }

    public static void registerConfigurations(Class<?> configClass) {
        UnionConfig con = configClass.getAnnotation(UnionConfig.class);
        String name = con.folder().isEmpty() ? con.name() : con.folder() + "\\" + con.name();
        ConfigBuilder.init(configClass, server_builder.get(configClass), common_builder.get(configClass), client_builder.get(configClass));
        server_config.put(configClass, server_builder.get(configClass).build());
        client_config.put(configClass, client_builder.get(configClass).build());
        common_config.put(configClass, common_builder.get(configClass).build());
        if (ConfigBuilder.hasConfigType(configClass, ModConfig.Type.CLIENT)) {
            ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, client_config.get(configClass), name + (con.appendWithType() ? ".client" : "") + ".toml");
        }
        if (ConfigBuilder.hasConfigType(configClass, ModConfig.Type.COMMON)) {
            ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, common_config.get(configClass), name + (con.appendWithType() ? ".common" : "") + ".toml");
        }
        if (ConfigBuilder.hasConfigType(configClass, ModConfig.Type.SERVER)) {
            ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, server_config.get(configClass), name + (con.appendWithType() ? ".server" : "") + ".toml");
        }
    }

    public static void loadConfigs(Class<?> configClass) {
        UnionConfig con = configClass.getAnnotation(UnionConfig.class);
        if (ConfigBuilder.hasConfigType(configClass, ModConfig.Type.CLIENT)) {
            ConfigBuilder.loadConfig(client_config.get(configClass), FMLPaths.CONFIGDIR.get().toString() + (con.folder().isEmpty() ? "" : "\\" + con.folder()), con.name() + (con.appendWithType() ? ".client" : "") + ".toml");
        }
        if (ConfigBuilder.hasConfigType(configClass, ModConfig.Type.COMMON)) {
            ConfigBuilder.loadConfig(common_config.get(configClass), FMLPaths.CONFIGDIR.get().toString() + (con.folder().isEmpty() ? "" : "\\" + con.folder()), con.name() + (con.appendWithType() ? ".common" : "") + ".toml");
        }
        if (ConfigBuilder.hasConfigType(configClass, ModConfig.Type.SERVER)) {
            ConfigBuilder.loadConfig(server_config.get(configClass), FMLPaths.CONFIGDIR.get().toString() + (con.folder().isEmpty() ? "" : "\\" + con.folder()), con.name() + (con.appendWithType() ? ".server" : "") + ".toml");
        }
    }

    @SubscribeEvent
    public static void onReload(ModConfig.Reloading event) {
        for (Class<?> configClass : configs) {
            UnionConfig con = configClass.getAnnotation(UnionConfig.class);
            if (!con.autoReload()) continue;
            ConfigBuilder.read(configClass);
            System.out.println("Detected change in a " + con.name() + "'s config file. Reloading values");
        }
    }

    @SubscribeEvent
    public static void onLoad(ModConfig.Loading event) {
        System.out.println("Detected change in a config file. Re-read and set all config values from file");
        for (Class<?> configClass : configs) {
            UnionConfig con = configClass.getAnnotation(UnionConfig.class);
            ConfigBuilder.read(configClass);
            System.out.println("Loading " + con.name() + "'s config");
        }
    }

    private static List<String> split(String path) {
        return Lists.newArrayList((Iterable)DOT_SPLITTER.split((CharSequence)path));
    }
}

