/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.unionlib.hook;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.stereowalker.unionlib.event.StructureAddedEvent;
import com.stereowalker.unionlib.event.StructurePieceAddedEvent;
import com.stereowalker.unionlib.event.item.ItemAttributeEvent;
import com.stereowalker.unionlib.event.item.ItemCraftedEvent;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.CraftingResultSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class UnionHooks {
    public static void fireStructureAdded(StructureStart<?> structureStart, ServerWorld world) {
        MinecraftForge.EVENT_BUS.post((Event)new StructureAddedEvent(structureStart, world));
    }

    public static void fireStructurePieceAdded(StructurePiece structurePiece, ServerWorld world) {
        MinecraftForge.EVENT_BUS.post((Event)new StructurePieceAddedEvent(structurePiece, world));
    }

    public static void firePlayerCraftingEvent(CraftingInventory craftMatrix, CraftingResultSlot slot, PlayerEntity player, ItemStack crafted) {
        MinecraftForge.EVENT_BUS.post((Event)new ItemCraftedEvent(player, crafted, (IInventory)craftMatrix, slot));
    }

    public static void onStructureAddedHook(StructureStart<?> structureStart, ISeedReader reader) {
        ServerWorld world = reader instanceof ServerWorld ? (ServerWorld)reader : ((WorldGenRegion)reader).func_201672_e();
        UnionHooks.fireStructureAdded(structureStart, world);
    }

    public static boolean onStructurePieceAddedHook(boolean get, StructurePiece structurePiece, ISeedReader reader) {
        ServerWorld world = reader instanceof ServerWorld ? (ServerWorld)reader : ((WorldGenRegion)reader).func_201672_e();
        UnionHooks.fireStructurePieceAdded(structurePiece, world);
        return get;
    }

    public static Multimap<Attribute, AttributeModifier> adjustAttributeMap(Multimap<Attribute, AttributeModifier> original, EquipmentSlotType equipmentSlot, ItemStack stack) {
        HashMultimap modifiedMap = HashMultimap.create(original);
        ItemAttributeEvent event = new ItemAttributeEvent((HashMultimap<Attribute, AttributeModifier>)modifiedMap, equipmentSlot, stack);
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        if (!MinecraftForge.EVENT_BUS.post((Event)event)) {
            builder.putAll((Multimap)modifiedMap);
        }
        return builder.build();
    }
}

