/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.unionlib.inventory.container;

import com.mojang.datafixers.util.Pair;
import com.stereowalker.unionlib.UnionLib;
import com.stereowalker.unionlib.inventory.UnionInventory;
import com.stereowalker.unionlib.inventory.container.UContainerType;
import com.stereowalker.unionlib.item.AccessoryItem;
import java.util.Optional;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.CraftResultInventory;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.CraftingResultSlot;
import net.minecraft.inventory.container.RecipeBookContainer;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeBookCategory;
import net.minecraft.item.crafting.RecipeItemHelper;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SSetSlotPacket;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class UnionContainer
extends RecipeBookContainer<CraftingInventory> {
    public static final ResourceLocation LOCATION_BLOCKS_TEXTURE = new ResourceLocation("textures/atlas/blocks.png");
    public static final ResourceLocation EMPTY_ARMOR_SLOT_HELMET = new ResourceLocation("item/empty_armor_slot_helmet");
    public static final ResourceLocation EMPTY_ARMOR_SLOT_CHESTPLATE = new ResourceLocation("item/empty_armor_slot_chestplate");
    public static final ResourceLocation EMPTY_ARMOR_SLOT_LEGGINGS = new ResourceLocation("item/empty_armor_slot_leggings");
    public static final ResourceLocation EMPTY_ARMOR_SLOT_BOOTS = new ResourceLocation("item/empty_armor_slot_boots");
    public static final ResourceLocation EMPTY_ARMOR_SLOT_SHIELD = new ResourceLocation("item/empty_armor_slot_shield");
    public static final ResourceLocation EMPTY_ACCESSORY_SLOT_NECKLACE = UnionLib.location("item/empty_accessory_slot_necklace");
    public static final ResourceLocation EMPTY_ACCESSORY_SLOT_RING = UnionLib.location("item/empty_accessory_slot_ring");
    private static final ResourceLocation[] ARMOR_SLOT_TEXTURES = new ResourceLocation[]{EMPTY_ARMOR_SLOT_BOOTS, EMPTY_ARMOR_SLOT_LEGGINGS, EMPTY_ARMOR_SLOT_CHESTPLATE, EMPTY_ARMOR_SLOT_HELMET};
    private static final EquipmentSlotType[] VALID_EQUIPMENT_SLOTS = new EquipmentSlotType[]{EquipmentSlotType.HEAD, EquipmentSlotType.CHEST, EquipmentSlotType.LEGS, EquipmentSlotType.FEET};
    private static final ResourceLocation[] ACCESSORY_SLOT_TEXTURES = new ResourceLocation[]{EMPTY_ACCESSORY_SLOT_NECKLACE, EMPTY_ACCESSORY_SLOT_RING};
    private static final AccessoryItem.AccessorySlotType[] VALID_ACCESSORY_SLOTS = new AccessoryItem.AccessorySlotType[]{AccessoryItem.AccessorySlotType.NECKLACE, AccessoryItem.AccessorySlotType.NECKLACE, AccessoryItem.AccessorySlotType.NECKLACE, AccessoryItem.AccessorySlotType.RING, AccessoryItem.AccessorySlotType.NECKLACE, AccessoryItem.AccessorySlotType.NECKLACE, AccessoryItem.AccessorySlotType.RING, AccessoryItem.AccessorySlotType.NECKLACE, AccessoryItem.AccessorySlotType.NECKLACE};
    private final CraftingInventory craftMatrix = new CraftingInventory((Container)this, 2, 2);
    private final CraftResultInventory craftResult = new CraftResultInventory();
    private final UnionInventory inventory;
    public final boolean isLocalWorld;
    private final PlayerEntity player;

    public UnionContainer(int id, PlayerInventory playerInventory) {
        this(id, playerInventory, new UnionInventory(playerInventory.field_70458_d), false, playerInventory.field_70458_d);
    }

    public UnionContainer(int id, PlayerInventory playerInventory, UnionInventory unionInventory, boolean localWorld, PlayerEntity playerIn) {
        super(UContainerType.UNION, id);
        int l;
        this.isLocalWorld = localWorld;
        this.player = playerIn;
        this.inventory = unionInventory;
        this.func_75146_a((Slot)new CraftingResultSlot(playerInventory.field_70458_d, this.craftMatrix, (IInventory)this.craftResult, 0, 143, 62));
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                this.func_75146_a(new Slot((IInventory)this.craftMatrix, j + i * 2, 134 + j * 18, 8 + i * 18));
            }
        }
        for (int k = 0; k < 4; ++k) {
            final EquipmentSlotType equipmentslottype = VALID_EQUIPMENT_SLOTS[k];
            this.func_75146_a(new Slot((IInventory)playerInventory, 39 - k, 8, 8 + k * 18){

                public int func_75219_a() {
                    return 1;
                }

                public boolean func_75214_a(ItemStack stack) {
                    return stack.canEquip(equipmentslottype, (Entity)UnionContainer.this.player);
                }

                public boolean func_82869_a(PlayerEntity playerIn) {
                    ItemStack itemstack = this.func_75211_c();
                    return !itemstack.func_190926_b() && !playerIn.func_184812_l_() && EnchantmentHelper.func_190938_b((ItemStack)itemstack) ? false : super.func_82869_a(playerIn);
                }

                @OnlyIn(value=Dist.CLIENT)
                public Pair<ResourceLocation, ResourceLocation> func_225517_c_() {
                    return Pair.of((Object)LOCATION_BLOCKS_TEXTURE, (Object)ARMOR_SLOT_TEXTURES[equipmentslottype.func_188454_b()]);
                }
            });
        }
        for (l = 0; l < 3; ++l) {
            for (int j1 = 0; j1 < 9; ++j1) {
                this.func_75146_a(new Slot((IInventory)playerInventory, j1 + (l + 1) * 9, 8 + j1 * 18, 84 + l * 18));
            }
        }
        for (int i1 = 0; i1 < 9; ++i1) {
            this.func_75146_a(new Slot((IInventory)playerInventory, i1, 8 + i1 * 18, 142));
        }
        this.func_75146_a(new Slot((IInventory)playerInventory, 40, 77, 62){

            @OnlyIn(value=Dist.CLIENT)
            public Pair<ResourceLocation, ResourceLocation> func_225517_c_() {
                return Pair.of((Object)LOCATION_BLOCKS_TEXTURE, (Object)EMPTY_ARMOR_SLOT_SHIELD);
            }
        });
        for (l = 0; l < 3; ++l) {
            for (int j1 = 0; j1 < 3; ++j1) {
                int index = j1 + l * 3;
                final AccessoryItem.AccessorySlotType accessoryslottype = VALID_ACCESSORY_SLOTS[index];
                this.func_75146_a(new Slot((IInventory)unionInventory, index, 77 + j1 * 18, 8 + l * 18){

                    public int func_75219_a() {
                        return 1;
                    }

                    public boolean func_75214_a(ItemStack stack) {
                        return accessoryslottype.getValidStack().test(stack);
                    }

                    public boolean func_82869_a(PlayerEntity playerIn) {
                        ItemStack itemstack = this.func_75211_c();
                        return !itemstack.func_190926_b() && !playerIn.func_184812_l_() && EnchantmentHelper.func_190938_b((ItemStack)itemstack) ? false : super.func_82869_a(playerIn);
                    }

                    @OnlyIn(value=Dist.CLIENT)
                    public Pair<ResourceLocation, ResourceLocation> func_225517_c_() {
                        return Pair.of((Object)LOCATION_BLOCKS_TEXTURE, (Object)ACCESSORY_SLOT_TEXTURES[accessoryslottype.getIndex()]);
                    }
                });
            }
        }
    }

    public void func_201771_a(RecipeItemHelper itemHelperIn) {
        this.craftMatrix.func_194018_a(itemHelperIn);
    }

    public void func_201768_e() {
        this.craftResult.func_174888_l();
        this.craftMatrix.func_174888_l();
    }

    public boolean func_201769_a(IRecipe<? super CraftingInventory> recipeIn) {
        return recipeIn.func_77569_a((IInventory)this.craftMatrix, this.player.field_70170_p);
    }

    public void func_75130_a(IInventory inventoryIn) {
        UnionLib.saveInventory(this.player, this.inventory);
        UnionContainer.updateCraftingResult(this.field_75152_c, this.player.field_70170_p, this.player, this.craftMatrix, this.craftResult);
    }

    protected static void updateCraftingResult(int id, World world, PlayerEntity player, CraftingInventory inventory, CraftResultInventory inventoryResult) {
        if (!world.field_72995_K) {
            ICraftingRecipe icraftingrecipe;
            ServerPlayerEntity serverplayerentity = (ServerPlayerEntity)player;
            ItemStack itemstack = ItemStack.field_190927_a;
            Optional optional = world.func_73046_m().func_199529_aN().func_215371_a(IRecipeType.field_222149_a, (IInventory)inventory, world);
            if (optional.isPresent() && inventoryResult.func_201561_a(world, serverplayerentity, (IRecipe)(icraftingrecipe = (ICraftingRecipe)optional.get()))) {
                itemstack = icraftingrecipe.func_77572_b((IInventory)inventory);
            }
            inventoryResult.func_70299_a(0, itemstack);
            serverplayerentity.field_71135_a.func_147359_a((IPacket)new SSetSlotPacket(id, 0, itemstack));
        }
    }

    public void func_75134_a(PlayerEntity playerIn) {
        super.func_75134_a(playerIn);
        this.craftResult.func_174888_l();
        if (!playerIn.field_70170_p.field_72995_K) {
            this.func_193327_a(playerIn, playerIn.field_70170_p, (IInventory)this.craftMatrix);
        }
        UnionLib.saveInventory(playerIn, this.inventory);
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        UnionLib.saveInventory(this.player, this.inventory);
        return true;
    }

    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            int i;
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            EquipmentSlotType equipmentslottype = MobEntity.func_184640_d((ItemStack)itemstack);
            if (index == 0) {
                if (!this.func_75135_a(itemstack1, 9, 45, true)) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(itemstack1, itemstack);
            } else if (index >= 1 && index < 5 ? !this.func_75135_a(itemstack1, 9, 45, false) : (index >= 5 && index < 9 ? !this.func_75135_a(itemstack1, 9, 45, false) : (equipmentslottype.func_188453_a() == EquipmentSlotType.Group.ARMOR && !((Slot)this.field_75151_b.get(8 - equipmentslottype.func_188454_b())).func_75216_d() ? !this.func_75135_a(itemstack1, i = 8 - equipmentslottype.func_188454_b(), i + 1, false) : (equipmentslottype == EquipmentSlotType.OFFHAND && !((Slot)this.field_75151_b.get(45)).func_75216_d() ? !this.func_75135_a(itemstack1, 45, 46, false) : (index >= 9 && index < 36 ? !this.func_75135_a(itemstack1, 36, 45, false) : (index >= 36 && index < 45 ? !this.func_75135_a(itemstack1, 9, 36, false) : !this.func_75135_a(itemstack1, 9, 45, false))))))) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            ItemStack itemstack2 = slot.func_190901_a(playerIn, itemstack1);
            if (index == 0) {
                playerIn.func_71019_a(itemstack2, false);
            }
        }
        return itemstack;
    }

    public boolean func_94530_a(ItemStack stack, Slot slotIn) {
        return slotIn.field_75224_c != this.craftResult && super.func_94530_a(stack, slotIn);
    }

    public int func_201767_f() {
        return 0;
    }

    public int func_201770_g() {
        return this.craftMatrix.func_174922_i();
    }

    public int func_201772_h() {
        return this.craftMatrix.func_174923_h();
    }

    @OnlyIn(value=Dist.CLIENT)
    public int func_203721_h() {
        return 5;
    }

    public CraftingInventory func_234641_j_() {
        return this.craftMatrix;
    }

    public RecipeBookCategory func_241850_m() {
        return RecipeBookCategory.CRAFTING;
    }
}

