/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.unionlib.util;

import com.stereowalker.unionlib.UnionLib;
import java.util.function.Consumer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.GlobalEntityTypeAttributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class EntityHelper {
    public static int getXpBarCap(int level) {
        if (level >= 30) {
            return 112 + (level - 30) * 9;
        }
        return level >= 15 ? 37 + (level - 15) * 5 : 7 + level * 2;
    }

    public static int getActualExperienceTotal(PlayerEntity player) {
        int xpTot = 0;
        for (int i = 0; i < player.field_71068_ca; ++i) {
            xpTot += EntityHelper.getXpBarCap(i);
        }
        int f = MathHelper.func_76141_d((float)(player.field_71106_cc * (float)player.func_71050_bK()));
        return xpTot += f;
    }

    public static float getJumpUpwardsMotion(LivingEntity living) {
        return 0.42f * EntityHelper.getJumpFactor((Entity)living);
    }

    protected static float getJumpFactor(Entity entity) {
        float f = entity.field_70170_p.func_180495_p(entity.func_233580_cy_()).func_177230_c().func_226892_n_();
        float f1 = entity.field_70170_p.func_180495_p(EntityHelper.getPositionUnderneath(entity)).func_177230_c().func_226892_n_();
        return (double)f == 1.0 ? f1 : f;
    }

    protected static BlockPos getPositionUnderneath(Entity entity) {
        return new BlockPos(entity.func_226277_ct_(), entity.func_174813_aQ().field_72338_b - 0.5000001, entity.func_226281_cx_());
    }

    private static AttributeModifierMap.MutableAttribute mutable(EntityType<? extends LivingEntity> livingEntity, Attribute attributeIn) {
        AttributeModifierMap playerAttributes = GlobalEntityTypeAttributes.func_233835_a_(livingEntity);
        AttributeModifierMap.MutableAttribute currentAttributes = PlayerEntity.func_234570_el_();
        boolean flag = false;
        for (Attribute attribute : ForgeRegistries.ATTRIBUTES) {
            if (!playerAttributes.func_233809_c_(attribute)) continue;
            if (attribute.equals(attributeIn)) {
                UnionLib.warn("Attribute " + attribute.getRegistryName() + " already exists in " + livingEntity.func_212546_e().getString() + ". Ignoring");
                flag = true;
            }
            if (flag) continue;
            currentAttributes.func_233815_a_(attribute, playerAttributes.func_233807_b_(attribute));
        }
        return currentAttributes;
    }

    public static void registerAttribute(EntityType<? extends LivingEntity> livingEntity, Attribute attributeIn) {
        GlobalEntityTypeAttributes.put(livingEntity, (AttributeModifierMap)EntityHelper.mutable(livingEntity, attributeIn).func_233814_a_(attributeIn).func_233813_a_());
    }

    public static void registerAttribute(EntityType<? extends LivingEntity> livingEntity, Attribute attributeIn, float baseValue) {
        GlobalEntityTypeAttributes.put(livingEntity, (AttributeModifierMap)EntityHelper.mutable(livingEntity, attributeIn).func_233815_a_(attributeIn, (double)baseValue).func_233813_a_());
    }

    public static void registerAttributes(EntityType<? extends LivingEntity> type, Consumer<AttributeModifierMap.MutableAttribute> builder) {
        AttributeModifierMap.MutableAttribute newAttrs = AttributeModifierMap.func_233803_a_();
        if (GlobalEntityTypeAttributes.func_233837_b_(type)) {
            newAttrs.field_233811_a_.putAll(GlobalEntityTypeAttributes.func_233835_a_(type).field_233802_a_);
        }
        builder.accept(newAttrs);
        GlobalEntityTypeAttributes.put(type, (AttributeModifierMap)newAttrs.func_233813_a_());
    }

    public static double getAttributeValue(LivingEntity livingEntity, Attribute attribute) {
        if (livingEntity.func_110148_a(attribute) != null) {
            return livingEntity.func_233637_b_(attribute);
        }
        UnionLib.warn("Did not find attribute " + attribute.getRegistryName() + " in " + livingEntity.func_200200_C_().getString() + ". Returning default attribute value");
        EntityHelper.registerAttribute((EntityType<? extends LivingEntity>)livingEntity.func_200600_R(), attribute);
        UnionLib.debug("Attempted to put attribute " + attribute.getRegistryName() + " in " + livingEntity.func_200200_C_().getString());
        return attribute.func_111110_b();
    }

    public static double getBaseAttributeValue(LivingEntity livingEntity, Attribute attribute) {
        if (livingEntity.func_110148_a(attribute) != null) {
            return livingEntity.func_233638_c_(attribute);
        }
        UnionLib.warn("Did not find attribute " + attribute.getRegistryName() + " in " + livingEntity.func_200200_C_().getString() + ". Returning default attribute value");
        EntityHelper.registerAttribute((EntityType<? extends LivingEntity>)livingEntity.func_200600_R(), attribute);
        UnionLib.debug("Attempted to put attribute " + attribute.getRegistryName() + " in " + livingEntity.func_200200_C_().getString());
        return attribute.func_111110_b();
    }
}

