/*
 * Decompiled with CFR 0.152.
 */
package me.ivan.villagerhelper;

import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import net.minecraft.class_1132;
import net.minecraft.class_1159;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1646;
import net.minecraft.class_1772;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1890;
import net.minecraft.class_1914;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_4140;
import net.minecraft.class_4184;
import net.minecraft.class_4208;
import net.minecraft.class_4493;
import net.minecraft.class_4590;
import net.minecraft.class_4597;

public class VillagerHelper {
    private static final VillagerHelper INSTANCE = new VillagerHelper();
    public static final class_310 mc = class_310.method_1551();
    public static final float RENDER_DISTANCE = 256.0f;

    public static VillagerHelper getInstance() {
        return INSTANCE;
    }

    public void renderVillagerInfo(float tickDelta) {
        class_1132 server = mc.method_1576();
        if (server == null) {
            return;
        }
        class_3218 world = server.method_3847(VillagerHelper.mc.field_1724.field_6026);
        for (class_1297 entity2 : world.method_18198(class_1299.field_6077, entity -> true)) {
            if (!(entity2 instanceof class_1646) || !(entity2.method_5739(VillagerHelper.mc.field_1719) <= 256.0f)) continue;
            class_1646 villager = (class_1646)entity2;
            class_243 villagerPos = villager.method_19538();
            float villagerHeightOffset = villager.method_6109() ? 0.5f : 1.0f;
            for (class_1914 offer : villager.method_8264()) {
                class_1792 sell = offer.method_18019().method_7909();
                if (!(sell instanceof class_1772)) continue;
                class_1890.method_8222((class_1799)offer.method_18019()).forEach((enchantment, integer) -> {
                    class_1792 buy1 = offer.method_8246().method_7909();
                    class_1792 buy2 = offer.method_8247().method_7909();
                    int price = -1;
                    if (buy1 == class_1802.field_8687) {
                        price = offer.method_8246().method_7947();
                    } else if (buy2 == class_1802.field_8687) {
                        price = offer.method_8247().method_7947();
                    }
                    VillagerHelper.drawString(enchantment.method_8179(integer.intValue()).getString(), villagerPos.method_10216(), villagerPos.method_10214() + 2.5, villagerPos.method_10215(), tickDelta, class_124.field_1075.method_532(), -0.5f);
                    VillagerHelper.drawString(Integer.toString(price), villagerPos.method_10216(), villagerPos.method_10214() + 2.5, villagerPos.method_10215(), tickDelta, class_124.field_1060.method_532(), 0.5f);
                });
            }
            boolean hasBed = villager.method_18868().method_18904(class_4140.field_18438).isPresent();
            boolean hasJobSite = villager.method_18868().method_18904(class_4140.field_18439).isPresent();
            if (hasJobSite) {
                class_2338 jobSitePos = ((class_4208)villager.method_18868().method_18904(class_4140.field_18439).get()).method_19446();
                VillagerHelper.drawLine(villagerPos.method_10216(), villagerPos.method_10214() + (double)villagerHeightOffset, villagerPos.method_10215(), (double)jobSitePos.method_10263() + 0.5, (double)jobSitePos.method_10264() + 0.5, (double)jobSitePos.method_10260() + 0.5, new Color(class_124.field_1078.method_532()), 5.0f, VillagerHelper.mc.field_1773.method_19418(), tickDelta);
            }
            if (!hasBed) continue;
            class_2338 bedPos = ((class_4208)villager.method_18868().method_18904(class_4140.field_18438).get()).method_19446();
            VillagerHelper.drawLine(villagerPos.method_10216(), villagerPos.method_10214() + (double)villagerHeightOffset, villagerPos.method_10215(), (double)bedPos.method_10263() + 0.5, (double)bedPos.method_10264() + 0.5, (double)bedPos.method_10260() + 0.5, new Color(class_124.field_1061.method_532()), 5.0f, VillagerHelper.mc.field_1773.method_19418(), tickDelta);
        }
    }

    private static void drawLine(class_2338 start, class_2338 end, Color color, float lineWidth, class_4184 camera, float tickDelta) {
        VillagerHelper.drawLine(start.method_10263(), start.method_10264(), start.method_10260(), end.method_10263(), end.method_10264(), end.method_10260(), color, lineWidth, camera, tickDelta);
    }

    private static void drawLine(double startX, double startY, double startZ, double endX, double endY, double endZ, Color color, float lineWidth, class_4184 camera, float tickDelta) {
        double cameraX = camera.method_19326().method_10216();
        double cameraY = camera.method_19326().method_10214();
        double cameraZ = camera.method_19326().method_10215();
        class_4493.method_21912();
        class_4493.method_22056();
        class_287 bufferBuilder = class_289.method_1348().method_1349();
        bufferBuilder.method_1328(3, class_290.field_1576);
        class_4493.method_22013((float)lineWidth);
        bufferBuilder.method_22912(startX - cameraX, startY - cameraY, startZ - cameraZ).method_1336(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).method_1344();
        bufferBuilder.method_22912(endX - cameraX, endY - cameraY, endZ - cameraZ).method_1336(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).method_1344();
        class_289.method_1348().method_1350();
        class_4493.method_22013((float)lineWidth);
    }

    public static void drawString(String text, class_2338 pos, float tickDelta, int color, float line) {
        VillagerHelper.drawString(text, pos.method_10263(), pos.method_10264(), pos.method_10260(), tickDelta, color, line);
    }

    public static void drawString(String text, class_243 pos, float tickDelta, int color, float line) {
        VillagerHelper.drawString(text, pos.method_10216(), pos.method_10214(), pos.method_10215(), tickDelta, color, line);
    }

    public static void drawString(String text, double x, double y, double z, float tickDelta, int color, float line) {
        class_310 client = class_310.method_1551();
        class_4184 camera = client.field_1773.method_19418();
        if (camera.method_19332() && client.method_1561().field_4692 != null && client.field_1724 != null) {
            if (client.field_1724.method_5649(x, y, z) > 65536.0) {
                return;
            }
            double camX = camera.method_19326().field_1352;
            double camY = camera.method_19326().field_1351;
            double camZ = camera.method_19326().field_1350;
            RenderSystem.pushMatrix();
            RenderSystem.translatef((float)((float)(x - camX)), (float)((float)(y - camY)), (float)((float)(z - camZ)));
            RenderSystem.normal3f((float)0.0f, (float)1.0f, (float)0.0f);
            RenderSystem.multMatrix((class_1159)new class_1159(camera.method_23767()));
            RenderSystem.scalef((float)0.025f, (float)-0.025f, (float)0.025f);
            RenderSystem.enableTexture();
            RenderSystem.disableDepthTest();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.scalef((float)-1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableAlphaTest();
            class_4597.class_4598 immediate = class_4597.method_22991((class_287)class_289.method_1348().method_1349());
            float renderX = (float)(-client.field_1772.method_1727(text)) * 0.5f;
            float renderY = (float)client.field_1772.method_1713(text, Integer.MAX_VALUE) * (-0.5f + 1.25f * line);
            class_1159 matrix4f = class_4590.method_22931().method_22936();
            client.field_1772.method_22942(text, renderX, renderY, color, false, matrix4f, (class_4597)immediate, true, 0, 0xF000F0);
            immediate.method_22993();
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableDepthTest();
            RenderSystem.popMatrix();
        }
    }
}

