/*
 * Decompiled with CFR 0.152.
 */
package com.dainxt.weaponthrow.events;

import com.dainxt.weaponthrow.projectile.WeaponThrowEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.Cancelable;

public class WeaponThrowEvent
extends PlayerEvent {
    ItemStack throwedStack;

    public WeaponThrowEvent(ItemStack stack, PlayerEntity player) {
        super(player);
        this.throwedStack = stack;
    }

    public ItemStack getThrowedStack() {
        return this.throwedStack;
    }

    @Cancelable
    public static class OnImpact
    extends WeaponThrowEvent {
        WeaponThrowEntity entity;
        RayTraceResult rayTrace;

        public OnImpact(WeaponThrowEntity item, PlayerEntity player, RayTraceResult result) {
            super(item.getItemStack(), player);
            this.entity = item;
            this.rayTrace = result;
        }

        public WeaponThrowEntity getItemThrowed() {
            return this.entity;
        }

        public RayTraceResult getRayTraceResult() {
            return this.rayTrace;
        }
    }

    public static class OnThrow
    extends WeaponThrowEvent {
        public double totalDamage;
        public double totalVelocity;
        public double totalExhaustion;

        public OnThrow(ItemStack stack, PlayerEntity player, double damage, double velocity, double exhaustion) {
            super(stack, player);
            this.totalDamage = damage;
            this.totalVelocity = velocity;
            this.totalExhaustion = exhaustion;
        }
    }

    @Cancelable
    public static class TestThrow
    extends WeaponThrowEvent {
        public TestThrow(ItemStack stack, PlayerEntity player) {
            super(stack, player);
        }
    }
}

