/*
 * Decompiled with CFR 0.152.
 */
package com.dainxt.weaponthrow.handlers;

import com.dainxt.weaponthrow.capabilities.ThrowPower;
import com.dainxt.weaponthrow.capabilities.ThrowProvider;
import com.dainxt.weaponthrow.config.WeaponThrowConfig;
import com.dainxt.weaponthrow.events.WeaponThrowEvent;
import com.dainxt.weaponthrow.handlers.KeyBindingHandler;
import com.dainxt.weaponthrow.handlers.PacketHandler;
import com.dainxt.weaponthrow.interfaces.IThrowPower;
import com.dainxt.weaponthrow.packets.CPacketThrow;
import com.dainxt.weaponthrow.packets.SPacketThrow;
import com.dainxt.weaponthrow.projectile.WeaponThrowEntity;
import com.google.common.collect.Multimap;
import com.mojang.blaze3d.matrix.MatrixStack;
import harmonised.pmmo.config.JType;
import harmonised.pmmo.skills.Skill;
import harmonised.pmmo.util.XP;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.FirstPersonRenderer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.InputUpdateEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;

public class EventsHandler {
    public static final ResourceLocation THROWPOWER = new ResourceLocation("weaponthrow", "throw_power");
    public boolean wasPressed = false;
    public float clientSideCharge;

    public static void onThrowItem(ServerPlayerEntity playerentity, CPacketThrow.State action) {
        World worldIn = playerentity.field_70170_p;
        ItemStack stack = playerentity.func_184614_ca();
        boolean isThrowable = (Boolean)WeaponThrowConfig.COMMON.shouldThrowItemsToo.get();
        for (Item item : WeaponThrowConfig.COMMON.whiteList.get()) {
            if (!stack.func_77973_b().equals(item)) continue;
            isThrowable = true;
        }
        if (ModList.get().isLoaded("pmmo") && ((Boolean)WeaponThrowConfig.COMMON.enablePMMOIntegration.get()).booleanValue()) {
            int combatLevel;
            ResourceLocation resLoc = playerentity.func_184614_ca().func_77973_b().getRegistryName();
            Map weaponReq = XP.getJsonMap((ResourceLocation)resLoc, (JType)JType.REQ_WEAPON);
            double reqLevel = 0.0;
            if (weaponReq.containsKey(Skill.COMBAT.name.toLowerCase())) {
                reqLevel = (Double)weaponReq.get(Skill.COMBAT.name.toLowerCase());
            }
            if (reqLevel > (double)(combatLevel = Skill.getLevel((String)Skill.COMBAT.name.toLowerCase(), (UUID)playerentity.func_110124_au())) && reqLevel > 0.0) {
                playerentity.func_146105_b((ITextComponent)new TranslationTextComponent("weaponthrow.pmmo.requirementThrowing", new Object[]{reqLevel}), true);
                return;
            }
        }
        WeaponThrowEvent.TestThrow testEvent = new WeaponThrowEvent.TestThrow(stack, (PlayerEntity)playerentity);
        boolean isCancelled = MinecraftForge.EVENT_BUS.post((Event)testEvent);
        Multimap multimap = stack.func_111283_C(EquipmentSlotType.MAINHAND);
        boolean haveAttributes = multimap.containsKey((Object)Attributes.field_233823_f_) || multimap.containsKey((Object)Attributes.field_233825_h_);
        IThrowPower provider = (IThrowPower)playerentity.getCapability(ThrowProvider.THROW_POWER).orElse(ThrowProvider.THROW_POWER.getDefaultInstance());
        if ((isThrowable || haveAttributes) && !isCancelled && !stack.func_190926_b()) {
            boolean cdConfig = (Boolean)WeaponThrowConfig.COMMON.notUseWhenCooldown.get();
            if (!(playerentity.func_184811_cZ().func_185143_a(stack.func_77973_b(), 1.0f) > 0.0f) || !cdConfig) {
                provider.setAction(action);
                if (action.equals((Object)CPacketThrow.State.START) && provider.getChargeTime() <= 0) {
                    provider.startCharging(stack, (PlayerEntity)playerentity);
                }
                if (action.equals((Object)CPacketThrow.State.FINISH) && provider.getChargeTime() >= 0) {
                    float baseThrow = 0.0f;
                    float baseExhaustion = 0.05f;
                    float modThrow = 1.0f - (float)provider.getChargeTime() / (float)ThrowPower.getMaximumCharge((PlayerEntity)playerentity);
                    provider.resetCharging();
                    double defaultVelocity = (Double)WeaponThrowConfig.COMMON.baseVelocityDefault.get();
                    if (((Boolean)WeaponThrowConfig.COMMON.shouldThrowItemsToo.get()).booleanValue()) {
                        baseThrow = (float)defaultVelocity;
                    } else if (!WeaponThrowConfig.COMMON.whiteList.get().isEmpty()) {
                        for (Item item : WeaponThrowConfig.COMMON.whiteList.get()) {
                            if (!stack.func_77973_b().equals(item)) continue;
                            baseThrow = (float)defaultVelocity;
                        }
                    }
                    if (haveAttributes) {
                        baseThrow = 20.0f / playerentity.func_184818_cX();
                        baseExhaustion = playerentity.func_184818_cX() / 20.0f;
                    }
                    if (baseThrow > 0.0f) {
                        boolean shouldDestroy = (double)modThrow > 0.99;
                        float baseDamage = 0.01f;
                        double toolMultiplier = 0.0;
                        double defaultDamage = (Double)WeaponThrowConfig.COMMON.baseDamageDefault.get();
                        if (!WeaponThrowConfig.COMMON.whiteList.get().isEmpty()) {
                            for (Item item : WeaponThrowConfig.COMMON.whiteList.get()) {
                                if (!stack.func_77973_b().equals(item)) continue;
                                baseDamage = (float)defaultDamage;
                                baseExhaustion = 1.0f / baseThrow;
                            }
                        }
                        if (haveAttributes) {
                            baseDamage = (float)playerentity.func_233637_b_(Attributes.field_233823_f_);
                            Set types = stack.getToolTypes();
                            if (types.contains(ToolType.AXE)) {
                                toolMultiplier += ((Double)WeaponThrowConfig.COMMON.axeMultiplier.get()).doubleValue();
                            }
                            if (types.contains(ToolType.HOE)) {
                                toolMultiplier += ((Double)WeaponThrowConfig.COMMON.hoeMultiplier.get()).doubleValue();
                            }
                            if (types.contains(ToolType.PICKAXE)) {
                                toolMultiplier += ((Double)WeaponThrowConfig.COMMON.pickaxeMultiplier.get()).doubleValue();
                            }
                            if (types.contains(ToolType.SHOVEL)) {
                                toolMultiplier += ((Double)WeaponThrowConfig.COMMON.shovelMultiplier.get()).doubleValue();
                            }
                            if (types.isEmpty()) {
                                toolMultiplier = (Double)WeaponThrowConfig.COMMON.swordMultiplier.get();
                            }
                            toolMultiplier /= (double)(types.size() > 0 ? types.size() : 1);
                        }
                        if (toolMultiplier == 0.0) {
                            toolMultiplier = 1.0;
                        }
                        int size = playerentity.func_213453_ef() ? stack.func_190916_E() : 1;
                        double bDamageMul = (Double)WeaponThrowConfig.COMMON.baseDamageMultiplier.get();
                        double sDamageMul = (Double)WeaponThrowConfig.COMMON.stackDamageMultiplier.get();
                        double mDamageMul = (Double)WeaponThrowConfig.COMMON.modifiedDamageMultiplier.get();
                        double totalDamage = (double)baseDamage * (1.0 * bDamageMul + (double)modThrow * mDamageMul) + (double)size * sDamageMul;
                        totalDamage *= toolMultiplier;
                        double bVelocityMul = (Double)WeaponThrowConfig.COMMON.baseVelocityMultiplier.get();
                        double sVelocityMul = (Double)WeaponThrowConfig.COMMON.stackVelocityMultiplier.get();
                        double mVelocityMul = (Double)WeaponThrowConfig.COMMON.modifiedVelocityMultiplier.get();
                        double totalVelocity = (double)baseThrow * (1.0 * bVelocityMul + (double)modThrow * mVelocityMul) - (double)size * sVelocityMul;
                        double bExhaustionMul = (Double)WeaponThrowConfig.COMMON.baseExhaustionMultiplier.get();
                        double sExhaustionMul = (Double)WeaponThrowConfig.COMMON.stackExhaustionMultiplier.get();
                        double mExhaustionMul = (Double)WeaponThrowConfig.COMMON.modifiedExhaustionMultiplier.get();
                        double totalExhaustion = (double)baseExhaustion * (1.0 * bExhaustionMul + (double)modThrow * mExhaustionMul) + (double)size * sExhaustionMul;
                        WeaponThrowEvent.OnThrow onThrowEvent = new WeaponThrowEvent.OnThrow(stack, (PlayerEntity)playerentity, totalDamage, totalVelocity *= toolMultiplier, totalExhaustion *= toolMultiplier);
                        MinecraftForge.EVENT_BUS.post((Event)onThrowEvent);
                        WeaponThrowEntity throwedEntity = new WeaponThrowEntity(worldIn, (LivingEntity)playerentity, shouldDestroy, (float)onThrowEvent.totalDamage, stack.func_77979_a(size));
                        throwedEntity.func_234612_a_((Entity)playerentity, playerentity.field_70125_A, playerentity.field_70177_z, 0.0f, (float)onThrowEvent.totalVelocity, 1.0f);
                        playerentity.func_71020_j((float)onThrowEvent.totalExhaustion);
                        worldIn.func_217376_c((Entity)throwedEntity);
                        SoundEvent soundevent = SoundEvents.field_187511_aA;
                        throwedEntity.func_184185_a(soundevent, 1.0f, 0.5f);
                    }
                }
            }
        }
        if (stack.func_190926_b() || !provider.getChargingStack().equals(stack)) {
            provider.resetCharging();
        }
    }

    @SubscribeEvent
    public void onPlayerToss(ItemTossEvent event) {
        event.getPlayer().getCapability(ThrowProvider.THROW_POWER).ifPresent(cap -> {
            if (!cap.getAction().equals((Object)CPacketThrow.State.NONE)) {
                event.setCanceled(true);
            }
        });
    }

    @SubscribeEvent
    public void attachCapability(AttachCapabilitiesEvent<Entity> event) {
        if (!(event.getObject() instanceof PlayerEntity)) {
            return;
        }
        event.addCapability(THROWPOWER, (ICapabilityProvider)new ThrowProvider());
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase.equals((Object)TickEvent.Phase.START)) {
            event.player.getCapability(ThrowProvider.THROW_POWER).ifPresent(cap -> {
                if (!event.player.field_70170_p.field_72995_K) {
                    boolean attacked = event.player.func_184825_o(0.0f) < 1.0f;
                    boolean cdConfig = (Boolean)WeaponThrowConfig.COMMON.notUseWhenCooldown.get();
                    if (attacked && cdConfig) {
                        cap.resetCharging();
                    }
                    if (cap.getChargeTime() > 0) {
                        cap.setChargeTime(cap.getChargeTime() - 1);
                    }
                    if (cap.getAction().equals((Object)CPacketThrow.State.START) || cap.getAction().equals((Object)CPacketThrow.State.FINISH)) {
                        PacketHandler.sendToAll(new SPacketThrow(event.player.func_110124_au(), ThrowPower.getMaximumCharge(event.player), cap.getAction().equals((Object)CPacketThrow.State.START)));
                        if (cap.getAction().equals((Object)CPacketThrow.State.FINISH)) {
                            cap.setAction(CPacketThrow.State.NONE);
                        }
                    }
                } else {
                    this.clientSideCharge = cap.getAction().equals((Object)CPacketThrow.State.DURING) ? this.clientSideCharge + 1.0f : 0.0f;
                }
            });
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void onSeverUpdate(UUID playerUUID, int chargeTime, boolean isCharging) {
        PlayerEntity playerentity = Minecraft.func_71410_x().field_71441_e.func_217371_b(playerUUID);
        if (playerentity != null) {
            playerentity.getCapability(ThrowProvider.THROW_POWER).ifPresent(cap -> {
                cap.setMaxChargeTime(chargeTime);
                cap.setAction(isCharging ? CPacketThrow.State.DURING : CPacketThrow.State.NONE);
            });
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void renderView(RenderGameOverlayEvent.Post event) {
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void updateFov(FOVUpdateEvent event) {
        IThrowPower optionalCapability = (IThrowPower)Minecraft.func_71410_x().field_71439_g.getCapability(ThrowProvider.THROW_POWER).orElse(ThrowProvider.THROW_POWER.getDefaultInstance());
        int maxChargeTime = optionalCapability.getMaxChargeTime();
        boolean isCharging = optionalCapability.getAction().equals((Object)CPacketThrow.State.DURING);
        if (isCharging) {
            float f = event.getFov();
            int i = (int)this.clientSideCharge;
            float f1 = (float)i / (float)maxChargeTime;
            f1 = f1 > 1.0f ? 1.0f : (f1 *= f1);
            event.setNewfov(f *= 1.0f + f1 * 0.15f);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void renderHandAnimation(RenderHandEvent event) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        FirstPersonRenderer renderer = Minecraft.func_71410_x().func_175597_ag();
        player.getCapability(ThrowProvider.THROW_POWER).ifPresent(cap -> {
            if (cap.getAction().equals((Object)CPacketThrow.State.DURING)) {
                MatrixStack matrices = event.getMatrixStack();
                boolean flag = event.getHand() == Hand.MAIN_HAND;
                HandSide humanoidarm = flag ? player.func_184591_cq() : player.func_184591_cq().func_188468_a();
                int i = humanoidarm == HandSide.RIGHT ? 1 : -1;
                boolean flag3 = humanoidarm == HandSide.RIGHT;
                float progress = MathHelper.func_76131_a((float)((this.clientSideCharge + event.getPartialTicks()) / (float)cap.getMaxChargeTime()), (float)0.0f, (float)1.0f);
                matrices.func_227860_a_();
                matrices.func_227861_a_((double)((float)i * 0.56f), (double)(-0.52f + event.getEquipProgress() * -0.6f), (double)-0.72f);
                matrices.func_227861_a_(0.0, (double)(progress * 0.66f), (double)(progress * 0.3f));
                matrices.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(progress * 10.0f));
                matrices.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(progress * 30.0f));
                renderer.func_228397_a_((LivingEntity)player, event.getItemStack(), flag3 ? ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND : ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, !flag3, matrices, event.getBuffers(), event.getLight());
                matrices.func_227865_b_();
                event.setCanceled(true);
            }
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void renderPlayer(RenderPlayerEvent event) {
        event.getEntity().getCapability(ThrowProvider.THROW_POWER).ifPresent(cap -> {
            if (cap.getAction().equals((Object)CPacketThrow.State.DURING) && event.getEntity() instanceof AbstractClientPlayerEntity) {
                HandSide hand = ((AbstractClientPlayerEntity)event.getEntity()).func_184591_cq();
                if (hand == HandSide.RIGHT) {
                    ((PlayerModel)event.getRenderer().func_217764_d()).field_187076_m = BipedModel.ArmPose.THROW_SPEAR;
                } else {
                    ((PlayerModel)event.getRenderer().func_217764_d()).field_187075_l = BipedModel.ArmPose.THROW_SPEAR;
                }
            }
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void inputUpdate(InputUpdateEvent event) {
        IThrowPower optionalCapability = (IThrowPower)Minecraft.func_71410_x().field_71439_g.getCapability(ThrowProvider.THROW_POWER).orElse(ThrowProvider.THROW_POWER.getDefaultInstance());
        boolean isCharging = optionalCapability.getAction().equals((Object)CPacketThrow.State.DURING);
        if (isCharging) {
            event.getMovementInput().field_78902_a *= 0.2f;
            event.getMovementInput().field_192832_b *= 0.2f;
        }
    }

    @SubscribeEvent
    public void onKeyInput(InputEvent.KeyInputEvent event) {
        KeyModifier keyModifier = KeyBindingHandler.KEYBINDING.getKeyModifier();
        boolean isPrincipalModifier = keyModifier.equals((Object)KeyModifier.NONE) ? true : keyModifier.equals((Object)KeyModifier.getActiveModifier());
        boolean pressed = KeyBindingHandler.KEYBINDING.func_151470_d();
        if (pressed && isPrincipalModifier) {
            PacketHandler.sendToServer(new CPacketThrow(this.wasPressed ? CPacketThrow.State.DURING : CPacketThrow.State.START));
            this.wasPressed = true;
        } else if (this.wasPressed) {
            PacketHandler.sendToServer(new CPacketThrow(CPacketThrow.State.FINISH));
            this.wasPressed = false;
        }
    }
}

