/*
 * Decompiled with CFR 0.152.
 */
package com.dainxt.weaponthrow.projectile;

import com.dainxt.weaponthrow.config.WeaponThrowConfig;
import com.dainxt.weaponthrow.events.WeaponThrowEvent;
import com.dainxt.weaponthrow.handlers.EnchantmentHandler;
import com.dainxt.weaponthrow.handlers.EntityHandler;
import harmonised.pmmo.skills.Skill;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.AnvilBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SandBlock;
import net.minecraft.block.TorchBlock;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRendersAsItem;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.network.NetworkHooks;

@OnlyIn(value=Dist.CLIENT, _interface=IRendersAsItem.class)
public class WeaponThrowEntity
extends AbstractArrowEntity
implements IRendersAsItem {
    private float clientSideRotation = 0.0f;
    private boolean counterClockwiseBounce = true;
    private static final DataParameter<Byte> LOYALTY_LEVEL = EntityDataManager.func_187226_a(WeaponThrowEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<CompoundNBT> COMPOUND_STACK = EntityDataManager.func_187226_a(WeaponThrowEntity.class, (IDataSerializer)DataSerializers.field_192734_n);
    private static final DataParameter<BlockPos> DESTROYED_BLOCK = EntityDataManager.func_187226_a(WeaponThrowEntity.class, (IDataSerializer)DataSerializers.field_187200_j);
    private static final DataParameter<Boolean> SHOULD_DESTROY = EntityDataManager.func_187226_a(WeaponThrowEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private boolean dealtDamage;
    private float attackDamage;
    public int returningTicks;
    @Nullable
    private BlockState lastState;

    public WeaponThrowEntity(EntityType<? extends WeaponThrowEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public WeaponThrowEntity(World worldIn, LivingEntity thrower, boolean canDestroy, float attackDamage, ItemStack thrownStackIn) {
        super(EntityHandler.WEAPONTHROW, thrower, worldIn);
        this.attackDamage = attackDamage;
        this.field_70180_af.func_187227_b(COMPOUND_STACK, (Object)thrownStackIn.func_77946_l().func_77955_b(new CompoundNBT()));
        this.field_70180_af.func_187227_b(LOYALTY_LEVEL, (Object)((byte)WeaponThrowEntity.getReturnOrLoyaltyEnchantment(thrownStackIn)));
        this.field_70180_af.func_187227_b(DESTROYED_BLOCK, (Object)BlockPos.field_177992_a);
        this.field_70180_af.func_187227_b(SHOULD_DESTROY, (Object)canDestroy);
    }

    @OnlyIn(value=Dist.CLIENT)
    public WeaponThrowEntity(World worldIn, double x, double y, double z) {
        super(EntityHandler.WEAPONTHROW, x, y, z, worldIn);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(COMPOUND_STACK, (Object)new CompoundNBT());
        this.field_70180_af.func_187214_a(LOYALTY_LEVEL, (Object)0);
        this.field_70180_af.func_187214_a(DESTROYED_BLOCK, (Object)BlockPos.field_177992_a);
        this.field_70180_af.func_187214_a(SHOULD_DESTROY, (Object)false);
    }

    public void setItemStack(ItemStack stack) {
        this.func_184212_Q().func_187227_b(COMPOUND_STACK, (Object)stack.func_77955_b(new CompoundNBT()));
    }

    public ItemStack getItemStack() {
        return ItemStack.func_199557_a((CompoundNBT)((CompoundNBT)this.func_184212_Q().func_187225_a(COMPOUND_STACK)));
    }

    public void shouldDestroy(boolean stack) {
        this.func_184212_Q().func_187227_b(SHOULD_DESTROY, (Object)stack);
    }

    public boolean shouldDestroy() {
        return (Boolean)this.func_184212_Q().func_187225_a(SHOULD_DESTROY);
    }

    public void setDestroyedBlock(BlockPos pos) {
        this.func_184212_Q().func_187227_b(DESTROYED_BLOCK, (Object)pos);
    }

    public BlockPos getDestroyedBlock() {
        return (BlockPos)this.func_184212_Q().func_187225_a(DESTROYED_BLOCK);
    }

    public void func_70071_h_() {
        int gravityLevel;
        if (this.field_184552_b > 4 && !this.dealtDamage) {
            this.dealtDamage = true;
        }
        if (!this.getDestroyedBlock().equals((Object)BlockPos.field_177992_a) && !this.field_70170_p.field_72995_K) {
            this.doInteractions(() -> {
                SoundEvent event = this.field_70170_p.func_180495_p(this.getDestroyedBlock()).func_215695_r().func_185845_c();
                boolean destroyed = ((ServerPlayerEntity)this.func_234616_v_()).field_71134_c.func_180237_b(this.getDestroyedBlock());
                if (destroyed) {
                    this.field_70170_p.func_184133_a(null, this.getDestroyedBlock(), event, SoundCategory.AMBIENT, 10.0f, 1.0f);
                }
            });
            this.setDestroyedBlock(BlockPos.field_177992_a);
        }
        int n = gravityLevel = (Boolean)WeaponThrowConfig.COMMON.gravityEnchant.get() != false ? EnchantmentHelper.func_77506_a((Enchantment)EnchantmentHandler.GRAVITY, (ItemStack)this.getItemStack()) : 0;
        if (gravityLevel > 0) {
            this.func_189654_d(true);
            if (World.func_189509_E((BlockPos)this.func_226270_aj_())) {
                this.func_213317_d(this.func_213322_ci().func_216372_d(1.0, 0.0, 1.0));
            }
            if (Math.abs(this.func_213322_ci().func_82615_a()) < 0.1 && Math.abs(this.func_213322_ci().func_82616_c()) < 0.1 && ((Boolean)WeaponThrowConfig.COMMON.gravityDrop.get()).booleanValue()) {
                this.func_189654_d(false);
            }
        }
        if (this.field_70254_i && MathHelper.func_76135_e((float)this.field_70125_A) < 45.0f && this.getItemStack().func_77973_b() instanceof BlockItem) {
            this.func_213317_d(this.func_213322_ci().func_186678_a(-0.5));
            this.counterClockwiseBounce = !this.counterClockwiseBounce;
            this.field_70254_i = false;
        }
        Entity entity = this.func_234616_v_();
        if ((this.dealtDamage || this.func_203047_q()) && entity != null) {
            int i;
            int n2 = i = (Boolean)WeaponThrowConfig.COMMON.returnEnchant.get() != false ? (int)((Byte)this.field_70180_af.func_187225_a(LOYALTY_LEVEL)).byteValue() : 0;
            if (i > 0 && ModList.get().isLoaded("pmmo") && ((Boolean)WeaponThrowConfig.COMMON.enablePMMOIntegration.get()).booleanValue()) {
                int combatLevel = Skill.getLevel((String)Skill.COMBAT.name.toLowerCase(), (UUID)entity.func_110124_au());
                int requiredLevel = (Integer)WeaponThrowConfig.COMMON.requiredCombatLoyalty.get();
                if (requiredLevel > combatLevel && requiredLevel > 0) {
                    if (entity instanceof PlayerEntity) {
                        ((PlayerEntity)entity).func_146105_b((ITextComponent)new TranslationTextComponent("weaponthrow.pmmo.requirementLoyalty", new Object[]{requiredLevel}), true);
                    }
                    i = 0;
                }
            }
            if (i > 0 && !this.shouldReturnToThrower()) {
                if (!this.field_70170_p.field_72995_K && this.field_70251_a == AbstractArrowEntity.PickupStatus.ALLOWED) {
                    this.func_70099_a(this.func_184550_j(), 0.1f);
                }
                this.func_70106_y();
            } else if (i > 0) {
                this.func_203045_n(true);
                Vector3d vector3d = new Vector3d(entity.func_226277_ct_() - this.func_226277_ct_(), entity.func_226280_cw_() - this.func_226278_cu_(), entity.func_226281_cx_() - this.func_226281_cx_());
                this.func_226288_n_(this.func_226277_ct_(), this.func_226278_cu_() + vector3d.field_72448_b * 0.015 * (double)i, this.func_226281_cx_());
                if (this.field_70170_p.field_72995_K) {
                    this.field_70137_T = this.func_226278_cu_();
                }
                double d0 = 0.05 * (double)i;
                this.func_213317_d(this.func_213322_ci().func_186678_a(0.95).func_178787_e(vector3d.func_72432_b().func_186678_a(d0)));
                if (this.returningTicks == 0) {
                    this.func_184185_a(SoundEvents.field_203270_il, 10.0f, 1.0f);
                }
                ++this.returningTicks;
            }
        }
        super.func_70071_h_();
    }

    private boolean shouldReturnToThrower() {
        Entity entity = this.func_234616_v_();
        if (entity != null && entity.func_70089_S()) {
            return !(entity instanceof ServerPlayerEntity) || !entity.func_175149_v();
        }
        return false;
    }

    protected ItemStack func_184550_j() {
        return this.getItemStack().func_77946_l();
    }

    @Nullable
    protected EntityRayTraceResult func_213866_a(Vector3d startVec, Vector3d endVec) {
        return this.dealtDamage ? null : super.func_213866_a(startVec, endVec);
    }

    protected void func_213868_a(EntityRayTraceResult p_213868_1_) {
        Entity entity1;
        Entity entity = p_213868_1_.func_216348_a();
        float f = this.attackDamage;
        if (entity instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity;
            f += (Boolean)WeaponThrowConfig.COMMON.throwEnchant.get() != false ? (float)EnchantmentHelper.func_77506_a((Enchantment)EnchantmentHandler.THROW, (ItemStack)this.getItemStack()) * 1.0f : 0.0f;
            f += EnchantmentHelper.func_152377_a((ItemStack)this.getItemStack(), (CreatureAttribute)livingentity.func_70668_bt());
        }
        DamageSource damagesource = DamageSource.func_76356_a((Entity)this, (Entity)((entity1 = this.func_234616_v_()) == null ? this : entity1));
        this.dealtDamage = true;
        SoundEvent soundevent = SoundEvents.field_203268_ij;
        if (entity.func_70097_a(damagesource, f)) {
            if (entity.func_200600_R() == EntityType.field_200803_q) {
                return;
            }
            if (entity instanceof LivingEntity) {
                List nearEntities;
                int groundedLevel;
                int contusionLevel;
                LivingEntity livingentity1 = (LivingEntity)entity;
                int n = contusionLevel = (Boolean)WeaponThrowConfig.COMMON.conccusionEnchant.get() != false ? EnchantmentHelper.func_77506_a((Enchantment)EnchantmentHandler.CONCCUSION, (ItemStack)this.getItemStack()) : 0;
                if (contusionLevel > 0) {
                    livingentity1.func_195064_c(new EffectInstance(Effects.field_76421_d, 40 * contusionLevel, 5));
                    livingentity1.func_195064_c(new EffectInstance(Effects.field_76431_k, 100 * contusionLevel, 3));
                }
                int fireTime = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_77334_n, (ItemStack)this.getItemStack());
                int n2 = groundedLevel = (Boolean)WeaponThrowConfig.COMMON.groundedEdgeEnchant.get() != false ? EnchantmentHelper.func_77506_a((Enchantment)EnchantmentHandler.GROUNDEDEDGE, (ItemStack)this.getItemStack()) : 0;
                if (!(fireTime <= 0 && groundedLevel <= 0 || (nearEntities = this.field_70170_p.func_217357_a(LivingEntity.class, this.func_174813_aQ().func_186662_g(1.0))).isEmpty())) {
                    for (LivingEntity nearEntity : nearEntities) {
                        if (nearEntity.func_70681_au().nextInt(3) == 0) {
                            nearEntity.func_70015_d(fireTime);
                        }
                        nearEntity.func_195064_c(new EffectInstance(Effects.field_76437_t, 80, groundedLevel - 1));
                    }
                }
                if (entity1 instanceof LivingEntity) {
                    EnchantmentHelper.func_151384_a((LivingEntity)livingentity1, (Entity)entity1);
                    EnchantmentHelper.func_151385_b((LivingEntity)((LivingEntity)entity1), (Entity)livingentity1);
                }
                this.func_184548_a(livingentity1);
                if (this.getItemStack().func_77973_b() instanceof BlockItem) {
                    Block blockItem = Block.func_149634_a((Item)this.getItemStack().func_77973_b());
                    if (blockItem instanceof SandBlock) {
                        if (livingentity1.func_70681_au().nextInt(10) == 0) {
                            livingentity1.func_195064_c(new EffectInstance(Effects.field_76440_q, 60, 3));
                        }
                    } else if (blockItem instanceof TorchBlock) {
                        if (livingentity1.func_70681_au().nextInt(5) == 0) {
                            livingentity1.func_70015_d(1);
                        }
                    } else if (blockItem instanceof AnvilBlock) {
                        livingentity1.func_195064_c(new EffectInstance(Effects.field_76431_k, 60, 3));
                        livingentity1.func_195064_c(new EffectInstance(Effects.field_76421_d, 60, 5));
                    }
                } else {
                    Item itemThrowed = this.getItemStack().func_77973_b();
                    if (itemThrowed.equals(Items.field_151072_bj) || itemThrowed.equals(Items.field_151065_br)) {
                        livingentity1.func_70015_d(1);
                    }
                }
            }
        }
        this.func_213317_d(this.func_213322_ci().func_216372_d(-0.01, -0.1, -0.01));
        this.func_184185_a(soundevent, 1.0f, 1.0f);
    }

    protected SoundEvent func_213867_k() {
        return SoundEvents.field_187770_dm;
    }

    public void func_70100_b_(PlayerEntity entityIn) {
        Entity entity = this.func_234616_v_();
        if (entity == null || entity.func_110124_au() == entityIn.func_110124_au() || this.field_184552_b > (Integer)WeaponThrowConfig.COMMON.ticksUntilWeaponLoseOwner.get()) {
            super.func_70100_b_(entityIn);
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.dealtDamage = compound.func_74767_n("DealtDamage");
        if (compound.func_150297_b("Stack", 10)) {
            this.setItemStack(ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l("Stack")));
        }
        this.field_70180_af.func_187227_b(LOYALTY_LEVEL, (Object)((byte)WeaponThrowEntity.getReturnOrLoyaltyEnchantment(this.getItemStack())));
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_218657_a("Stack", (INBT)this.func_184212_Q().func_187225_a(COMPOUND_STACK));
        compound.func_74757_a("DealtDamage", this.dealtDamage);
        if (this.lastState != null) {
            compound.func_218657_a("inBlockState", (INBT)NBTUtil.func_190009_a((BlockState)this.lastState));
        }
    }

    public void func_225516_i_() {
        byte i = (Byte)this.field_70180_af.func_187225_a(LOYALTY_LEVEL);
        if ((this.field_70251_a != AbstractArrowEntity.PickupStatus.ALLOWED || i <= 0) && this.field_184552_b >= (Integer)WeaponThrowConfig.COMMON.despawnTime.get()) {
            this.func_70106_y();
        }
    }

    protected void func_70227_a(RayTraceResult result) {
        WeaponThrowEvent.OnImpact testEvent = new WeaponThrowEvent.OnImpact(this, (PlayerEntity)this.func_234616_v_(), result);
        if (MinecraftForge.EVENT_BUS.post((Event)testEvent)) {
            return;
        }
        RayTraceResult.Type raytraceresult$type = result.func_216346_c();
        if (raytraceresult$type == RayTraceResult.Type.ENTITY) {
            Entity hittedEntity = ((EntityRayTraceResult)result).func_216348_a();
            if (hittedEntity instanceof LivingEntity && this.func_234616_v_() instanceof PlayerEntity) {
                this.doInteractions(() -> ((PlayerEntity)this.func_234616_v_()).func_71059_n(hittedEntity));
            }
            this.func_213868_a((EntityRayTraceResult)result);
        } else if (raytraceresult$type == RayTraceResult.Type.BLOCK) {
            BlockPos stickBlockPos = ((BlockRayTraceResult)result).func_216350_a();
            BlockState state = this.field_70170_p.func_180495_p(stickBlockPos);
            if (!WeaponThrowConfig.COMMON.blackList.get().contains(state.func_177230_c()) && this.shouldDestroy()) {
                boolean canBreak = (Boolean)WeaponThrowConfig.COMMON.canBreakBlocks.get();
                boolean canHarvest = false;
                canHarvest = this.getItemStack().getHarvestLevel(state.getHarvestTool(), null, null) >= state.getHarvestLevel();
                boolean bl = canHarvest = canHarvest && this.getItemStack().func_150997_a(state) > 1.0f && canBreak;
                if (canHarvest && !this.field_70170_p.field_72995_K && this.lastState == null) {
                    this.setDestroyedBlock(stickBlockPos);
                }
            }
            this.func_230299_a_((BlockRayTraceResult)result);
        }
    }

    protected void func_230299_a_(BlockRayTraceResult p_230299_1_) {
        this.lastState = this.field_70170_p.func_180495_p(p_230299_1_.func_216350_a());
        Vector3d vector3d = p_230299_1_.func_216347_e().func_178786_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        this.func_213317_d(vector3d);
        Vector3d vector3d1 = vector3d.func_72432_b().func_186678_a((double)0.05f);
        this.func_226288_n_(this.func_226277_ct_() - vector3d1.field_72450_a, this.func_226278_cu_() - vector3d1.field_72448_b, this.func_226281_cx_() - vector3d1.field_72449_c);
        SoundEvent event = SoundEvents.field_203269_ik;
        if (this.getItemStack().func_77973_b() instanceof BlockItem) {
            Block block = Block.func_149634_a((Item)this.getItemStack().func_77973_b());
            event = block.func_176223_P().func_215695_r().func_185846_f();
        } else {
            event = this.lastState.func_215695_r().func_185846_f();
        }
        this.func_184185_a(event, 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
        this.field_70254_i = true;
        this.field_70249_b = 7;
        this.func_70243_d(false);
        this.func_213872_b((byte)0);
        this.func_213869_a(event);
        this.func_213865_o(false);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_145770_h(double x, double y, double z) {
        return true;
    }

    public ItemStack func_184543_l() {
        return this.getItemStack();
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void doInteractions(Runnable action) {
        ItemStack originalStack = ((PlayerEntity)this.func_234616_v_()).func_184586_b(Hand.MAIN_HAND);
        ((PlayerEntity)this.func_234616_v_()).func_184611_a(Hand.MAIN_HAND, this.getItemStack());
        action.run();
        ((PlayerEntity)this.func_234616_v_()).func_184611_a(Hand.MAIN_HAND, originalStack);
    }

    public static int getReturnOrLoyaltyEnchantment(ItemStack stack) {
        int loyaltyLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_203193_C, (ItemStack)stack);
        int returnLevel = EnchantmentHelper.func_77506_a((Enchantment)EnchantmentHandler.RETURN, (ItemStack)stack);
        return loyaltyLevel > 0 ? loyaltyLevel : returnLevel;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getRotationAnimation(float partialTicks) {
        if (!this.field_70254_i) {
            this.clientSideRotation = (float)(this.counterClockwiseBounce ? 1 : -1) * ((float)this.field_70173_aa + partialTicks) * 50.0f;
        }
        return this.clientSideRotation;
    }
}

