/*
 * Decompiled with CFR 0.152.
 */
package com.dainxt.weaponthrow.capabilities;

import com.dainxt.weaponthrow.config.WeaponThrowConfig;
import com.dainxt.weaponthrow.interfaces.IThrowPower;
import com.dainxt.weaponthrow.packets.CPacketThrow;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public class ThrowProvider
implements IThrowPower,
ICapabilitySerializable<CompoundTag> {
    @CapabilityInject(value=IThrowPower.class)
    public static final Capability<IThrowPower> THROW_POWER = null;
    private LazyOptional<IThrowPower> instance = LazyOptional.of(() -> this);
    public int MAX_CHARGE = -1;
    CPacketThrow.State action = CPacketThrow.State.NONE;
    int chargeTime = -1;
    ItemStack item = ItemStack.f_41583_;

    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
        return THROW_POWER.orEmpty(capability, this.instance);
    }

    public CompoundTag serializeNBT() {
        IThrowPower capability = (IThrowPower)this.instance.orElseThrow(() -> new IllegalArgumentException("LazyOptional cannot be empty!"));
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("ChargeTime", capability.getChargeTime());
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        IThrowPower capability = (IThrowPower)this.instance.orElseThrow(() -> new IllegalArgumentException("LazyOptional cannot be empty!"));
        capability.setChargeTime(nbt.m_128451_("ChargeTime"));
    }

    @Override
    public void setAction(CPacketThrow.State action) {
        this.action = action;
    }

    @Override
    public CPacketThrow.State getAction() {
        return this.action;
    }

    @Override
    public int getChargeTime() {
        return this.chargeTime;
    }

    @Override
    public void startCharging(ItemStack stack, Player user) {
        this.item = stack;
        this.chargeTime = ThrowProvider.getMaximumCharge(user);
    }

    @Override
    public ItemStack getChargingStack() {
        return this.item;
    }

    @Override
    public void resetCharging() {
        this.action = this.action.equals((Object)CPacketThrow.State.DURING) ? CPacketThrow.State.FINISH : this.action;
        this.item = ItemStack.f_41583_;
        this.chargeTime = -1;
    }

    @Override
    public void setChargeTime(int ticks) {
        this.chargeTime = ticks;
    }

    @Override
    public void setMaxChargeTime(int ticks) {
        this.MAX_CHARGE = ticks;
    }

    @Override
    public int getMaxChargeTime() {
        return this.MAX_CHARGE;
    }

    public static int getMaximumCharge(Player player) {
        return Mth.m_14143_((float)(player.m_36333_() * (float)((Integer)WeaponThrowConfig.COMMON.castTimeInTicks.get()).intValue()));
    }
}

