/*
 * Decompiled with CFR 0.152.
 */
package com.dainxt.weaponthrow.packets;

import com.dainxt.weaponthrow.handlers.EventsHandler;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.fmllegacy.network.NetworkEvent;

public class CPacketThrow {
    State action;

    public CPacketThrow(State state) {
        this.action = state;
    }

    public static void encode(CPacketThrow msg, FriendlyByteBuf buf) {
        buf.writeByte((int)msg.action.toByte());
    }

    public static CPacketThrow decode(FriendlyByteBuf buf) {
        return new CPacketThrow(State.fromByte(buf.readByte()));
    }

    public static void handle(CPacketThrow msg, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection().getReceptionSide().isServer()) {
            ctx.get().enqueueWork(() -> EventsHandler.onThrowItem(((NetworkEvent.Context)ctx.get()).getSender(), msg.action));
        }
        ctx.get().setPacketHandled(true);
    }

    public static enum State {
        NONE(0),
        START(1),
        DURING(2),
        FINISH(3);

        private byte index;

        private State(byte i) {
            this.index = i;
        }

        public byte toByte() {
            return this.index;
        }

        public static State fromByte(int index) {
            for (State equipmentslottype : State.values()) {
                if (equipmentslottype.toByte() != index) continue;
                return equipmentslottype;
            }
            return NONE;
        }
    }
}

