/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.wikizoomer;

import com.github.alexthe666.wikizoomer.WikiZoomerMod;
import com.github.alexthe666.wikizoomer.tileentity.TileEntityEntityZoomer;
import com.github.alexthe666.wikizoomer.tileentity.TileEntityItemZoomer;
import com.github.alexthe666.wikizoomer.tileentity.TileEntityZoomerBase;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;

public class BlockZoomer
extends ContainerBlock {
    private static final VoxelShape BASE_SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)5.0, (double)16.0);
    private static final VoxelShape NECK_SHAPE = Block.func_208617_a((double)4.0, (double)5.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    private static final VoxelShape JOINED_SHAPE = VoxelShapes.func_197882_b((VoxelShape)BASE_SHAPE, (VoxelShape)NECK_SHAPE, (IBooleanFunction)IBooleanFunction.field_223244_o_);
    private boolean itemOrEntity = false;

    public BlockZoomer(boolean itemOrEntity) {
        super(Block.Properties.func_200945_a((Material)Material.field_151576_e).harvestLevel(1).func_200947_a(SoundType.field_185852_e).harvestTool(ToolType.PICKAXE).func_200948_a(5.0f, 20.0f).func_200944_c());
        this.setRegistryName("wikizoomer:" + (itemOrEntity ? "item_zoomer" : "entity_zoomer"));
        this.itemOrEntity = itemOrEntity;
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof TileEntityZoomerBase) {
            InventoryHelper.func_180175_a((World)worldIn, (BlockPos)pos, (IInventory)((TileEntityZoomerBase)tileentity));
            worldIn.func_175666_e(pos, (Block)this);
        }
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return JOINED_SHAPE;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (!player.func_225608_bj_()) {
            if (worldIn.func_175625_s(pos) instanceof TileEntityZoomerBase) {
                TileEntityZoomerBase zoomer = (TileEntityZoomerBase)worldIn.func_175625_s(pos);
                if (!zoomer.func_70301_a(0).func_190926_b()) {
                    ItemEntity dropped = new ItemEntity(worldIn, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.0, (double)pos.func_177952_p() + 0.5, zoomer.func_70301_a(0).func_77946_l());
                    worldIn.func_217376_c((Entity)dropped);
                    zoomer.func_174888_l();
                }
                ItemStack heldItem = player.func_184586_b(handIn);
                ItemStack single = heldItem.func_77946_l();
                single.func_190920_e(1);
                if (this.itemOrEntity || single.func_77973_b() == WikiZoomerMod.ENTITY_BINDER_ITEM) {
                    zoomer.func_70299_a(0, single);
                    if (!player.func_184812_l_()) {
                        heldItem.func_190918_g(1);
                    }
                }
                return ActionResultType.SUCCESS;
            }
        } else {
            if (this.itemOrEntity) {
                if (worldIn.field_72995_K) {
                    WikiZoomerMod.PROXY.openItemZoomerGui((TileEntityZoomerBase)worldIn.func_175625_s(pos));
                }
            } else if (worldIn.field_72995_K) {
                WikiZoomerMod.PROXY.openEntityZoomerGui((TileEntityEntityZoomer)worldIn.func_175625_s(pos));
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.SUCCESS;
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return this.itemOrEntity ? new TileEntityItemZoomer() : new TileEntityEntityZoomer();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (this.itemOrEntity) {
            tooltip.add(new TranslationTextComponent("block.wikizoomer.item_zoomer.desc0", new Object[0]).func_211708_a(TextFormatting.GRAY));
            tooltip.add(new TranslationTextComponent("block.wikizoomer.item_zoomer.desc1", new Object[0]).func_211708_a(TextFormatting.GRAY));
        } else {
            tooltip.add(new TranslationTextComponent("block.wikizoomer.entity_zoomer.desc0", new Object[0]).func_211708_a(TextFormatting.GRAY));
            tooltip.add(new TranslationTextComponent("block.wikizoomer.entity_zoomer.desc1", new Object[0]).func_211708_a(TextFormatting.GRAY));
        }
    }
}

