/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.wikizoomer.client;

import com.github.alexthe666.wikizoomer.tileentity.TileEntityEntityZoomer;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.gui.widget.Slider;

@OnlyIn(value=Dist.CLIENT)
public class GuiEntityZoomer
extends Screen {
    private final Slider.ISlider sliderResponder;
    private TileEntityEntityZoomer zoomerBase;
    private boolean greenscreen = false;
    private float sliderValue;
    private float prevSliderValue = this.sliderValue = 100.0f;

    public GuiEntityZoomer(TileEntityEntityZoomer zoomerBase) {
        super((ITextComponent)new TranslationTextComponent("entity_zoomer", new Object[0]));
        this.zoomerBase = zoomerBase;
        this.sliderResponder = slider -> this.setSliderValue(0, (float)slider.sliderValue);
        this.init();
    }

    private void setSliderValue(int i, float sliderValue) {
        this.prevSliderValue = this.sliderValue = (float)Math.round(MathHelper.func_76131_a((float)(sliderValue * 300.0f), (float)1.0f, (float)300.0f));
    }

    public void init() {
        super.init();
        this.buttons.clear();
        int i = this.width / 2;
        int j = (this.height - 166) / 2;
        String exit = I18n.func_135052_a((String)"gui.wikizoomer.close", (Object[])new Object[0]);
        String greenscreen = I18n.func_135052_a((String)"gui.wikizoomer.greenscreen", (Object[])new Object[0]);
        int maxLength = 120;
        this.addButton((Widget)new Slider(i - 60 - 140, j + 180, 120, 20, I18n.func_135052_a((String)"gui.wikizoomer.zoom", (Object[])new Object[0]) + ": ", "%", 1.0, 300.0, 100.0, false, true, p_214132_1_ -> {}, this.sliderResponder){});
        this.addButton((Widget)new Button(i - maxLength / 2, j + 180, maxLength, 20, greenscreen, p_214132_1_ -> {
            this.greenscreen = !this.greenscreen;
        }));
        this.addButton((Widget)new Button(i - maxLength / 2 + 140, j + 180, maxLength, 20, exit, p_214132_1_ -> Minecraft.func_71410_x().func_147108_a(null)));
        ((Widget)this.buttons.get((int)0)).active = true;
        ((Widget)this.buttons.get((int)1)).active = true;
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        if (this.getMinecraft() != null) {
            try {
                if (this.greenscreen) {
                    int integer = 5046016;
                    float brightness = 1.0f;
                    int alpha = 255;
                    float f = (float)(integer >> 16 & 0xFF) / 255.0f;
                    float f1 = (float)(integer >> 8 & 0xFF) / 255.0f;
                    float f2 = (float)(integer & 0xFF) / 255.0f;
                    GuiEntityZoomer.fill((int)0, (int)0, (int)this.width, (int)this.height, (int)(MathHelper.func_180183_b((float)(f * brightness), (float)(f1 * brightness), (float)(f2 * brightness)) | alpha << 24));
                } else {
                    this.renderBackground();
                }
            }
            catch (Exception integer) {
                // empty catch block
            }
        }
        super.render(mouseX, mouseY, partialTicks);
        int i = (this.width - 248) / 2 + 10;
        int j = (this.height - 166) / 2 + 8;
        GlStateManager.func_227626_N_();
        GlStateManager.func_227688_c_((float)0.0f, (float)0.0f, (float)10.0f);
        GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Entity renderEntity = this.zoomerBase.getCachedEntity();
        float scale1 = this.sliderValue / 100.0f;
        GlStateManager.func_227688_c_((float)i, (float)j, (float)10.0f);
        float scale = scale1 * 100.0f;
        if (renderEntity != null) {
            float f = 0.75f;
            float f1 = Math.max(renderEntity.func_213311_cf(), renderEntity.func_213302_cg());
            if ((double)f1 > 1.0) {
                f /= f1;
            }
            if (renderEntity instanceof LivingEntity) {
                GuiEntityZoomer.drawEntityOnScreen(115, 130, f * scale, 0.0f, 0.0f, (LivingEntity)renderEntity);
            }
        }
        GlStateManager.func_227627_O_();
    }

    public static void drawEntityOnScreen(int x, int y, float scale, float yaw, float pitch, LivingEntity entity) {
        float f = (float)Math.atan(yaw / 40.0f);
        float f1 = (float)Math.atan(pitch / 40.0f);
        float rotate = 135.0f;
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)x, (float)y, (float)(1050.0f + scale));
        RenderSystem.scalef((float)1.0f, (float)1.0f, (float)-1.0f);
        MatrixStack matrixstack = new MatrixStack();
        matrixstack.func_227861_a_(0.0, 0.0, 1000.0);
        matrixstack.func_227862_a_(scale, scale, scale);
        Quaternion quaternion = Vector3f.field_229183_f_.func_229187_a_(180.0f);
        Quaternion quaternion1 = Vector3f.field_229179_b_.func_229187_a_(-30.0f);
        Quaternion quaternion2 = Vector3f.field_229181_d_.func_229187_a_(rotate);
        quaternion.func_195890_a(quaternion1);
        matrixstack.func_227863_a_(quaternion);
        matrixstack.func_227863_a_(quaternion2);
        EntityRendererManager entityrenderermanager = Minecraft.func_71410_x().func_175598_ae();
        quaternion1.func_195892_e();
        entityrenderermanager.func_229089_a_(quaternion1);
        entityrenderermanager.func_178633_a(false);
        IRenderTypeBuffer.Impl irendertypebuffer$impl = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        entityrenderermanager.func_229084_a_((Entity)entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, matrixstack, (IRenderTypeBuffer)irendertypebuffer$impl, 0xF000F0);
        irendertypebuffer$impl.func_228461_a_();
        entityrenderermanager.func_178633_a(true);
        RenderSystem.popMatrix();
    }

    public boolean isPauseScreen() {
        return false;
    }
}

