/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.wikizoomer.client;

import com.github.alexthe666.wikizoomer.tileentity.TileEntityZoomerBase;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.gui.widget.Slider;

@OnlyIn(value=Dist.CLIENT)
public class GuiItemZoomer
extends Screen {
    private final Slider.ISlider sliderResponder;
    private TileEntityZoomerBase zoomerBase;
    private boolean greenscreen = false;
    private float sliderValue;
    private float prevSliderValue = this.sliderValue = 100.0f;

    public GuiItemZoomer(TileEntityZoomerBase zoomerBase) {
        super((ITextComponent)new TranslationTextComponent("item_zoomer", new Object[0]));
        this.zoomerBase = zoomerBase;
        this.sliderResponder = slider -> this.setSliderValue(0, (float)slider.sliderValue);
        this.init();
    }

    private void setSliderValue(int i, float sliderValue) {
        this.prevSliderValue = this.sliderValue = (float)Math.round(MathHelper.func_76131_a((float)(sliderValue * 300.0f), (float)1.0f, (float)300.0f));
    }

    public void init() {
        super.init();
        this.buttons.clear();
        int i = this.width / 2;
        int j = (this.height - 166) / 2;
        String exit = I18n.func_135052_a((String)"gui.wikizoomer.close", (Object[])new Object[0]);
        String greenscreen = I18n.func_135052_a((String)"gui.wikizoomer.greenscreen", (Object[])new Object[0]);
        int maxLength = 120;
        this.addButton((Widget)new Slider(i - 60 - 140, j + 180, 120, 20, I18n.func_135052_a((String)"gui.wikizoomer.zoom", (Object[])new Object[0]) + ": ", "%", 1.0, 300.0, 100.0, false, true, p_214132_1_ -> {}, this.sliderResponder){});
        this.addButton((Widget)new Button(i - maxLength / 2, j + 180, maxLength, 20, greenscreen, p_214132_1_ -> {
            this.greenscreen = !this.greenscreen;
        }));
        this.addButton((Widget)new Button(i - maxLength / 2 + 140, j + 180, maxLength, 20, exit, p_214132_1_ -> Minecraft.func_71410_x().func_147108_a(null)));
        ((Widget)this.buttons.get((int)0)).active = true;
        ((Widget)this.buttons.get((int)1)).active = true;
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        if (this.getMinecraft() != null) {
            try {
                if (this.greenscreen) {
                    int integer = 5046016;
                    float brightness = 1.0f;
                    int alpha = 255;
                    float f = (float)(integer >> 16 & 0xFF) / 255.0f;
                    float f1 = (float)(integer >> 8 & 0xFF) / 255.0f;
                    float f2 = (float)(integer & 0xFF) / 255.0f;
                    GuiItemZoomer.fill((int)0, (int)0, (int)this.width, (int)this.height, (int)(MathHelper.func_180183_b((float)(f * brightness), (float)(f1 * brightness), (float)(f2 * brightness)) | alpha << 24));
                } else {
                    this.renderBackground();
                }
            }
            catch (Exception integer) {
                // empty catch block
            }
        }
        super.render(mouseX, mouseY, partialTicks);
        int i = (this.width - 248) / 2 + 10;
        int j = (this.height - 166) / 2 + 8;
        GlStateManager.func_227626_N_();
        GlStateManager.func_227688_c_((float)0.0f, (float)0.0f, (float)10.0f);
        GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ItemStack stack = this.zoomerBase.func_70301_a(0);
        float scale1 = this.sliderValue / 100.0f;
        GlStateManager.func_227688_c_((float)i, (float)j, (float)10.0f);
        float scale = scale1 * 12.0f;
        if (!stack.func_190926_b()) {
            GlStateManager.func_227688_c_((float)(113.5f - scale1 * 100.0f), (float)(76.0f - scale1 * 100.0f), (float)(-10.0f - this.sliderValue * 10.0f));
            GlStateManager.func_227672_b_((float)scale, (float)scale, (float)scale);
            RenderSystem.enableRescaleNormal();
            Minecraft.func_71410_x().func_175599_af().func_175042_a(stack, 0, 0);
            RenderSystem.disableRescaleNormal();
        }
        GlStateManager.func_227627_O_();
    }

    public boolean isPauseScreen() {
        return false;
    }
}

