/*
 * Decompiled with CFR 0.152.
 */
package wraith.smithee;

import com.google.gson.JsonObject;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import wraith.smithee.Config;
import wraith.smithee.recipes.RecipesGenerator;
import wraith.smithee.registry.BlockEntityRegistry;
import wraith.smithee.registry.BlockRegistry;
import wraith.smithee.registry.ItemRegistry;
import wraith.smithee.registry.ScreenHandlerRegistry;
import wraith.smithee.registry.StatusEffectRegistry;
import wraith.smithee.screens.AssemblyTableScreenHandler;
import wraith.smithee.utils.JsonParser;
import wraith.smithee.utils.Utils;

public class Smithee
implements ModInitializer {
    public static final String MOD_ID = "smithee";
    public static final Logger LOGGER = LogManager.getLogger();
    public static boolean DISABLE_TOOLS = false;

    public void onInitialize() {
        LOGGER.info("[Smithee] is loading.");
        JsonObject json = Config.loadConfig();
        if (json.has("disable_vanilla_tools") && json.get("disable_vanilla_tools").getAsBoolean()) {
            DISABLE_TOOLS = true;
            ItemRegistry.setDisabledItems();
        }
        Config.createMaterials(json.has("replace_material_list_when_regenerating") && json.get("replace_material_list_when_regenerating").getAsBoolean());
        Utils.saveFilesFromJar("configs/templates", "templates", true);
        if (!json.has("regenerate_deleted_palettes") || json.get("regenerate_deleted_palettes").getAsBoolean()) {
            Utils.saveFilesFromJar("configs/palettes", "palettes", json.has("replace_old_palettes_when_regenerating") && json.get("replace_old_palettes_when_regenerating").getAsBoolean());
        }
        if (!json.has("regenerate_deleted_texture_files") || json.get("regenerate_deleted_texture_files").getAsBoolean()) {
            Utils.saveFilesFromJar("configs/textures", "textures", json.has("replace_old_texture_files_when_regenerating") && json.get("replace_old_texture_files_when_regenerating").getAsBoolean());
        }
        if (!json.has("regenerate_deleted_shard_files") || json.get("regenerate_deleted_shard_files").getAsBoolean()) {
            Utils.saveFilesFromJar("configs/shards", "shards", json.has("replace_old_shard_files_when_regenerating") && json.get("replace_old_shard_files_when_regenerating").getAsBoolean());
        }
        ItemRegistry.generateShards();
        ItemRegistry.addMaterials();
        if (!json.has("regenerate_deleted_stat_files") || json.get("regenerate_deleted_stat_files").getAsBoolean()) {
            Utils.saveFilesFromJar("configs/stats", "stats", json.has("replace_old_stat_files_when_regenerating") && json.get("replace_old_stat_files_when_regenerating").getAsBoolean());
        }
        if (!json.has("regenerate_deleted_chisel_files") || json.get("regenerate_deleted_chisel_files").getAsBoolean()) {
            Utils.saveFilesFromJar("configs/chisels", "chisels", json.has("replace_old_chisel_files_when_regenerating") && json.get("replace_old_chisel_files_when_regenerating").getAsBoolean());
        }
        ItemRegistry.generateChiselingStats();
        ItemRegistry.generateProperties();
        ItemRegistry.generateModifiers();
        ItemRegistry.addItems();
        ItemRegistry.registerItems();
        BlockRegistry.registerBlocks();
        BlockEntityRegistry.addBlockEntities();
        BlockEntityRegistry.registerBlockEntities();
        ScreenHandlerRegistry.registerScreenHandlers();
        StatusEffectRegistry.registerStatusEffects();
        if (!json.has("regenerate_deleted_recipe_files") || json.get("regenerate_deleted_recipe_files").getAsBoolean()) {
            Utils.saveFilesFromJar("configs/recipes", "recipes", json.has("replace_old_recipe_files_when_regenerating") && json.get("replace_old_recipe_files_when_regenerating").getAsBoolean());
        }
        if (!json.has("regenerate_deleted_modifier_files") || json.get("regenerate_deleted_modifier_files").getAsBoolean()) {
            Utils.saveFilesFromJar("configs/modifiers", "modifiers", json.has("replace_old_modifier_files_when_regenerating") && json.get("replace_old_modifier_files_when_regenerating").getAsBoolean());
        }
        if (!json.has("regenerate_deleted_smithing_files") || json.get("regenerate_deleted_smithing_files").getAsBoolean()) {
            Utils.saveFilesFromJar("configs/smithing", "smithing", json.has("replace_old_smithing_files_when_regenerating") && json.get("replace_old_smithing_files_when_regenerating").getAsBoolean());
        }
        if (!json.has("regenerate_deleted_combination_files") || json.get("regenerate_deleted_combination_files").getAsBoolean()) {
            Utils.saveFilesFromJar("configs/combinations", "combinations", json.has("replace_old_combination_files_when_regenerating") && json.get("replace_old_combination_files_when_regenerating").getAsBoolean());
        }
        JsonParser.parseCombinations();
        RecipesGenerator.generateRecipes();
        this.registerPacketHandlers();
        this.registerEvents();
        LOGGER.info("[Smithee] has successfully been loaded.");
    }

    private void registerPacketHandlers() {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)new class_2960(MOD_ID, "rename_tool_assembly"), (server, player, networkHandler, packet, sender) -> {
            class_2487 tag = packet.method_10798();
            if (player.field_7512 instanceof AssemblyTableScreenHandler) {
                ((AssemblyTableScreenHandler)player.field_7512).setName(tag.method_10558("ToolName"));
            }
        });
    }

    private void registerEvents() {
        ServerWorldEvents.LOAD.register((server, world) -> ItemRegistry.generateRecipes());
    }
}

