/*
 * Decompiled with CFR 0.152.
 */
package wraith.smithee;

import java.util.HashMap;
import java.util.HashSet;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.model.ModelLoadingRegistry;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import wraith.smithee.ItemModelProvider;
import wraith.smithee.Smithee;
import wraith.smithee.registry.ItemRegistry;
import wraith.smithee.registry.ScreenRegistry;
import wraith.smithee.utils.Utils;

public class SmitheeClient
implements ClientModInitializer {
    public static final HashSet<String> RENDERING_TOOL_PARTS = new HashSet();

    public void onInitializeClient() {
        ScreenRegistry.registerScreens();
        ModelLoadingRegistry.INSTANCE.registerAppender((manager, out) -> {
            for (String material : ItemRegistry.MATERIALS) {
                for (String tool : ItemRegistry.TOOL_TYPES) {
                    String id = material + "_" + tool + "_head";
                    RENDERING_TOOL_PARTS.add(id);
                    out.accept(Utils.inventoryModelID(id));
                    id = material + "_" + tool + "_binding";
                    RENDERING_TOOL_PARTS.add(id);
                    out.accept(Utils.inventoryModelID(id));
                    id = material + "_" + tool + "_handle";
                    RENDERING_TOOL_PARTS.add(id);
                    out.accept(Utils.inventoryModelID(id));
                }
            }
        });
        ModelLoadingRegistry.INSTANCE.registerVariantProvider(rm -> new ItemModelProvider());
        this.registerPacketHandlers();
    }

    private void registerPacketHandlers() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)Utils.ID("connect_packet"), (client, networkHandler, data, sender) -> {
            if (class_310.method_1551().method_1542()) {
                return;
            }
            class_2487 tag = data.method_10798();
            ItemRegistry.DISABLED_ITEMS.clear();
            Smithee.DISABLE_TOOLS = tag.method_10577("disable_tools");
            if (Smithee.DISABLE_TOOLS) {
                ItemRegistry.setDisabledItems();
            }
            class_2487 subtag = tag.method_10562("shards");
            String[] contents = new String[subtag.method_10546()];
            int i = 0;
            for (String name : subtag.method_10541()) {
                contents[i] = subtag.method_10558(name);
                ++i;
            }
            ItemRegistry.generateShards(contents);
            ItemRegistry.addMaterials(tag.method_10558("materials"), tag.method_10558("emboss_materials"));
            i = 0;
            subtag = tag.method_10562("chisels");
            contents = new String[subtag.method_10546()];
            for (String name : subtag.method_10541()) {
                contents[i] = subtag.method_10558(name);
                ++i;
            }
            ItemRegistry.generateChiselingStats(contents);
            subtag = tag.method_10562("stats");
            HashMap<String, String> contentsMap = new HashMap<String, String>();
            for (String name : subtag.method_10541()) {
                contentsMap.put(name, subtag.method_10558(name));
            }
            ItemRegistry.generateProperties(contentsMap);
            subtag = tag.method_10562("modifiers");
            contents = new String[subtag.method_10546()];
            i = 0;
            for (String name : subtag.method_10541()) {
                contents[i] = subtag.method_10558(name);
                ++i;
            }
            ItemRegistry.generateModifiers(contents);
            subtag = tag.method_10562("recipes");
            contents = new String[subtag.method_10546()];
            i = 0;
            for (String name : subtag.method_10541()) {
                contents[i] = subtag.method_10558(name);
                ++i;
            }
            ItemRegistry.generateRecipes(contents);
        });
    }
}

