/*
 * Decompiled with CFR 0.152.
 */
package wraith.smithee.items.tools;

import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;

public interface BaseSmitheeTool {
    public static long getLevel(long experience) {
        long xp = 100L;
        long level = 0L;
        while (xp < experience) {
            xp = (long)((double)xp + BaseSmitheeTool.calculateXp(xp, level));
            ++level;
        }
        return level;
    }

    public static double calculateXp(long xp, long level) {
        return level < 15L ? Math.pow(Math.pow(xp, 0.3) * 3.0, 2.0) + 100.0 : (double)(xp * 15L);
    }

    public static long getNeededExperience(long level) {
        long xp = 100L;
        for (long lvl = 0L; lvl < level; ++lvl) {
            xp = (long)((double)xp + BaseSmitheeTool.calculateXp(xp, lvl));
        }
        return xp;
    }

    public static String getProgressString(long experience, long level) {
        long xp = BaseSmitheeTool.getNeededExperience(level);
        double collected = (double)experience / (double)xp;
        String filled = "";
        int i = 0;
        while ((double)i < collected * 10.0) {
            filled = filled + "\u2593";
            ++i;
        }
        String nonfilled = "";
        int i2 = 0;
        while ((double)i2 < 10.0 - collected * 10.0) {
            nonfilled = nonfilled + "\u2593";
            ++i2;
        }
        return "\u00a71[\u00a7b" + filled + "\u00a73" + nonfilled + "\u00a71]";
    }

    default public class_1271<class_1799> boostXp(class_1937 world, class_1657 user, class_1268 hand) {
        long curLevel;
        class_1799 stack = user.method_5998(hand);
        if (!user.method_5715()) {
            return class_1271.method_22430((Object)stack);
        }
        class_2487 tag = stack.method_7941("SmitheeProperties");
        if (tag == null) {
            return class_1271.method_22431((Object)stack);
        }
        if (!tag.method_10545("Experience")) {
            tag.method_10569("Experience", 0);
        }
        if (!tag.method_10545("Level")) {
            tag.method_10569("Level", 0);
        }
        if ((curLevel = tag.method_10537("Level")) >= 28L) {
            return class_1271.method_22431((Object)stack);
        }
        long vanillaxp = user.field_7495;
        for (long lvl = 0L; lvl < (long)user.field_7520; ++lvl) {
            vanillaxp += BaseSmitheeTool.getVanillaExperienceRequirement(lvl);
        }
        long xp = tag.method_10537("Experience");
        long fraction = vanillaxp;
        if (vanillaxp >= 100L) {
            fraction = vanillaxp / 5L;
        }
        user.method_7255((int)(-fraction));
        tag.method_10544("Experience", xp += fraction);
        tag.method_10544("Level", BaseSmitheeTool.getLevel(xp));
        if (tag.method_10537("Level") != curLevel) {
            class_2487 modifiers = tag.method_10562("Modifiers");
            int diff = (int)(tag.method_10537("Level") - curLevel);
            modifiers.method_10569("EnchantmentSlots", modifiers.method_10550("EnchantmentSlots") + diff);
            tag.method_10566("Modifiers", (class_2520)modifiers);
        }
        return class_1271.method_29237((Object)stack, (boolean)world.method_8608());
    }

    public static long getVanillaExperienceRequirement(long level) {
        if (level >= 30L) {
            return 112L + (level - 30L) * 9L;
        }
        return level >= 15L ? 37L + (level - 15L) * 5L : 7L + level * 2L;
    }
}

