/*
 * Decompiled with CFR 0.152.
 */
package wraith.smithee.mixin;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1743;
import net.minecraft.class_1766;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1810;
import net.minecraft.class_1829;
import net.minecraft.class_1836;
import net.minecraft.class_1887;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2680;
import net.minecraft.class_3614;
import net.minecraft.class_437;
import net.minecraft.class_5134;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import wraith.smithee.items.Chisel;
import wraith.smithee.items.tool_parts.ToolPartItem;
import wraith.smithee.items.tools.BaseSmitheePickaxe;
import wraith.smithee.items.tools.BaseSmitheeSword;
import wraith.smithee.items.tools.BaseSmitheeTool;
import wraith.smithee.mixin.AxeItemAccessor;
import wraith.smithee.mixin.ItemAccessor;
import wraith.smithee.mixin.MiningToolItemAccessor;
import wraith.smithee.properties.Modifier;
import wraith.smithee.properties.Properties;
import wraith.smithee.properties.ToolPartRecipe;
import wraith.smithee.properties.Trait;
import wraith.smithee.registry.ItemRegistry;
import wraith.smithee.utils.Utils;

@Mixin(value={class_1799.class})
public abstract class ItemStackMixin {
    @Shadow
    private class_2487 field_8040;

    @Shadow
    public abstract class_1792 method_7909();

    @Shadow
    @Nullable
    public abstract class_2487 method_7941(String var1);

    @Shadow
    public abstract boolean method_7985();

    @Shadow
    public abstract int method_7947();

    @Inject(method={"getMaxDamage"}, at={@At(value="HEAD")}, cancellable=true)
    public void getMaxDamage(CallbackInfoReturnable<Integer> cir) {
        if (this.method_7909() instanceof BaseSmitheeTool && this.field_8040 != null && this.field_8040.method_10545("SmitheeProperties")) {
            class_2487 tag = this.method_7941("SmitheeProperties");
            cir.setReturnValue((Object)tag.method_10550("Durability"));
            cir.cancel();
        }
    }

    @Inject(method={"isEnchantable"}, at={@At(value="HEAD")}, cancellable=true)
    public void isEnchantable(CallbackInfoReturnable<Boolean> cir) {
        if (this.method_7909() instanceof BaseSmitheeTool) {
            cir.setReturnValue((Object)false);
            cir.cancel();
        }
    }

    @Inject(method={"hasEnchantments"}, at={@At(value="HEAD")}, cancellable=true)
    public void hasEnchantments(CallbackInfoReturnable<Boolean> cir) {
        if (this.method_7909() instanceof BaseSmitheeTool) {
            cir.setReturnValue((Object)false);
            cir.cancel();
        }
    }

    @Inject(method={"addEnchantment"}, at={@At(value="HEAD")}, cancellable=true)
    public void addEnchantment(class_1887 enchantment, int level, CallbackInfo ci) {
        if (this.method_7909() instanceof BaseSmitheeTool) {
            ci.cancel();
        }
    }

    @Inject(method={"getMiningSpeedMultiplier"}, at={@At(value="HEAD")}, cancellable=true)
    public void getMiningSpeedMultiplier(class_2680 state, CallbackInfoReturnable<Float> cir) {
        if (this.method_7909() instanceof BaseSmitheeTool && !(this.method_7909() instanceof BaseSmitheeSword) && this.field_8040 != null && this.field_8040.method_10545("SmitheeProperties")) {
            float mineSpeed;
            class_2487 tag = this.method_7941("SmitheeProperties");
            float f = mineSpeed = ((MiningToolItemAccessor)this.method_7909()).getEffectiveBlocks().contains(state.method_26204()) ? tag.method_10583("MiningSpeed") : 1.0f;
            if (this.method_7909() instanceof class_1810) {
                class_3614 material = state.method_26207();
                mineSpeed = material != class_3614.field_15953 && material != class_3614.field_15949 && material != class_3614.field_15914 ? mineSpeed : tag.method_10583("MiningSpeed");
            } else if (this.method_7909() instanceof class_1743) {
                mineSpeed = ((AxeItemAccessor)this.method_7909()).getEffectiveMaterials().contains(state.method_26207()) ? tag.method_10583("MiningSpeed") : mineSpeed;
            } else if (this.method_7909() instanceof class_1829) {
                mineSpeed = this.method_7909().method_7856(state) ? tag.method_10583("MiningSpeed") : mineSpeed;
            }
            cir.setReturnValue((Object)Float.valueOf(mineSpeed));
            cir.cancel();
        }
    }

    @Inject(method={"isEffectiveOn"}, at={@At(value="HEAD")}, cancellable=true)
    public void isEffectiveOn(class_2680 state, CallbackInfoReturnable<Boolean> cir) {
        if (this.method_7909() instanceof BaseSmitheeTool) {
            if (this.method_7909() instanceof BaseSmitheePickaxe && this.field_8040 != null && this.field_8040.method_10545("SmitheeProperties")) {
                class_2487 tag = this.method_7941("SmitheeProperties");
                int mineLevel = tag.method_10550("MiningLevel");
                if (!(state.method_27852(class_2246.field_10540) || state.method_27852(class_2246.field_22423) || state.method_27852(class_2246.field_22108) || state.method_27852(class_2246.field_23152) || state.method_27852(class_2246.field_22109))) {
                    if (!(state.method_27852(class_2246.field_10201) || state.method_27852(class_2246.field_10442) || state.method_27852(class_2246.field_10013) || state.method_27852(class_2246.field_10234) || state.method_27852(class_2246.field_10205) || state.method_27852(class_2246.field_10571) || state.method_27852(class_2246.field_10080))) {
                        if (!(state.method_27852(class_2246.field_10085) || state.method_27852(class_2246.field_10212) || state.method_27852(class_2246.field_10441) || state.method_27852(class_2246.field_10090))) {
                            class_3614 material = state.method_26207();
                            cir.setReturnValue((Object)(material == class_3614.field_15914 || material == class_3614.field_15953 || material == class_3614.field_15949 || state.method_27852(class_2246.field_23077) ? 1 : 0));
                        } else {
                            cir.setReturnValue((Object)(mineLevel >= 1 ? 1 : 0));
                        }
                    } else {
                        cir.setReturnValue((Object)(mineLevel >= 2 ? 1 : 0));
                    }
                } else {
                    cir.setReturnValue((Object)(mineLevel >= 3 ? 1 : 0));
                }
                cir.cancel();
            } else if (this.method_7909() instanceof class_1766) {
                cir.setReturnValue((Object)((MiningToolItemAccessor)this.method_7909()).getEffectiveBlocks().contains(state.method_26204()));
                cir.cancel();
            }
        }
    }

    @Inject(method={"getAttributeModifiers"}, at={@At(value="HEAD")}, cancellable=true)
    public void getAttributeModifiers(class_1304 equipmentSlot, CallbackInfoReturnable<Multimap<class_1320, class_1322>> cir) {
        if (this.method_7909() instanceof BaseSmitheeTool && this.field_8040 != null && this.field_8040.method_10545("SmitheeProperties") && equipmentSlot == class_1304.field_6173) {
            class_2487 tag = this.method_7941("SmitheeProperties");
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            builder.put((Object)class_5134.field_23721, (Object)new class_1322(((ItemAccessor)this.method_7909()).getAttackDamageModifierId(), this.method_7909() instanceof BaseSmitheeSword ? "Tool modifier" : "Weapon modifier", (double)(tag.method_10583("AttackDamage") + Properties.getExtraDamage(Utils.getToolType(this.method_7909()))), class_1322.class_1323.field_6328));
            builder.put((Object)class_5134.field_23723, (Object)new class_1322(((ItemAccessor)this.method_7909()).getAttackSpeedModifierId(), this.method_7909() instanceof BaseSmitheeSword ? "Tool modifier" : "Weapon modifier", (double)(-4.0f + tag.method_10583("AttackSpeed") + Properties.getExtraAttackSpeed(Utils.getToolType(this.method_7909()))), class_1322.class_1323.field_6328));
            cir.setReturnValue((Object)builder.build());
            cir.cancel();
        }
    }

    @Inject(method={"hasCustomName"}, at={@At(value="HEAD")}, cancellable=true)
    public void hasCustomName(CallbackInfoReturnable<Boolean> cir) {
        if (this.method_7909() instanceof BaseSmitheeTool || this.method_7909() instanceof Chisel || class_2378.field_11142.method_10221((Object)this.method_7909()).method_12832().endsWith("_embossment")) {
            cir.setReturnValue((Object)false);
            cir.cancel();
        }
    }

    @Inject(method={"getName"}, at={@At(value="HEAD")}, cancellable=true)
    public void getName(CallbackInfoReturnable<class_2561> cir) {
        boolean isSmithee = class_2378.field_11142.method_10221((Object)this.method_7909()).method_12836().equals("smithee");
        if (this.method_7909() instanceof BaseSmitheeTool) {
            if (this.field_8040 != null && this.field_8040.method_10545("SmitheeProperties") && this.field_8040.method_10562("SmitheeProperties").method_10545("CustomName")) {
                cir.setReturnValue((Object)new class_2585(this.field_8040.method_10562("SmitheeProperties").method_10558("CustomName")));
            } else if (this.field_8040 != null && this.field_8040.method_10545("Parts")) {
                cir.setReturnValue((Object)new class_2585(Utils.capitalize(this.field_8040.method_10562("Parts").method_10558("HeadPart").split("_")) + " " + Utils.capitalize(Utils.getToolType(this.method_7909()))));
            } else {
                cir.setReturnValue((Object)new class_2585("Base Smithee " + Utils.capitalize(Utils.getToolType(this.method_7909()))));
            }
        } else if (this.method_7909() instanceof ToolPartItem) {
            ToolPartItem part = (ToolPartItem)this.method_7909();
            cir.setReturnValue((Object)new class_2585(part.toString()));
        } else if (this.method_7909() instanceof Chisel || isSmithee && (class_2378.field_11142.method_10221((Object)this.method_7909()).method_12832().endsWith("_embossment") || class_2378.field_11142.method_10221((Object)this.method_7909()).method_12832().endsWith("_shard"))) {
            cir.setReturnValue((Object)new class_2585(Utils.capitalize(class_2378.field_11142.method_10221((Object)this.method_7909()).method_12832().split("/")[0].split("_"))));
        }
    }

    @ModifyVariable(method={"getTooltip"}, at=@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;isSectionHidden(ILnet/minecraft/item/ItemStack$TooltipSection;)Z", ordinal=3))
    @Environment(value=EnvType.CLIENT)
    public List<class_2561> getTooltip(List<class_2561> list, class_1657 player, class_1836 context) {
        if (ItemRegistry.TOOL_PART_RECIPES.containsKey(this.method_7909()) && ItemRegistry.TOOL_PART_RECIPES.get(this.method_7909()).containsKey("pickaxe_head")) {
            list.add((class_2561)new class_2585("\u00a71[\u00a75Tool material\u00a71]"));
            if (class_437.method_25442() && ItemRegistry.REMAINS.containsKey(ItemRegistry.TOOL_PART_RECIPES.get((Object)this.method_7909()).get((Object)"pickaxe_head").outputMaterial)) {
                HashMap<String, ToolPartRecipe> recipes = ItemRegistry.TOOL_PART_RECIPES.get(this.method_7909());
                int worth = ItemRegistry.REMAINS.get(recipes.get((Object)"pickaxe_head").outputMaterial).get(class_2378.field_11142.method_10221((Object)this.method_7909()));
                list.add((class_2561)new class_2585("\u00a79[\u00a7dIndividual Worth: \u00a7b" + worth + "\u00a7d]"));
                list.add((class_2561)new class_2585("\u00a79[\u00a7dTotal Worth: \u00a7b" + worth * this.method_7947() + "\u00a7d]"));
            } else {
                list.add((class_2561)new class_2585("\u00a73[\u00a7bSHIFT\u00a73] for info."));
            }
        }
        if (this.method_7909() instanceof BaseSmitheeTool) {
            HashSet<class_2561> modifiers;
            HashSet<class_2561> traits;
            class_2487 tag = this.method_7941("SmitheeProperties");
            if (tag != null && tag.method_10545("Experience")) {
                list.add((class_2561)new class_2585("\u00a72Level \u00a7a" + tag.method_10537("Level") + "."));
                list.add((class_2561)new class_2585("\u00a75Progress " + BaseSmitheeTool.getProgressString(tag.method_10537("Experience"), tag.method_10537("Level"))));
            }
            if (!(traits = Trait.getTooltip((class_1799)this)).isEmpty()) {
                list.add((class_2561)new class_2585(""));
                list.addAll(traits);
            }
            if (!(modifiers = Modifier.getTooltip((class_1799)this)).isEmpty()) {
                list.add((class_2561)new class_2585(""));
                list.addAll(modifiers);
            }
        }
        if (this.method_7909() instanceof Chisel) {
            Chisel chisel = (Chisel)this.method_7909();
            list.add((class_2561)new class_2585("\u00a79[\u00a7dChisel Level: \u00a7b" + chisel.getChiselingLevel() + "\u00a7d]"));
        }
        return list;
    }

    @Inject(method={"inventoryTick"}, at={@At(value="HEAD")})
    public void inventoryTick(class_1937 world, class_1297 entity, int slot, boolean selected, CallbackInfo ci) {
        Trait.evaluateTraits((class_1799)this, world, null, null, null, entity, "ItemStack#inventoryTick");
    }

    @Inject(method={"damage(ILnet/minecraft/entity/LivingEntity;Ljava/util/function/Consumer;)V"}, at={@At(value="HEAD")}, cancellable=true)
    public <T extends class_1309> void damage(int amount, T entity, Consumer<T> breakCallback, CallbackInfo ci) {
        HashMap<String, Object> result = Trait.evaluateTraits((class_1799)this, null, null, null, null, null, "ItemStack#damage");
        if (result.containsKey("Cancel Item Damage") && ((Boolean)result.get("Cancel Item Damage")).booleanValue()) {
            ci.cancel();
        }
    }
}

