/*
 * Decompiled with CFR 0.152.
 */
package wraith.smithee.mixin;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import net.minecraft.class_2960;
import net.minecraft.class_3294;
import net.minecraft.class_3298;
import net.minecraft.class_3306;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import wraith.smithee.SmitheeClient;
import wraith.smithee.registry.ItemRegistry;
import wraith.smithee.utils.Utils;

@Mixin(value={class_3294.class})
public class NamespaceResourceManagerMixin {
    @Inject(method={"getResource(Lnet/minecraft/util/Identifier;)Lnet/minecraft/resource/Resource;"}, at={@At(value="HEAD")}, cancellable=true)
    public void getResource(class_2960 id, CallbackInfoReturnable<class_3298> cir) {
        int i;
        String[] segments = id.method_12832().split("/");
        String path = segments[segments.length - 1];
        if (!id.method_12836().equals("smithee") || !path.endsWith(".png")) {
            return;
        }
        String pathWithoutExtension = path.split("\\.")[0];
        segments = pathWithoutExtension.split("_");
        int maxI = Utils.getMaterialFromPathIndex(pathWithoutExtension);
        if (maxI >= segments.length) {
            return;
        }
        String material = "";
        for (i = 0; i < maxI; ++i) {
            if (i > 0) {
                material = material + "_";
            }
            material = material + segments[i];
        }
        String part = "";
        while (i < segments.length) {
            part = part + "_" + segments[i];
            ++i;
        }
        part = part.substring(1);
        if (!((ItemRegistry.MATERIALS.contains(material) || ItemRegistry.EMBOSS_MATERIALS.contains(material)) && (ItemRegistry.BASE_RECIPE_VALUES.containsKey(part) || SmitheeClient.RENDERING_TOOL_PARTS.contains(pathWithoutExtension) || "embossment".equals(part) || "chisel".equals(part) || "shard".equals(part)))) {
            return;
        }
        File texture = new File("config/smithee/textures/" + path);
        File metadata = new File("config/smithee/textures/" + path + ".mcmeta");
        if (texture.exists()) {
            try {
                cir.setReturnValue((Object)new class_3306("smithee", id, (InputStream)new FileInputStream(texture), (InputStream)(metadata.exists() ? new FileInputStream(metadata) : null)));
                cir.cancel();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        } else {
            File templatePalette = new File("config/smithee/templates/template_palette.png");
            File palette = new File("config/smithee/palettes/" + material + ".png");
            File template = new File("config/smithee/templates/" + part + ".png");
            cir.setReturnValue((Object)new class_3306("smithee", id, Utils.recolor(template, templatePalette, palette, pathWithoutExtension), null));
            cir.cancel();
        }
    }
}

