/*
 * Decompiled with CFR 0.152.
 */
package wraith.smithee.properties;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2585;
import wraith.smithee.items.tools.BaseSmitheeTool;
import wraith.smithee.mixin.TextColorInvoker;
import wraith.smithee.recipes.EmbossModifiers;
import wraith.smithee.recipes.EmbossRecipe;
import wraith.smithee.registry.ItemRegistry;
import wraith.smithee.utils.Utils;

public class Modifier {
    public int level;
    public String type;
    public HashSet<String> modifiers;
    public static final HashMap<String, String> MODIFIER_TEXT = new HashMap<String, String>(){
        {
            this.put("lapis_lazuli", "Luck");
            this.put("redstone", "Haste");
            this.put("quartz", "Sharp");
            this.put("silky_jewel", "Silky");
            this.put("mending_moss", "Mending Moss");
        }
    };
    public static final HashMap<String, Integer> MODIFIER_COLOR = new HashMap<String, Integer>(){
        {
            this.put("lapis_lazuli", 2203324);
            this.put("redstone", 14034984);
            this.put("quartz", 13299960);
            this.put("silky_jewel", 16369487);
            this.put("mending_moss", 10996055);
        }
    };

    public Modifier(String type, int level, HashSet<String> modifiers) {
        this.level = level;
        this.type = type;
        this.modifiers = modifiers;
    }

    public static HashSet<class_2561> getTooltip(class_1799 stack) {
        HashSet<class_2561> tooltips = new HashSet<class_2561>();
        if (!(stack.method_7909() instanceof BaseSmitheeTool && stack.method_7985() && stack.method_7969().method_10545("SmitheeProperties") && stack.method_7941("SmitheeProperties").method_10545("Modifiers"))) {
            return tooltips;
        }
        for (String modifier : stack.method_7941("SmitheeProperties").method_10562("Modifiers").method_10562("Slots").method_10541()) {
            int level = stack.method_7941("SmitheeProperties").method_10562("Modifiers").method_10562("Slots").method_10550(modifier);
            tooltips.add((class_2561)new class_2585(MODIFIER_TEXT.get(modifier) + " " + Utils.toRoman(level)).method_10862(class_2583.field_24360.method_27703(TextColorInvoker.init(MODIFIER_COLOR.get(modifier)))));
        }
        return tooltips;
    }

    public static HashMap<String, Modifier> evaluateModifiers(class_1799 stack) {
        HashMap<String, Modifier> result = new HashMap<String, Modifier>();
        if (!(stack.method_7909() instanceof BaseSmitheeTool && stack.method_7985() && stack.method_7969().method_10545("SmitheeProperties") && stack.method_7941("SmitheeProperties").method_10545("Modifiers"))) {
            return result;
        }
        Set modifiers = stack.method_7941("SmitheeProperties").method_10562("Modifiers").method_10562("Slots").method_10541();
        Iterator iterator = modifiers.iterator();
        while (iterator.hasNext()) {
            HashMap<String, EmbossRecipe> registry = ItemRegistry.EMBOSS_RECIPES;
            String modifier = (String)iterator.next();
            if (!registry.containsKey(modifier)) continue;
            EmbossRecipe recipe = ItemRegistry.EMBOSS_RECIPES.get(modifier);
            String toolType = Utils.getToolType(stack.method_7909());
            HashSet<String> gives = new HashSet<String>();
            for (EmbossModifiers embossModifiers : recipe.modifiers) {
                if (!embossModifiers.givesTo.contains(toolType)) continue;
                gives.add(embossModifiers.gives);
            }
            int level = stack.method_7941("SmitheeProperties").method_10562("Modifiers").method_10562("Slots").method_10550(modifier);
            Modifier mod = new Modifier(recipe.type, level, gives);
            result.put(Utils.capitalize(modifier.split("_")), mod);
        }
        return result;
    }
}

