/*
 * Decompiled with CFR 0.152.
 */
package wraith.smithee.properties;

import java.util.HashMap;
import java.util.HashSet;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import wraith.smithee.properties.PartCombination;
import wraith.smithee.properties.Property;
import wraith.smithee.properties.Trait;
import wraith.smithee.registry.ItemRegistry;
import wraith.smithee.utils.Utils;

public class Properties {
    public HashMap<String, HashSet<Trait>> traits = new HashMap();
    public HashMap<String, Property> partProperties = new HashMap();

    public static Property getProperties(class_1799 stack) {
        class_2487 tag = stack.method_7941("Parts");
        String headPart = tag.method_10558("HeadPart");
        String bindingPart = tag.method_10558("BindingPart");
        String handlePart = tag.method_10558("HandlePart");
        Properties headProperties = ItemRegistry.PROPERTIES.get(headPart);
        Properties bindingProperties = ItemRegistry.PROPERTIES.get(bindingPart);
        Properties handleProperties = ItemRegistry.PROPERTIES.get(handlePart);
        int miningLevel = Math.max(headProperties.partProperties.get((Object)"head").miningLevel + bindingProperties.partProperties.get((Object)"binding").miningLevel + handleProperties.partProperties.get((Object)"handle").miningLevel, 0);
        int durability = Math.max(headProperties.partProperties.get((Object)"head").durability + bindingProperties.partProperties.get((Object)"binding").durability + handleProperties.partProperties.get((Object)"handle").durability, 1);
        float miningSpeed = Math.max(headProperties.partProperties.get((Object)"head").miningSpeed + bindingProperties.partProperties.get((Object)"binding").miningSpeed + handleProperties.partProperties.get((Object)"handle").miningSpeed, 0.5f);
        float attackDamage = Math.max(headProperties.partProperties.get((Object)"head").attackDamage + bindingProperties.partProperties.get((Object)"binding").attackDamage + handleProperties.partProperties.get((Object)"handle").attackDamage, 0.5f);
        float attackSpeed = Math.max(headProperties.partProperties.get((Object)"head").attackSpeed + bindingProperties.partProperties.get((Object)"binding").attackSpeed + handleProperties.partProperties.get((Object)"handle").attackSpeed, 0.5f);
        PartCombination partCombination = null;
        for (PartCombination combination : PartCombination.COMBINATIONS) {
            if (!combination.includes.get("head").isEmpty() && !combination.includes.get("head").contains(headPart) || !combination.includes.get("binding").isEmpty() && !combination.includes.get("binding").contains(bindingPart) || !combination.includes.get("handle").isEmpty() && !combination.includes.get("handle").contains(handlePart) || combination.excludes.get("head").contains(headPart) || combination.excludes.get("binding").contains(bindingPart) || combination.excludes.get("handle").contains(handlePart)) continue;
            partCombination = combination;
            break;
        }
        if (partCombination != null) {
            if (partCombination.stats.containsKey("mining_level")) {
                miningLevel = (int)Utils.evaluateExpression(partCombination.stats.get("mining_level").replace("base", String.valueOf(miningLevel)));
            } else if (partCombination.stats.containsKey("durability")) {
                durability = (int)Utils.evaluateExpression(partCombination.stats.get("durability").replace("base", String.valueOf(durability)));
            } else if (partCombination.stats.containsKey("mining_speed")) {
                miningSpeed = (int)Utils.evaluateExpression(partCombination.stats.get("mining_speed").replace("base", String.valueOf(miningSpeed)));
            } else if (partCombination.stats.containsKey("attack_damage")) {
                attackDamage = (int)Utils.evaluateExpression(partCombination.stats.get("attack_damage").replace("base", String.valueOf(attackDamage)));
            } else if (partCombination.stats.containsKey("attack_speed")) {
                attackSpeed = (int)Utils.evaluateExpression(partCombination.stats.get("attack_speed").replace("base", String.valueOf(attackSpeed)));
            }
        }
        return new Property(miningSpeed, miningLevel, durability, attackDamage, attackSpeed);
    }

    public static void setProperties(class_1799 itemStack, Property properties) {
        class_2487 tag = itemStack.method_7911("SmitheeProperties");
        tag.method_10569("MiningLevel", properties.miningLevel);
        tag.method_10548("MiningSpeed", properties.miningSpeed);
        tag.method_10548("AttackSpeed", properties.attackSpeed);
        tag.method_10548("AttackDamage", properties.attackDamage);
        tag.method_10569("Durability", properties.durability);
        tag.method_10569("Experience", 0);
        tag.method_10569("Level", 0);
        class_2487 modifiers = new class_2487();
        modifiers.method_10566("Slots", (class_2520)new class_2487());
        modifiers.method_10569("TraitSlots", 1);
        modifiers.method_10569("EnchantmentSlots", 0);
        tag.method_10566("Modifiers", (class_2520)modifiers);
        itemStack.method_7959("SmitheeProperties", (class_2520)tag);
    }

    public static float getExtraDamage(String toolType) {
        switch (toolType) {
            case "pickaxe": {
                return 1.0f;
            }
            case "axe": {
                return 6.0f;
            }
            case "sword": {
                return 3.0f;
            }
            case "shovel": {
                return 1.5f;
            }
        }
        return 0.0f;
    }

    public static float getExtraAttackSpeed(String toolType) {
        switch (toolType) {
            case "pickaxe": {
                return 0.2f;
            }
            case "axe": {
                return -0.2f;
            }
            case "sword": {
                return 0.6f;
            }
        }
        return 0.0f;
    }
}

