/*
 * Decompiled with CFR 0.152.
 */
package wraith.smithee.properties;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2585;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;
import wraith.smithee.items.tools.BaseSmitheeTool;
import wraith.smithee.mixin.TextColorInvoker;
import wraith.smithee.registry.ItemRegistry;
import wraith.smithee.utils.Utils;

public class Trait {
    public String traitName;
    public int minLevel;
    public int maxLevel;
    public double chance;
    public static final HashMap<String, class_2561> TRAIT_TEXT = new HashMap<String, class_2561>(){
        {
            this.put("ecological", new class_2585("Ecological").method_10862(class_2583.field_24360.method_27703(TextColorInvoker.init(8807718))));
            this.put("midas_touch", new class_2585("Midas Touch").method_10862(class_2583.field_24360.method_27703(TextColorInvoker.init(15315221))));
            this.put("brittle", new class_2585("Brittle").method_10862(class_2583.field_24360.method_27703(TextColorInvoker.init(0x6C6C6C))));
            this.put("magnetic", new class_2585("Magnetic").method_10862(class_2583.field_24360.method_27703(TextColorInvoker.init(3402699))));
            this.put("superheated", new class_2585("SuperHeated").method_10862(class_2583.field_24360.method_27703(TextColorInvoker.init(6947855))));
            this.put("sharp", new class_2585("Sharp").method_10862(class_2583.field_24360.method_27703(TextColorInvoker.init(8908748))));
            this.put("chilling", new class_2585("Chilling").method_10862(class_2583.field_24360.method_27703(TextColorInvoker.init(577021))));
            this.put("adamant", new class_2585("Adamant").method_10862(class_2583.field_24360.method_27703(TextColorInvoker.init(12517414))));
            this.put("aquadynamic", new class_2585("Aquadynamic").method_10862(class_2583.field_24360.method_27703(TextColorInvoker.init(10670847))));
        }
    };

    public Trait(String traitName, int minLevel, int maxLevel, double chance) {
        this.traitName = traitName;
        this.minLevel = minLevel;
        this.maxLevel = maxLevel;
        this.chance = chance;
    }

    public static HashSet<class_2561> getTooltip(class_1799 stack) {
        HashSet<class_2561> tooltips = new HashSet<class_2561>();
        if (!(stack.method_7909() instanceof BaseSmitheeTool && stack.method_7985() && stack.method_7969().method_10545("Parts"))) {
            return tooltips;
        }
        class_2487 tag = stack.method_7969().method_10562("Parts");
        String head = tag.method_10558("HeadPart");
        String binding = tag.method_10558("BindingPart");
        String handle = tag.method_10558("HandlePart");
        for (Trait trait : ItemRegistry.PROPERTIES.get((Object)head).traits.get("head")) {
            tooltips.add(TRAIT_TEXT.get(trait.traitName));
        }
        for (Trait trait : ItemRegistry.PROPERTIES.get((Object)binding).traits.get("binding")) {
            tooltips.add(TRAIT_TEXT.get(trait.traitName));
        }
        for (Trait trait : ItemRegistry.PROPERTIES.get((Object)handle).traits.get("handle")) {
            tooltips.add(TRAIT_TEXT.get(trait.traitName));
        }
        return tooltips;
    }

    public static HashMap<String, Object> evaluateTraits(class_1799 stack, class_1937 world, class_2338 pos, class_2680 state, @Nullable class_2586 blockEntity, class_1297 player, String source) {
        HashMap<String, Object> returns = new HashMap<String, Object>();
        if (!(stack.method_7909() instanceof BaseSmitheeTool && stack.method_7985() && stack.method_7969().method_10545("Parts"))) {
            return returns;
        }
        class_2487 tag = stack.method_7969().method_10562("Parts");
        HashMap<String, String> parts = new HashMap<String, String>();
        parts.put("head", tag.method_10558("HeadPart"));
        parts.put("binding", tag.method_10558("BindingPart"));
        parts.put("handle", tag.method_10558("HandlePart"));
        HashSet<Trait> evaluateOnce = new HashSet<Trait>();
        HashSet<String> evaluateOnceString = new HashSet<String>();
        evaluateOnceString.add("magnetic");
        for (String part : parts.keySet()) {
            HashSet<Trait> traits = ItemRegistry.PROPERTIES.get(parts.get((Object)part)).traits.get(part);
            for (Trait trait : traits) {
                if (evaluateOnceString.contains(trait.traitName)) {
                    evaluateOnce.add(trait);
                    continue;
                }
                returns.putAll(Trait.evaluateTrait(trait, source, stack, state, world, pos, blockEntity, player, returns));
            }
        }
        for (Trait trait : evaluateOnce) {
            returns.putAll(Trait.evaluateTrait(trait, source, stack, state, world, pos, blockEntity, player, returns));
        }
        return returns;
    }

    public static HashMap<String, Object> evaluateTrait(Trait trait, String source, class_1799 stack, class_2680 state, class_1937 world, class_2338 pos, @Nullable class_2586 blockEntity, class_1297 player, HashMap<String, Object> variables) {
        HashMap<String, Object> returns = new HashMap<String, Object>();
        if (stack == class_1799.field_8037 || trait.chance == 0.0 || Utils.getRandomDoubleInRange(0, 100) > trait.chance * 100.0) {
            return returns;
        }
        switch (trait.traitName) {
            case "midas_touch": {
                if (!"Block#afterBreak".equals(source)) break;
                returns.put("Cancel Exhaustion", false);
                returns.put("Cancel Drops", false);
                if (world.method_8608()) break;
                List changedDrops = class_2248.method_9609((class_2680)state, (class_3218)((class_3218)world), (class_2338)pos, (class_2586)blockEntity, (class_1297)player, (class_1799)stack);
                changedDrops.add(new class_1799((class_1935)class_1802.field_8397, Utils.getRandomIntInRange(trait.minLevel, trait.maxLevel)));
                returns.put("Drops", changedDrops);
                break;
            }
            case "ecological": {
                if (!"ItemStack#inventoryTick".equals(source)) break;
                Utils.repair(stack, 1);
                break;
            }
            case "superheated": {
                if (!"ItemEntity#isFireImmune".equals(source)) break;
                returns.put("Fire Immunity", true);
                break;
            }
            case "brittle": {
                if (!"Block#afterBreak".equals(source)) break;
                Utils.damage(stack, Utils.getRandomIntInRange(trait.minLevel, trait.maxLevel));
                break;
            }
            case "magnetic": {
                if (!"Block#afterBreak".equals(source)) break;
                returns.put("Cancel Exhaustion", false);
                returns.put("Cancel Drops", true);
                for (class_1799 drop : (List)variables.getOrDefault("Drops", class_2248.method_9609((class_2680)state, (class_3218)((class_3218)world), (class_2338)pos, (class_2586)blockEntity, (class_1297)player, (class_1799)stack))) {
                    ((class_1657)player).field_7514.method_7398(world, drop);
                }
                break;
            }
            case "chilling": {
                if (!"LivingEntity#damage".equals(source)) break;
                returns.put("Damage Entity Effect Type", "frostbite");
                returns.put("Damage Entity Effect Duration", Utils.getRandomIntInRange(trait.minLevel, trait.maxLevel));
                break;
            }
            case "adamant": {
                if (!"ItemStack#damage".equals(source)) break;
                returns.put("Cancel Item Damage", true);
                break;
            }
            case "sharp": {
                if (!"MobEntity#tryAttack".equals(source)) break;
                returns.put("Attack Damage Amount", Float.valueOf((float)Utils.getRandomDoubleInRange(trait.minLevel, trait.maxLevel)));
                break;
            }
            case "aquadynamic": {
                if (!"EnchantmentHelper#hasAquaAffinity".equals(source)) break;
                returns.put("Has Aqua Affinity", true);
            }
        }
        return returns;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Trait)) {
            return false;
        }
        Trait trait = (Trait)o;
        return trait.traitName.equals(this.traitName) && trait.minLevel == this.minLevel && trait.maxLevel == this.maxLevel && trait.chance == this.chance;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.traitName.hashCode();
        result = 31 * result + this.minLevel;
        result = 31 * result + this.maxLevel;
        result = (int)((double)(31 * result) + this.chance);
        return result;
    }
}

