/*
 * Decompiled with CFR 0.152.
 */
package wraith.smithee.registry;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import wraith.smithee.Config;
import wraith.smithee.ItemGroups;
import wraith.smithee.Smithee;
import wraith.smithee.items.Chisel;
import wraith.smithee.items.tool_parts.Part;
import wraith.smithee.items.tool_parts.ToolPartItem;
import wraith.smithee.items.tools.BaseSmitheeAxe;
import wraith.smithee.items.tools.BaseSmitheeHoe;
import wraith.smithee.items.tools.BaseSmitheePickaxe;
import wraith.smithee.items.tools.BaseSmitheeShovel;
import wraith.smithee.items.tools.BaseSmitheeSword;
import wraith.smithee.properties.ChiselingRecipe;
import wraith.smithee.properties.Properties;
import wraith.smithee.properties.ToolPartRecipe;
import wraith.smithee.recipes.EmbossRecipe;
import wraith.smithee.registry.BlockRegistry;
import wraith.smithee.utils.JsonParser;
import wraith.smithee.utils.Utils;

public class ItemRegistry {
    public static final HashSet<class_1792> DISABLED_ITEMS = new HashSet();
    public static HashMap<String, class_1792> ITEMS = new HashMap();
    public static HashSet<String> MATERIALS = new HashSet();
    public static final HashSet<String> EMBOSS_MATERIALS = new HashSet();
    public static final HashMap<String, class_2960> SHARDS = new HashMap();
    public static final ArrayList<ChiselingRecipe> CHISELING_RECIPES = new ArrayList();
    public static HashSet<String> TOOL_TYPES = new HashSet<String>(){
        {
            this.add("pickaxe");
            this.add("axe");
            this.add("shovel");
            this.add("sword");
            this.add("hoe");
        }
    };
    public static final HashMap<String, Properties> PROPERTIES = new HashMap();
    public static final HashMap<class_1792, HashMap<String, ToolPartRecipe>> TOOL_PART_RECIPES = new HashMap();
    public static final HashMap<String, EmbossRecipe> EMBOSS_RECIPES = new HashMap();
    public static final HashMap<String, HashMap<class_2960, Integer>> REMAINS = new HashMap();
    public static final HashMap<String, Integer> BASE_RECIPE_VALUES = new HashMap<String, Integer>(){
        {
            this.put("pickaxe_head", 27);
            this.put("hoe_head", 18);
            this.put("axe_head", 27);
            this.put("shovel_head", 9);
            this.put("sword_head", 18);
            this.put("embossment", 405);
            this.put("binding", 9);
            this.put("handle", 18);
            this.put("sword_guard", 18);
        }
    };

    public static void addItems() {
        for (String material : MATERIALS) {
            try {
                int durability;
                for (String tool : TOOL_TYPES) {
                    durability = ItemRegistry.PROPERTIES.get((Object)material).partProperties.get((Object)"head").durability;
                    ITEMS.put(material + "_" + tool + "_head", new ToolPartItem(new Part(material, "head", tool), new class_1792.class_1793().method_7895(durability).method_7892(ItemGroups.SMITHEE_PARTS)));
                }
                durability = ItemRegistry.PROPERTIES.get((Object)material).partProperties.get((Object)"binding").durability;
                ITEMS.put(material + "_binding", new ToolPartItem(new Part(material, "binding", "any"), new class_1792.class_1793().method_7895(durability).method_7892(ItemGroups.SMITHEE_PARTS)));
                ITEMS.put(material + "_sword_guard", new ToolPartItem(new Part(material, "sword_guard", "any"), new class_1792.class_1793().method_7895(durability).method_7892(ItemGroups.SMITHEE_PARTS)));
                durability = ItemRegistry.PROPERTIES.get((Object)material).partProperties.get((Object)"handle").durability;
                ITEMS.put(material + "_handle", new ToolPartItem(new Part(material, "handle", "any"), new class_1792.class_1793().method_7895(durability).method_7892(ItemGroups.SMITHEE_PARTS)));
            }
            catch (Exception e) {
                Smithee.LOGGER.error("Error with material " + material);
            }
        }
        for (String material : EMBOSS_MATERIALS) {
            ITEMS.put(material + "_embossment", new class_1792(new class_1792.class_1793().method_7892(ItemGroups.SMITHEE_ITEMS)));
        }
        for (ChiselingRecipe recipe : CHISELING_RECIPES) {
            ITEMS.put(recipe.material + "_chisel", new Chisel(new class_1792.class_1793().method_7895(recipe.durability).method_7892(ItemGroups.SMITHEE_ITEMS), recipe.level));
        }
        ITEMS.put("silky_jewel", new class_1792(new class_1792.class_1793().method_7892(ItemGroups.SMITHEE_ITEMS)));
        ITEMS.put("silky_cloth", new class_1792(new class_1792.class_1793().method_7892(ItemGroups.SMITHEE_ITEMS)));
        HashSet<String> woods = new HashSet<String>(){
            {
                this.add("oak");
                this.add("dark_oak");
                this.add("spruce");
                this.add("birch");
                this.add("acacia");
                this.add("jungle");
            }
        };
        for (String wood : woods) {
            ITEMS.put(wood + "_assembly_table", (class_1792)new class_1747(BlockRegistry.BLOCKS.get(wood + "_assembly_table"), new class_1792.class_1793().method_7892(ItemGroups.SMITHEE_BLOCKS)));
            ITEMS.put(wood + "_chiseling_table", (class_1792)new class_1747(BlockRegistry.BLOCKS.get(wood + "_chiseling_table"), new class_1792.class_1793().method_7892(ItemGroups.SMITHEE_BLOCKS)));
        }
        ITEMS.put("stone_disassembly_table", (class_1792)new class_1747(BlockRegistry.BLOCKS.get("stone_disassembly_table"), new class_1792.class_1793().method_7892(ItemGroups.SMITHEE_BLOCKS)));
        ITEMS.put("cobblestone_disassembly_table", (class_1792)new class_1747(BlockRegistry.BLOCKS.get("cobblestone_disassembly_table"), new class_1792.class_1793().method_7892(ItemGroups.SMITHEE_BLOCKS)));
        ITEMS.put("mossy_cobblestone_disassembly_table", (class_1792)new class_1747(BlockRegistry.BLOCKS.get("mossy_cobblestone_disassembly_table"), new class_1792.class_1793().method_7892(ItemGroups.SMITHEE_BLOCKS)));
        ITEMS.put("diorite_disassembly_table", (class_1792)new class_1747(BlockRegistry.BLOCKS.get("diorite_disassembly_table"), new class_1792.class_1793().method_7892(ItemGroups.SMITHEE_BLOCKS)));
        ITEMS.put("andesite_disassembly_table", (class_1792)new class_1747(BlockRegistry.BLOCKS.get("andesite_disassembly_table"), new class_1792.class_1793().method_7892(ItemGroups.SMITHEE_BLOCKS)));
        ITEMS.put("granite_disassembly_table", (class_1792)new class_1747(BlockRegistry.BLOCKS.get("granite_disassembly_table"), new class_1792.class_1793().method_7892(ItemGroups.SMITHEE_BLOCKS)));
        ITEMS.put("netherrack_disassembly_table", (class_1792)new class_1747(BlockRegistry.BLOCKS.get("netherrack_disassembly_table"), new class_1792.class_1793().method_7892(ItemGroups.SMITHEE_BLOCKS)));
        ITEMS.put("base_smithee_pickaxe", (class_1792)new BaseSmitheePickaxe(new class_1792.class_1793().method_7892(ItemGroups.SMITHEE_PARTS)));
        ITEMS.put("base_smithee_axe", (class_1792)new BaseSmitheeAxe(new class_1792.class_1793().method_7892(ItemGroups.SMITHEE_PARTS)));
        ITEMS.put("base_smithee_shovel", (class_1792)new BaseSmitheeShovel(new class_1792.class_1793().method_7892(ItemGroups.SMITHEE_PARTS)));
        ITEMS.put("base_smithee_hoe", (class_1792)new BaseSmitheeHoe(new class_1792.class_1793().method_7892(ItemGroups.SMITHEE_PARTS)));
        ITEMS.put("base_smithee_sword", (class_1792)new BaseSmitheeSword(new class_1792.class_1793().method_7892(ItemGroups.SMITHEE_PARTS)));
        ITEMS.put("items_creative_icon", new class_1792(new class_1792.class_1793()));
        ITEMS.put("parts_creative_icon", new class_1792(new class_1792.class_1793()));
    }

    public static void setDisabledItems() {
        DISABLED_ITEMS.clear();
        DISABLED_ITEMS.add(class_1802.field_8406);
        DISABLED_ITEMS.add(class_1802.field_8647);
        DISABLED_ITEMS.add(class_1802.field_8876);
        DISABLED_ITEMS.add(class_1802.field_8091);
        DISABLED_ITEMS.add(class_1802.field_8167);
        DISABLED_ITEMS.add(class_1802.field_8825);
        DISABLED_ITEMS.add(class_1802.field_8335);
        DISABLED_ITEMS.add(class_1802.field_8322);
        DISABLED_ITEMS.add(class_1802.field_8845);
        DISABLED_ITEMS.add(class_1802.field_8303);
        DISABLED_ITEMS.add(class_1802.field_8062);
        DISABLED_ITEMS.add(class_1802.field_8387);
        DISABLED_ITEMS.add(class_1802.field_8776);
        DISABLED_ITEMS.add(class_1802.field_8528);
        DISABLED_ITEMS.add(class_1802.field_8431);
        DISABLED_ITEMS.add(class_1802.field_8475);
        DISABLED_ITEMS.add(class_1802.field_8403);
        DISABLED_ITEMS.add(class_1802.field_8699);
        DISABLED_ITEMS.add(class_1802.field_8371);
        DISABLED_ITEMS.add(class_1802.field_8609);
        DISABLED_ITEMS.add(class_1802.field_8556);
        DISABLED_ITEMS.add(class_1802.field_8377);
        DISABLED_ITEMS.add(class_1802.field_8250);
        DISABLED_ITEMS.add(class_1802.field_8802);
        DISABLED_ITEMS.add(class_1802.field_8527);
        DISABLED_ITEMS.add(class_1802.field_22025);
        DISABLED_ITEMS.add(class_1802.field_22024);
        DISABLED_ITEMS.add(class_1802.field_22023);
        DISABLED_ITEMS.add(class_1802.field_22022);
        DISABLED_ITEMS.add(class_1802.field_22026);
    }

    public static void registerItems() {
        for (String id : ITEMS.keySet()) {
            class_2378.method_10230((class_2378)class_2378.field_11142, (class_2960)Utils.ID(id), (Object)ITEMS.get(id));
        }
    }

    public static void addMaterials() {
        JsonArray array = Config.getJsonObject(Config.readFile(new File("config/smithee/materials.json"))).get("materials").getAsJsonArray();
        for (JsonElement element : array) {
            MATERIALS.add(element.getAsString());
        }
        array = Config.getJsonObject(Config.readFile(new File("config/smithee/emboss_materials.json"))).get("materials").getAsJsonArray();
        for (JsonElement element : array) {
            EMBOSS_MATERIALS.add(element.getAsString());
        }
    }

    public static void addMaterials(String materials, String emboss) {
        JsonArray array = Config.getJsonObject(materials).get("materials").getAsJsonArray();
        for (JsonElement element : array) {
            MATERIALS.add(element.getAsString());
        }
        array = Config.getJsonObject(emboss).get("materials").getAsJsonArray();
        for (JsonElement element : array) {
            EMBOSS_MATERIALS.add(element.getAsString());
        }
    }

    public static void generateProperties() {
        File[] files = Config.getFiles("config/smithee/stats/");
        if (files == null) {
            return;
        }
        for (File file : files) {
            JsonObject json = Config.getJsonObject(Config.readFile(file));
            try {
                String[] segments = file.getName().split("/");
                String filename = segments[segments.length - 1].split("\\.")[0];
                PROPERTIES.put(filename, new Properties());
                JsonObject parts = json.get("individual_parts").getAsJsonObject();
                ItemRegistry.PROPERTIES.get((Object)filename).traits.put("head", new HashSet());
                ItemRegistry.PROPERTIES.get((Object)filename).traits.put("binding", new HashSet());
                ItemRegistry.PROPERTIES.get((Object)filename).traits.put("handle", new HashSet());
                JsonParser.parseIndividualPart(parts.get("head").getAsJsonObject(), PROPERTIES.get(filename), "head");
                JsonParser.parseIndividualPart(parts.get("binding").getAsJsonObject(), PROPERTIES.get(filename), "binding");
                JsonParser.parseIndividualPart(parts.get("handle").getAsJsonObject(), PROPERTIES.get(filename), "handle");
            }
            catch (Exception e) {
                Smithee.LOGGER.error("Found error with stats file '" + file.getName() + "'");
            }
        }
    }

    public static void generateProperties(HashMap<String, String> contents) {
        if (contents == null || contents.size() == 0) {
            return;
        }
        for (Map.Entry<String, String> content : contents.entrySet()) {
            JsonObject json = Config.getJsonObject(content.getValue());
            String name = content.getKey();
            PROPERTIES.put(name, new Properties());
            JsonObject parts = json.get("individual_parts").getAsJsonObject();
            ItemRegistry.PROPERTIES.get((Object)name).traits.put("head", new HashSet());
            ItemRegistry.PROPERTIES.get((Object)name).traits.put("binding", new HashSet());
            ItemRegistry.PROPERTIES.get((Object)name).traits.put("handle", new HashSet());
            JsonParser.parseIndividualPart(parts.get("head").getAsJsonObject(), PROPERTIES.get(name), "head");
            JsonParser.parseIndividualPart(parts.get("binding").getAsJsonObject(), PROPERTIES.get(name), "binding");
            JsonParser.parseIndividualPart(parts.get("handle").getAsJsonObject(), PROPERTIES.get(name), "handle");
        }
    }

    public static void generateChiselingStats() {
        File[] files = Config.getFiles("config/smithee/chisels/");
        if (files == null) {
            return;
        }
        for (File file : files) {
            JsonObject obj = Config.getJsonObject(Config.readFile(file));
            if (obj.has("requires_mod") && !FabricLoader.getInstance().isModLoaded(obj.get("requires_mod").getAsString())) continue;
            JsonArray json = obj.get("chisels").getAsJsonArray();
            try {
                JsonParser.parseChiselingStats(json, CHISELING_RECIPES);
            }
            catch (Exception e) {
                Smithee.LOGGER.warn("Found error with chiseling file '" + file.getName() + "'");
            }
        }
    }

    public static void generateChiselingStats(String[] contents) {
        if (contents == null || contents.length == 0) {
            return;
        }
        for (String content : contents) {
            JsonObject obj = Config.getJsonObject(content);
            if (obj.has("requires_mod") && !FabricLoader.getInstance().isModLoaded(obj.get("requires_mod").getAsString())) continue;
            JsonArray json = obj.get("chisels").getAsJsonArray();
            JsonParser.parseChiselingStats(json, CHISELING_RECIPES);
        }
    }

    public static void generateRecipes() {
        File[] files = Config.getFiles("config/smithee/recipes/");
        if (files == null) {
            return;
        }
        TOOL_PART_RECIPES.clear();
        REMAINS.clear();
        for (File file : files) {
            JsonObject json = Config.getJsonObject(Config.readFile(file));
            try {
                Set recipes = json.entrySet();
                JsonParser.parseRecipes(recipes, TOOL_PART_RECIPES, REMAINS);
            }
            catch (Exception e) {
                Smithee.LOGGER.warn("Found error with recipes file '" + file.getName() + "'");
            }
        }
    }

    public static void generateRecipes(String[] contents) {
        if (contents == null || contents.length == 0) {
            return;
        }
        for (String content : contents) {
            JsonObject json = Config.getJsonObject(content);
            Set recipes = json.entrySet();
            JsonParser.parseRecipes(recipes, TOOL_PART_RECIPES, REMAINS);
        }
    }

    public static void generateModifiers() {
        File[] files = Config.getFiles("config/smithee/modifiers/");
        if (files == null) {
            return;
        }
        EMBOSS_RECIPES.clear();
        for (File file : files) {
            JsonParser.parseModifiers(Config.getJsonObject(Config.readFile(file)), EMBOSS_RECIPES);
        }
    }

    public static void generateModifiers(String[] contents) {
        if (contents == null || contents.length == 0) {
            return;
        }
        SHARDS.clear();
        for (String content : contents) {
            JsonParser.parseModifiers(Config.getJsonObject(content), EMBOSS_RECIPES);
        }
    }

    public static void generateShards() {
        File[] files = Config.getFiles("config/smithee/shards/");
        if (files == null) {
            return;
        }
        SHARDS.clear();
        for (File file : files) {
            JsonObject obj = Config.getJsonObject(Config.readFile(file));
            if (obj.has("requires_mod") && !FabricLoader.getInstance().isModLoaded(obj.get("requires_mod").getAsString())) continue;
            JsonParser.parseShards(obj, SHARDS);
        }
    }

    public static void generateShards(String[] contents) {
        if (contents == null || contents.length == 0) {
            return;
        }
        SHARDS.clear();
        for (String content : contents) {
            JsonObject obj = Config.getJsonObject(content);
            if (obj.has("requires_mod") && !FabricLoader.getInstance().isModLoaded(obj.get("requires_mod").getAsString())) continue;
            JsonParser.parseShards(obj, SHARDS);
        }
    }
}

