/*
 * Decompiled with CFR 0.152.
 */
package wraith.smithee.screens;

import java.util.HashSet;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2596;
import net.minecraft.class_2653;
import net.minecraft.class_3222;
import wraith.smithee.blocks.AassemblyTableBlockEntity;
import wraith.smithee.items.tool_parts.ToolPartItem;
import wraith.smithee.items.tools.BaseSmitheeTool;
import wraith.smithee.properties.Properties;
import wraith.smithee.properties.ToolPartRecipe;
import wraith.smithee.recipes.EmbossRecipe;
import wraith.smithee.registry.ItemRegistry;
import wraith.smithee.registry.ScreenHandlerRegistry;
import wraith.smithee.screens.slots.AssemblyTableOutputSlot;
import wraith.smithee.screens.slots.PartSlot;
import wraith.smithee.screens.slots.ToolSlot;
import wraith.smithee.utils.Utils;

public class AssemblyTableScreenHandler
extends class_1703 {
    private class_1263 inventory;
    private String toolName = "";

    public AssemblyTableScreenHandler(int syncId, class_1661 playerInventory) {
        this(syncId, playerInventory, (class_1263)new class_1277(5));
    }

    public AssemblyTableScreenHandler(int syncId, class_1661 playerInventory, class_1263 inventory) {
        super(ScreenHandlerRegistry.SCREEN_HANDLERS.get("assembly_table"), syncId);
        this.inventory = inventory;
        if (inventory instanceof AassemblyTableBlockEntity) {
            ((AassemblyTableBlockEntity)inventory).setHandler(this);
        }
        this.method_7621(new PartSlot(inventory, 0, 35, 57, "handle"));
        this.method_7621(new PartSlot(inventory, 1, 47, 37, "binding", "sword_guard"));
        this.method_7621(new PartSlot(inventory, 2, 59, 17, "head"));
        this.method_7621(new AssemblyTableOutputSlot(inventory, 3, 113, 43, true));
        HashSet<class_1792> itemSet = new HashSet<class_1792>();
        for (String item : ItemRegistry.EMBOSS_MATERIALS) {
            itemSet.add(ItemRegistry.ITEMS.get(item + "_embossment"));
        }
        this.method_7621(new ToolSlot(inventory, 4, 113, 11, itemSet));
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.method_7621(new class_1735((class_1263)playerInventory, x + y * 9 + 9, 8 + x * 18, 102 + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.method_7621(new class_1735((class_1263)playerInventory, x, 8 + x * 18, 160));
        }
    }

    public boolean method_7597(class_1657 playerEntity) {
        return this.inventory.method_5443(playerEntity);
    }

    public class_1799 method_7601(class_1657 player, int invSlot) {
        class_1799 newStack = class_1799.field_8037;
        class_1735 slot = (class_1735)this.field_7761.get(invSlot);
        if (slot != null && slot.method_7681()) {
            class_1799 originalStack = slot.method_7677();
            newStack = originalStack.method_7972();
            if (invSlot < 5) {
                this.method_7609(this.inventory);
                if (!this.method_7616(originalStack, this.inventory.method_5439(), this.field_7761.size(), true)) {
                    return class_1799.field_8037;
                }
            } else if (originalStack.method_7909() instanceof ToolPartItem) {
                ToolPartItem tool = (ToolPartItem)originalStack.method_7909();
                if ("handle".equals(tool.part.partType) && !this.method_7616(originalStack, 0, 1, false) || ("binding".equals(tool.part.partType) || "sword_guard".equals(tool.part.partType)) && !this.method_7616(originalStack, 1, 2, false) || "head".equals(tool.part.partType) && !this.method_7616(originalStack, 2, 3, false)) {
                    return class_1799.field_8037;
                }
            } else if (originalStack.method_7909() instanceof BaseSmitheeTool ? !this.method_7616(originalStack, 3, 4, false) : (class_2378.field_11142.method_10221((Object)originalStack.method_7909()).method_12832().endsWith("_embossment") ? !this.method_7616(originalStack, 4, 5, false) : (invSlot < this.field_7761.size() - 9 ? !this.method_7616(originalStack, this.field_7761.size() - 9, this.field_7761.size(), false) : !this.method_7616(originalStack, this.inventory.method_5439(), this.field_7761.size() - 4 - 9, false)))) {
                return class_1799.field_8037;
            }
            if (originalStack.method_7960()) {
                slot.method_7673(class_1799.field_8037);
            } else {
                slot.method_7668();
            }
        }
        return newStack;
    }

    public boolean method_7604(class_1657 player, int id) {
        if (!(player instanceof class_3222) || player.field_6002.method_8608()) {
            return false;
        }
        class_3222 serverPlayerEntity = (class_3222)player;
        if (id == 1) {
            class_2487 slots;
            if (this.inventory.method_5438(3) == class_1799.field_8037 || this.inventory.method_5438(4) == class_1799.field_8037) {
                return false;
            }
            class_1799 emboss = this.inventory.method_5438(4).method_7972();
            class_1799 tool = this.inventory.method_5438(3);
            String[] segments = class_2378.field_11142.method_10221((Object)emboss.method_7909()).method_12832().split("/");
            segments = segments[segments.length - 1].split("_");
            StringBuilder material = new StringBuilder();
            for (int i = 0; i < segments.length - 1; ++i) {
                material.append("_").append(segments[i]);
            }
            if (!ItemRegistry.EMBOSS_RECIPES.containsKey((material = new StringBuilder(material.substring(1))).toString())) {
                return false;
            }
            EmbossRecipe recipe = ItemRegistry.EMBOSS_RECIPES.get(material.toString());
            class_2487 mainTag = tool.method_7941("SmitheeProperties");
            if (!mainTag.method_10545("Modifiers")) {
                return false;
            }
            class_2487 tag = mainTag.method_10562("Modifiers");
            int traitSlots = tag.method_10550("TraitSlots");
            int enchantmentSlots = tag.method_10550("EnchantmentSlots");
            if ("enchant".equals(recipe.type) && enchantmentSlots > 0 || "trait".equals(recipe.type) && traitSlots > 0) {
                slots = tag.method_10562("Slots");
                for (String key : slots.method_10541()) {
                    if (!recipe.incompatible.contains(key)) continue;
                    return false;
                }
                if (!recipe.stackable && slots.method_10541().contains(material.toString())) {
                    return false;
                }
                slots.method_10569(material.toString(), slots.method_10545(material.toString()) ? slots.method_10550(material.toString()) + 1 : 1);
                emboss.method_7934(1);
                if ("enchant".equals(recipe.type)) {
                    tag.method_10569("EnchantmentSlots", enchantmentSlots - 1);
                } else {
                    tag.method_10569("TraitSlots", traitSlots - 1);
                }
            } else {
                return false;
            }
            tag.method_10566("Slots", (class_2520)slots);
            mainTag.method_10566("Modifiers", (class_2520)tag);
            tool.method_7959("SmitheeProperties", (class_2520)mainTag);
            this.inventory.method_5447(3, tool);
            this.inventory.method_5447(4, emboss);
            serverPlayerEntity.field_13987.method_14364((class_2596)new class_2653(this.field_7763, 3, tool));
            serverPlayerEntity.field_13987.method_14364((class_2596)new class_2653(this.field_7763, 4, emboss));
        } else if (id == 0) {
            double damagePercent;
            class_1799 oldPart;
            String material;
            boolean canChangeParts;
            boolean handleEmpty = this.inventory.method_5438(0).method_7960();
            boolean bindingEmpty = this.inventory.method_5438(1).method_7960();
            boolean headEmpty = this.inventory.method_5438(2).method_7960();
            boolean slotEmpty = this.inventory.method_5438(3).method_7960();
            boolean canCraftNew = !handleEmpty && !bindingEmpty && !headEmpty && slotEmpty;
            boolean bl = canChangeParts = (!handleEmpty || !bindingEmpty || !headEmpty) && !slotEmpty;
            if (!canCraftNew && !canChangeParts) {
                return false;
            }
            class_1799 handle = this.inventory.method_5438(0);
            class_1799 binding = this.inventory.method_5438(1);
            class_1799 head = this.inventory.method_5438(2);
            HashSet<String> recipe = new HashSet<String>();
            if (!handleEmpty) {
                recipe.add(((ToolPartItem)handle.method_7909()).part.recipeString());
            }
            if (!bindingEmpty) {
                recipe.add(((ToolPartItem)binding.method_7909()).part.recipeString());
            }
            if (!headEmpty) {
                recipe.add(((ToolPartItem)head.method_7909()).part.recipeString());
            }
            if (!ToolPartRecipe.TOOL_ASSEMBLY_RECIPES.contains(recipe) && slotEmpty) {
                return false;
            }
            class_1799 itemStack = this.inventory.method_5438(3);
            if (canCraftNew) {
                itemStack = new class_1799((class_1935)ItemRegistry.ITEMS.get("base_smithee_" + ((ToolPartItem)head.method_7909()).part.toolType));
            }
            class_2487 tag = itemStack.method_7911("Parts");
            int headDurability = 0;
            int bindingDurability = 0;
            int handleDurability = 0;
            int maxDurability = itemStack.method_7936();
            int currentDamage = itemStack.method_7919();
            int summedDurability = 0;
            double headDamage = 0.0;
            double bindingDamage = 0.0;
            double handleDamage = 0.0;
            if (!tag.isEmpty()) {
                headDurability = ItemRegistry.PROPERTIES.get((Object)tag.method_10558((String)"HeadPart")).partProperties.get((Object)"head").durability;
                bindingDurability = ItemRegistry.PROPERTIES.get((Object)tag.method_10558((String)"BindingPart")).partProperties.get((Object)"binding").durability;
                handleDurability = ItemRegistry.PROPERTIES.get((Object)tag.method_10558((String)"HandlePart")).partProperties.get((Object)"handle").durability;
                summedDurability = headDurability + bindingDurability + handleDurability;
                headDamage = (double)(headDurability * maxDurability) / (double)summedDurability * ((double)currentDamage / (double)maxDurability);
                bindingDamage = (double)(bindingDurability * maxDurability) / (double)summedDurability * ((double)currentDamage / (double)maxDurability);
                handleDamage = (double)(handleDurability * maxDurability) / (double)summedDurability * ((double)currentDamage / (double)maxDurability);
            }
            String toolType = Utils.getToolType(itemStack.method_7909());
            if (!headEmpty) {
                if (head.method_7985() && head.method_7969().method_10545("PartDamage")) {
                    headDamage = head.method_7969().method_10574("PartDamage");
                }
                if (!slotEmpty) {
                    material = tag.method_10558("HeadPart");
                    oldPart = new class_1799((class_1935)ItemRegistry.ITEMS.get(material + "_" + toolType + "_head"));
                    double adjustedHeadDurability = (double)(headDurability * maxDurability) / (double)summedDurability;
                    damagePercent = (double)currentDamage / (double)maxDurability * adjustedHeadDurability;
                    oldPart.method_7969().method_10549("PartDamage", damagePercent);
                    Utils.setDamage(oldPart, (int)damagePercent);
                    player.field_7514.method_7398(player.field_6002, oldPart);
                }
                tag.method_10582("HeadPart", ((ToolPartItem)head.method_7909()).part.materialName);
            }
            if (!bindingEmpty) {
                if (binding.method_7985() && binding.method_7969().method_10545("PartDamage")) {
                    bindingDamage = binding.method_7969().method_10574("PartDamage");
                }
                if (!slotEmpty) {
                    material = tag.method_10558("BindingPart");
                    String type = "sword".equals(toolType) ? "_sword_guard" : "_binding";
                    class_1799 oldPart2 = new class_1799((class_1935)ItemRegistry.ITEMS.get(material + type));
                    double adjustedBindingDurability = (double)(bindingDurability * maxDurability) / (double)summedDurability;
                    double damagePercent2 = (double)currentDamage / (double)maxDurability * adjustedBindingDurability;
                    oldPart2.method_7969().method_10549("PartDamage", damagePercent2);
                    Utils.setDamage(oldPart2, (int)damagePercent2);
                    player.field_7514.method_7398(player.field_6002, oldPart2);
                }
                tag.method_10582("BindingPart", ((ToolPartItem)binding.method_7909()).part.materialName);
            }
            if (!handleEmpty) {
                if (handle.method_7985() && handle.method_7969().method_10545("PartDamage")) {
                    handleDamage = handle.method_7969().method_10574("PartDamage");
                }
                if (!slotEmpty) {
                    material = tag.method_10558("HandlePart");
                    oldPart = new class_1799((class_1935)ItemRegistry.ITEMS.get(material + "_handle"));
                    double adjustedHandleDurability = (double)(handleDurability * maxDurability) / (double)summedDurability;
                    damagePercent = (double)currentDamage / (double)maxDurability * adjustedHandleDurability;
                    oldPart.method_7969().method_10549("PartDamage", damagePercent);
                    Utils.setDamage(oldPart, (int)damagePercent);
                    player.field_7514.method_7398(player.field_6002, oldPart);
                }
                tag.method_10582("HandlePart", ((ToolPartItem)handle.method_7909()).part.materialName);
            }
            itemStack.method_7959("Parts", (class_2520)tag);
            Properties.setProperties(itemStack, Properties.getProperties(itemStack));
            double totalDamage = headDamage + bindingDamage + handleDamage;
            Utils.setDamage(itemStack, (int)totalDamage);
            this.inventory.method_5447(3, itemStack);
            this.inventory.method_5438(0).method_7934(1);
            this.inventory.method_5438(1).method_7934(1);
            this.inventory.method_5438(2).method_7934(1);
            serverPlayerEntity.field_13987.method_14364((class_2596)new class_2653(this.field_7763, 0, this.inventory.method_5438(0)));
            serverPlayerEntity.field_13987.method_14364((class_2596)new class_2653(this.field_7763, 1, this.inventory.method_5438(1)));
            serverPlayerEntity.field_13987.method_14364((class_2596)new class_2653(this.field_7763, 2, this.inventory.method_5438(2)));
            serverPlayerEntity.field_13987.method_14364((class_2596)new class_2653(this.field_7763, 3, itemStack));
            return true;
        }
        return false;
    }

    public void setName(String toolName) {
        this.toolName = toolName;
    }

    public String getName() {
        return this.toolName;
    }
}

