/*
 * Decompiled with CFR 0.152.
 */
package wraith.smithee.screens;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2596;
import net.minecraft.class_2653;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3913;
import net.minecraft.class_3919;
import wraith.smithee.items.Chisel;
import wraith.smithee.properties.ToolPartRecipe;
import wraith.smithee.registry.ItemRegistry;
import wraith.smithee.registry.ScreenHandlerRegistry;
import wraith.smithee.screens.slots.ToolOutputSlot;
import wraith.smithee.screens.slots.ToolSlot;
import wraith.smithee.utils.Utils;

public class ChiselingTableScreenHandler
extends class_1703 {
    private final class_1263 inventory;
    private final class_3913 delegate;

    public ChiselingTableScreenHandler(int syncId, class_1661 playerInventory) {
        this(syncId, playerInventory, (class_1263)new class_1277(3), (class_3913)new class_3919(2));
    }

    public ChiselingTableScreenHandler(int syncId, class_1661 playerInventory, class_1263 inventory, class_3913 delegate) {
        super(ScreenHandlerRegistry.SCREEN_HANDLERS.get("chiseling_table"), syncId);
        this.delegate = delegate;
        this.method_17360(this.delegate);
        this.inventory = inventory;
        this.method_7621(new ToolSlot(inventory, 0, 81, 41, Chisel.class));
        this.method_7621(new ToolSlot(inventory, 1, 115, 41, ItemRegistry.TOOL_PART_RECIPES.keySet()));
        this.method_7621(new ToolOutputSlot(inventory, 2, 98, 66));
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.method_7621(new class_1735((class_1263)playerInventory, x + y * 9 + 9, 28 + x * 18, 90 + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.method_7621(new class_1735((class_1263)playerInventory, x, 28 + x * 18, 148));
        }
    }

    public boolean method_7597(class_1657 playerEntity) {
        return this.inventory.method_5443(playerEntity);
    }

    public class_1799 method_7601(class_1657 player, int invSlot) {
        class_1799 newStack = class_1799.field_8037;
        class_1735 slot = (class_1735)this.field_7761.get(invSlot);
        if (slot != null && slot.method_7681()) {
            class_1799 originalStack = slot.method_7677();
            newStack = originalStack.method_7972();
            if (invSlot < 3) {
                if (!this.method_7616(originalStack, this.inventory.method_5439(), this.field_7761.size(), true)) {
                    return class_1799.field_8037;
                }
            } else if (originalStack.method_7909() instanceof Chisel) {
                if (!this.method_7616(originalStack, 0, 1, false)) {
                    return class_1799.field_8037;
                }
            } else {
                if (!this.method_7616(originalStack, 1, 2, false)) {
                    return class_1799.field_8037;
                }
                if (invSlot < this.field_7761.size() - 9 ? !this.method_7616(originalStack, this.field_7761.size() - 9, this.field_7761.size(), false) : !this.method_7616(originalStack, this.inventory.method_5439(), this.field_7761.size() - 4 - 9, false)) {
                    return class_1799.field_8037;
                }
            }
            if (originalStack.method_7960()) {
                slot.method_7673(class_1799.field_8037);
            } else {
                slot.method_7668();
            }
        }
        return newStack;
    }

    public boolean method_7604(class_1657 player, int id) {
        if (id < 5) {
            this.delegate.method_17391(0, id);
            return true;
        }
        if (id == 5 || id == 6) {
            this.delegate.method_17391(0, id);
            this.delegate.method_17391(1, 0);
        } else {
            if (id < 10) {
                this.delegate.method_17391(1, id - 7);
                return true;
            }
            if (!this.inventory.method_5438(1).method_7960()) {
                if (!(player instanceof class_3222)) {
                    return false;
                }
                class_3222 serverPlayerEntity = (class_3222)player;
                class_1799 materialStack = this.inventory.method_5438(1);
                if (!ItemRegistry.TOOL_PART_RECIPES.containsKey(materialStack.method_7909())) {
                    return false;
                }
                HashMap<String, ToolPartRecipe> recipes = ItemRegistry.TOOL_PART_RECIPES.get(materialStack.method_7909());
                String type = this.partPageToString();
                boolean isShard = "shard".equals(type);
                if (isShard) {
                    type = "pickaxe_head";
                } else if ("head".equals(type)) {
                    type = this.toolPageToString() + "_head";
                }
                boolean isRecipe = recipes.containsKey(type);
                if (!(this.inventory.method_5438(0).method_7909() instanceof Chisel)) {
                    return false;
                }
                if (!isRecipe && this.delegate.method_17390(0) != 6) {
                    return false;
                }
                if (isRecipe && ((Chisel)this.inventory.method_5438(0).method_7909()).getChiselingLevel() < recipes.get((Object)type).chiselingLevel) {
                    return false;
                }
                int worth = ItemRegistry.REMAINS.get(recipes.get((Object)type).outputMaterial).get(class_2378.field_11142.method_10221((Object)materialStack.method_7909()));
                int requiredAmount = 1;
                if (!isShard) {
                    requiredAmount = recipes.get((Object)type).requiredAmount;
                }
                if (!isRecipe && materialStack.method_7947() * worth < requiredAmount) {
                    return false;
                }
                if (!this.inventory.method_5438(2).method_7960() && this.inventory.method_5438(2).method_7947() >= this.inventory.method_5438(2).method_7914()) {
                    return false;
                }
                int decAmount = (int)Math.ceil((float)requiredAmount / (float)worth);
                int remains = decAmount * worth - requiredAmount;
                class_1799 outputStack = this.inventory.method_5438(2);
                if (outputStack.method_7960()) {
                    outputStack = isShard ? new class_1799((class_1935)class_2378.field_11142.method_10223(ItemRegistry.SHARDS.get(recipes.get((Object)type).outputMaterial)), worth) : new class_1799((class_1935)ItemRegistry.ITEMS.get(recipes.get((Object)type).outputMaterial + "_" + type));
                    if (!"embossment".equals(type) && !isShard) {
                        outputStack.method_7948().method_10549("PartDamage", 0.0);
                    }
                } else {
                    int difference = outputStack.method_7947() + (isShard ? worth : 1) - outputStack.method_7914();
                    if (difference > 0) {
                        player.field_7514.method_7398(player.field_6002, new class_1799((class_1935)outputStack.method_7909(), difference));
                    }
                    outputStack.method_7933(isShard ? worth : 1);
                }
                this.inventory.method_5447(2, outputStack);
                this.inventory.method_5438(1).method_7934(decAmount);
                Utils.damage(this.inventory.method_5438(0), 1);
                if (!isShard) {
                    HashMap<class_2960, Integer> remainders = ItemRegistry.REMAINS.get(recipes.get((Object)type).outputMaterial);
                    ArrayList<Map.Entry<class_2960, Integer>> mapValues = new ArrayList<Map.Entry<class_2960, Integer>>(remainders.entrySet());
                    mapValues.sort((o1, o2) -> ((Integer)o2.getValue()).compareTo((Integer)o1.getValue()));
                    for (Map.Entry<class_2960, Integer> entry : mapValues) {
                        if (entry.getValue() <= remains) {
                            int amount = remains / entry.getValue();
                            amount = Math.min(((class_1792)class_2378.field_11142.method_10223(entry.getKey())).method_7882(), amount);
                            remains -= amount * entry.getValue();
                            serverPlayerEntity.field_7514.method_7398(serverPlayerEntity.field_6002, new class_1799((class_1935)class_2378.field_11142.method_10223(entry.getKey()), amount));
                        }
                        if (remains > 0) continue;
                        break;
                    }
                }
                serverPlayerEntity.field_13987.method_14364((class_2596)new class_2653(this.field_7763, 0, this.inventory.method_5438(0)));
                serverPlayerEntity.field_13987.method_14364((class_2596)new class_2653(this.field_7763, 1, this.inventory.method_5438(1)));
                serverPlayerEntity.field_13987.method_14364((class_2596)new class_2653(this.field_7763, 2, this.inventory.method_5438(2)));
                return true;
            }
        }
        return false;
    }

    public String partPageToString() {
        switch (this.delegate.method_17390(1)) {
            case 1: {
                return this.delegate.method_17390(0) == 3 ? "sword_guard" : "binding";
            }
            case 2: {
                return "handle";
            }
        }
        if (this.getToolPage() == 5) {
            return "embossment";
        }
        if (this.getToolPage() == 6) {
            return "shard";
        }
        return "head";
    }

    public String toolPageToString() {
        switch (this.delegate.method_17390(0)) {
            case 1: {
                return "shovel";
            }
            case 2: {
                return "axe";
            }
            case 3: {
                return "sword";
            }
            case 4: {
                return "hoe";
            }
            case 5: {
                return "embossment";
            }
            case 6: {
                return "shard";
            }
        }
        return "pickaxe";
    }

    public void setToolPage(int id) {
        this.delegate.method_17391(0, id);
    }

    public int getToolPage() {
        return this.delegate.method_17390(0);
    }

    public int getPartPage() {
        return this.delegate.method_17390(1);
    }

    public void setPartPage(int id) {
        this.delegate.method_17391(1, id);
    }
}

