/*
 * Decompiled with CFR 0.152.
 */
package wraith.smithee.utils;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.fabricmc.fabric.api.tag.TagRegistry;
import net.minecraft.class_1792;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import wraith.smithee.Config;
import wraith.smithee.ItemGroups;
import wraith.smithee.properties.ChiselingRecipe;
import wraith.smithee.properties.PartCombination;
import wraith.smithee.properties.Properties;
import wraith.smithee.properties.Property;
import wraith.smithee.properties.ToolPartRecipe;
import wraith.smithee.properties.Trait;
import wraith.smithee.recipes.EmbossModifiers;
import wraith.smithee.recipes.EmbossRecipe;
import wraith.smithee.recipes.RecipesGenerator;
import wraith.smithee.registry.ItemRegistry;
import wraith.smithee.utils.Utils;

public class JsonParser {
    public static void parseIndividualPart(JsonObject part, Properties properties, String type) {
        int mineLevel = part.get("mining_level").getAsInt();
        int durability = part.get("durability").getAsInt();
        float mineSpeed = part.get("mining_speed").getAsFloat();
        float attackDamage = part.get("attack_damage").getAsFloat();
        float attackSpeed = part.get("attack_speed").getAsFloat();
        properties.partProperties.put(type, new Property(mineSpeed, mineLevel, durability, attackDamage, attackSpeed));
        if (!part.has("traits")) {
            return;
        }
        for (JsonElement trait : part.get("traits").getAsJsonArray()) {
            JsonObject traitObject = trait.getAsJsonObject();
            String traitName = traitObject.get("trait").getAsString();
            int minLevel = traitObject.get("min_level").getAsInt();
            int maxLevel = traitObject.get("max_level").getAsInt();
            double chance = traitObject.get("chance").getAsDouble();
            properties.traits.get(type).add(new Trait(traitName, minLevel, maxLevel, chance));
        }
    }

    public static void parseRecipes(Set<Map.Entry<String, JsonElement>> recipes, HashMap<class_1792, HashMap<String, ToolPartRecipe>> recipeList, HashMap<String, HashMap<class_2960, Integer>> remains) {
        int minLevel = -1;
        for (Map.Entry<String, JsonElement> entry : recipes) {
            JsonObject recipe = entry.getValue().getAsJsonObject();
            String material = entry.getKey();
            String outputMaterial = recipe.get("output_material").getAsString();
            int chiselingLevel = recipe.get("chiseling_level").getAsInt();
            int worth = recipe.get("material_value").getAsInt();
            minLevel = minLevel == -1 ? chiselingLevel : Math.min(minLevel, chiselingLevel);
            boolean canEmboss = recipe.has("can_emboss") && recipe.get("can_emboss").getAsBoolean();
            boolean embossOnly = recipe.has("emboss_only") && recipe.get("emboss_only").getAsBoolean();
            HashSet<class_1792> items = new HashSet<class_1792>();
            if (material.startsWith("#")) {
                items.addAll(TagRegistry.item((class_2960)new class_2960(material.substring(1))).method_15138());
            } else {
                items.add((class_1792)class_2378.field_11142.method_10223(new class_2960(material)));
            }
            JsonObject overrides = recipe.get("overrides").getAsJsonObject();
            for (class_1792 item : items) {
                if (!remains.containsKey(outputMaterial)) {
                    remains.put(outputMaterial, new HashMap());
                }
                remains.get(outputMaterial).put(class_2378.field_11142.method_10221((Object)item), worth);
                if (ItemRegistry.SHARDS.containsKey(outputMaterial)) {
                    remains.get(outputMaterial).put(ItemRegistry.SHARDS.get(outputMaterial), 1);
                }
                class_1792 shard = (class_1792)class_2378.field_11142.method_10223(ItemRegistry.SHARDS.get(outputMaterial));
                recipeList.put(item, new HashMap());
                if (!recipeList.containsKey(shard)) {
                    recipeList.put(shard, new HashMap());
                }
                if (embossOnly) {
                    int base = ItemRegistry.BASE_RECIPE_VALUES.get("embossment");
                    recipeList.get(item).put("embossment", new ToolPartRecipe(outputMaterial, base, chiselingLevel));
                    if (overrides.has("all") || overrides.has("embossment")) {
                        recipeList.get((Object)item).get((Object)"embososment").requiredAmount = (int)Utils.evaluateExpression(overrides.get("all").getAsString().replace("base", String.valueOf(base)));
                    } else if (overrides.has("embossment")) {
                        recipeList.get((Object)item).get((Object)"embososment").requiredAmount = (int)Utils.evaluateExpression(overrides.get("embossment").getAsString().replace("base", String.valueOf(base)));
                    }
                    return;
                }
                for (String recipeType : ItemRegistry.BASE_RECIPE_VALUES.keySet()) {
                    if ("embossment".equals(recipeType) && !canEmboss) continue;
                    int base = ItemRegistry.BASE_RECIPE_VALUES.get(recipeType);
                    recipeList.get(item).put(recipeType, new ToolPartRecipe(outputMaterial, base, chiselingLevel));
                    if (!recipeList.get(shard).containsKey(recipeType)) {
                        recipeList.get(shard).put(recipeType, new ToolPartRecipe(outputMaterial, base, chiselingLevel));
                    }
                    if (overrides.has("all")) {
                        recipeList.get((Object)item).get((Object)recipeType).requiredAmount = (int)Utils.evaluateExpression(overrides.get("all").getAsString().replace("base", String.valueOf(base)));
                        continue;
                    }
                    if (!overrides.has(recipeType)) continue;
                    recipeList.get((Object)item).get((Object)recipeType).requiredAmount = (int)Utils.evaluateExpression(overrides.get(recipeType).getAsString().replace("base", String.valueOf(base)));
                }
            }
        }
    }

    public static void parseCombinations() {
        File[] files;
        for (File file : files = Config.getFiles("config/smithee/combinations/")) {
            JsonObject json = Config.getJsonObject(Config.readFile(file));
            for (JsonElement combination : json.get("combinations").getAsJsonArray()) {
                Object element2;
                HashMap<String, HashSet<String>> includes = new HashMap<String, HashSet<String>>();
                includes.put("head", new HashSet());
                includes.put("binding", new HashSet());
                includes.put("handle", new HashSet());
                for (Object element2 : combination.getAsJsonObject().get("includes").getAsJsonArray()) {
                    String[] segments = element2.getAsString().split("_");
                    String material = "";
                    for (int i = 0; i < segments.length - 1; ++i) {
                        material = material + segments[i];
                    }
                    ((HashSet)includes.get(segments[segments.length - 1])).add(material);
                }
                HashMap<String, HashSet<String>> excludes = new HashMap<String, HashSet<String>>();
                excludes.put("head", new HashSet());
                excludes.put("binding", new HashSet());
                excludes.put("handle", new HashSet());
                element2 = combination.getAsJsonObject().get("excludes").getAsJsonArray().iterator();
                while (element2.hasNext()) {
                    JsonElement element3 = (JsonElement)element2.next();
                    String[] segments = element3.getAsString().split("_");
                    String material = "";
                    for (int i = 0; i < segments.length - 1; ++i) {
                        material = material + segments[i];
                    }
                    ((HashSet)excludes.get(segments[segments.length - 1])).add(material);
                }
                HashMap<String, String> properties = new HashMap<String, String>();
                JsonObject obj = combination.getAsJsonObject();
                if (obj.has("miningSpeed")) {
                    String miningSpeed = obj.get("mining_speed").getAsString();
                    properties.put("mining_speed", miningSpeed);
                } else if (obj.has("miningLevel")) {
                    String miningLevel = obj.get("mining_level").getAsString();
                    properties.put("mining_level", miningLevel);
                } else if (obj.has("durability")) {
                    String durability = obj.get("durability").getAsString();
                    properties.put("durability", durability);
                } else if (obj.has("attackDamage")) {
                    String attackDamage = obj.get("attack_damage").getAsString();
                    properties.put("attack_damage", attackDamage);
                } else if (obj.has("attackSpeed")) {
                    String attackSpeed = obj.get("attack_speed").getAsString();
                    properties.put("attack_speed", attackSpeed);
                }
                PartCombination.COMBINATIONS.add(new PartCombination(includes, excludes, properties));
            }
        }
    }

    public static void parseModifiers(JsonObject json, HashMap<String, EmbossRecipe> recipes) {
        String material = json.get("material").getAsString();
        String type = json.get("type").getAsString();
        boolean stackable = json.get("stackable").getAsBoolean();
        JsonArray array = json.get("modifies").getAsJsonArray();
        ArrayList<EmbossModifiers> embossModifiers = new ArrayList<EmbossModifiers>();
        for (JsonElement modifier : array) {
            JsonObject obj = modifier.getAsJsonObject();
            String gives = obj.get("gives").getAsString();
            JsonArray givesToArray = obj.get("gives_to").getAsJsonArray();
            HashSet<String> givesTo = new HashSet<String>();
            for (JsonElement element : givesToArray) {
                givesTo.add(element.getAsString());
            }
            embossModifiers.add(new EmbossModifiers(gives, givesTo));
        }
        HashSet<String> incompatible = new HashSet<String>();
        if (json.has("incompatible")) {
            array = json.get("incompatible").getAsJsonArray();
            for (JsonElement inc : array) {
                incompatible.add(inc.getAsString());
            }
        }
        recipes.put(material, new EmbossRecipe(type, stackable, embossModifiers, incompatible));
    }

    public static void parseChiselingStats(JsonArray json, ArrayList<ChiselingRecipe> stats) {
        for (int i = 0; i < json.size(); ++i) {
            JsonObject chiselStat = json.get(i).getAsJsonObject();
            int level = chiselStat.get("level").getAsInt();
            int durability = chiselStat.get("durability").getAsInt();
            String material = chiselStat.get("material").getAsString();
            stats.add(new ChiselingRecipe(level, durability, material));
            if (chiselStat.has("smithing_input") && chiselStat.has("smithing_addition")) {
                String input = chiselStat.get("smithing_input").getAsString();
                class_2960 addition = new class_2960(chiselStat.get("smithing_addition").getAsString());
                RecipesGenerator.VANILLA_RECIPES.put(Utils.ID(material + "_chisel"), RecipesGenerator.generateSmithingJson(Utils.ID(input + "_chisel"), addition, Utils.ID(material + "_chisel")));
                continue;
            }
            class_2960 head = ItemRegistry.SHARDS.get(material);
            RecipesGenerator.VANILLA_RECIPES.put(Utils.ID(material + "_chisel"), RecipesGenerator.generateChiselRecipeJson(head, Utils.ID(material + "_chisel")));
        }
    }

    public static void parseShards(JsonObject jsonObject, HashMap<String, class_2960> shards) {
        JsonArray array = jsonObject.get("generate_new").getAsJsonArray();
        for (JsonElement element : array) {
            String id = element.getAsString();
            shards.put(id, Utils.ID(id + "_shard"));
            ItemRegistry.ITEMS.put(id + "_shard", new class_1792(new class_1792.class_1793().method_7892(ItemGroups.SMITHEE_ITEMS)));
        }
        array = jsonObject.get("use_existing").getAsJsonArray();
        for (JsonElement element : array) {
            JsonObject obj = element.getAsJsonObject();
            String material = obj.get("material").getAsString();
            shards.put(material, new class_2960(obj.get("item").getAsString()));
        }
    }
}

