/*
 * Decompiled with CFR 0.152.
 */
package wraith.smithee.utils;

import com.udojava.evalex.Expression;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import java.util.TreeMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.imageio.ImageIO;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1091;
import net.minecraft.class_1743;
import net.minecraft.class_1792;
import net.minecraft.class_1794;
import net.minecraft.class_1799;
import net.minecraft.class_1810;
import net.minecraft.class_1821;
import net.minecraft.class_1829;
import net.minecraft.class_2960;
import org.apache.commons.io.FileUtils;
import wraith.smithee.Config;
import wraith.smithee.Smithee;
import wraith.smithee.SmitheeClient;
import wraith.smithee.registry.ItemRegistry;

public class Utils {
    public static final Random random = new Random(Calendar.getInstance().getTimeInMillis());
    private static final TreeMap<Integer, String> romanNumeralEncoding = new TreeMap<Integer, String>(){
        {
            this.put(1000, "M");
            this.put(900, "CM");
            this.put(500, "D");
            this.put(400, "CD");
            this.put(100, "C");
            this.put(90, "XC");
            this.put(50, "L");
            this.put(40, "XL");
            this.put(10, "X");
            this.put(9, "IX");
            this.put(5, "V");
            this.put(4, "IV");
            this.put(1, "I");
        }
    };

    public static class_2960 ID(String id) {
        return new class_2960("smithee", id);
    }

    public static String toRoman(int number) {
        int l = romanNumeralEncoding.floorKey(number);
        if (number == l) {
            return romanNumeralEncoding.get(number);
        }
        return romanNumeralEncoding.get(l) + Utils.toRoman(number - l);
    }

    public static class_1091 inventoryModelID(String id) {
        return new class_1091(new class_2960("smithee", id), "inventory");
    }

    public static String createModelJson(String path, String type) {
        String[] segments = path.split("/");
        path = segments[segments.length - 1];
        return "{\n  \"parent\": \"item/" + type + "\",\n  \"textures\": {\n    \"layer0\": \"" + "smithee" + ":item/" + path + "\"\n  }\n}";
    }

    public static String getToolType(class_1792 item) {
        if (item instanceof class_1810) {
            return "pickaxe";
        }
        if (item instanceof class_1743) {
            return "axe";
        }
        if (item instanceof class_1821) {
            return "shovel";
        }
        if (item instanceof class_1794) {
            return "hoe";
        }
        if (item instanceof class_1829) {
            return "sword";
        }
        return "";
    }

    public static void saveFilesFromJar(String dir, String outputDir, boolean overwrite) {
        JarFile jar = null;
        try {
            jar = new JarFile(Utils.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath());
        }
        catch (IOException | URISyntaxException exception) {
            // empty catch block
        }
        if (jar != null) {
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                if (!entry.getName().startsWith(dir) || !entry.getName().endsWith(".json") && !entry.getName().endsWith(".png") && !entry.getName().endsWith(".mcmeta")) continue;
                String[] segments = entry.getName().split("/");
                String filename = segments[segments.length - 1];
                if (entry.isDirectory()) continue;
                InputStream is = Utils.class.getResourceAsStream("/" + entry.getName());
                String path = "config/smithee/" + outputDir + ("".equals(outputDir) ? "" : File.separator) + filename;
                if (filename.endsWith(".png")) {
                    if (Files.exists(new File(path).toPath(), new LinkOption[0]) && overwrite) {
                        try {
                            Files.delete(new File(path).toPath());
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    if (Files.exists(new File(path).toPath(), new LinkOption[0])) continue;
                    try {
                        new File(path).getParentFile().mkdirs();
                        Files.copy(is, new File(path).toPath(), new CopyOption[0]);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                try {
                    Utils.inputStreamToFile(is, new File(path), overwrite);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        } else {
            File[] files;
            System.out.println("Launched from IDE.");
            for (File file : files = ((ModContainer)FabricLoader.getInstance().getModContainer("smithee").get()).getPath(dir).toFile().listFiles()) {
                if (file.isDirectory()) continue;
                String[] segments = file.getName().split("/");
                String filename = segments[segments.length - 1];
                String path = "config/smithee/" + outputDir + ("".equals(outputDir) ? "" : File.separator) + filename;
                if (filename.endsWith(".png")) {
                    if (Files.exists(new File(path).toPath(), new LinkOption[0]) && overwrite) {
                        try {
                            Files.delete(new File(path).toPath());
                        }
                        catch (IOException e) {
                            Smithee.LOGGER.warn("ERROR OCCURRED WHILE DELETING OLD TEXTURES FOR " + filename);
                            e.printStackTrace();
                        }
                    }
                    if (Files.exists(new File(path).toPath(), new LinkOption[0])) continue;
                    try {
                        Smithee.LOGGER.info("Regenerating " + filename);
                        new File(path).getParentFile().mkdirs();
                        Files.copy(file.toPath(), new File(path).toPath(), new CopyOption[0]);
                    }
                    catch (IOException e) {
                        Smithee.LOGGER.warn("ERROR OCCURRED WHILE REGENERATING " + filename + " TEXTURE");
                        e.printStackTrace();
                    }
                    continue;
                }
                try {
                    Config.createFile(path, FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8), overwrite);
                }
                catch (IOException e) {
                    Smithee.LOGGER.warn("ERROR OCCURRED WHILE REGENERATING " + filename + " TEXTURE");
                    e.printStackTrace();
                }
            }
        }
    }

    private static void inputStreamToFile(InputStream inputStream, File file, boolean overwrite) throws IOException {
        if (!file.exists() || overwrite) {
            FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)file);
        }
    }

    public static double evaluateExpression(String stringExpression) {
        return new Expression(stringExpression).eval().doubleValue();
    }

    public static String capitalize(String string) {
        return Character.toUpperCase(string.charAt(0)) + string.substring(1);
    }

    public static void setDamage(class_1799 stack, int damage) {
        stack.method_7974(damage);
        if (stack.method_7919() >= stack.method_7936()) {
            stack.method_7939(0);
        }
    }

    public static void damage(class_1799 stack, int damage) {
        Utils.setDamage(stack, stack.method_7919() + damage);
    }

    public static void repair(class_1799 stack, int repairAmount) {
        Utils.setDamage(stack, Math.max(0, stack.method_7919() - repairAmount));
    }

    public static String stripToolType(String part) {
        String[] parts = part.split("_");
        String stripped = "";
        for (int i = 0; i < parts.length - 1; ++i) {
            stripped = stripped + parts[i];
        }
        stripped = stripped + parts[parts.length - 1];
        return stripped;
    }

    public static int getRandomIntInRange(int min, int max) {
        return random.nextInt(max - min + 1) + min;
    }

    public static double getRandomDoubleInRange(int min, int max) {
        return (double)min + random.nextDouble() * (double)max;
    }

    public static String capitalize(String[] split) {
        String result = "";
        Iterator<String> it = Arrays.asList(split).iterator();
        while (it.hasNext()) {
            result = result + Utils.capitalize(it.next());
            if (!it.hasNext()) continue;
            result = result + " ";
        }
        return result;
    }

    public static boolean isToolPart(String path) {
        String[] segments = path.split("/");
        path = segments[segments.length - 1];
        int maxI = Utils.getMaterialFromPathIndex(path);
        if (maxI >= (segments = path.split("_")).length) {
            return false;
        }
        String part = "";
        for (int i = maxI; i < segments.length; ++i) {
            part = part + "_" + segments[i];
        }
        return ItemRegistry.BASE_RECIPE_VALUES.containsKey(part = part.substring(1)) || SmitheeClient.RENDERING_TOOL_PARTS.contains(path);
    }

    public static boolean isSmitheeTool(String path) {
        HashSet<String> baseTools = new HashSet<String>();
        for (String tool : ItemRegistry.TOOL_TYPES) {
            baseTools.add("base_smithee_" + tool);
        }
        return baseTools.contains(path);
    }

    public static InputStream recolor(File template, File templatePalette, File palette, String textureName) {
        BufferedImage templatePaletteImage;
        BufferedImage paletteImage;
        BufferedImage templateImage;
        try {
            templateImage = ImageIO.read(template);
            paletteImage = ImageIO.read(palette);
            templatePaletteImage = ImageIO.read(templatePalette);
        }
        catch (IOException e) {
            Smithee.LOGGER.warn("Error while creating texture " + textureName);
            e.printStackTrace();
            return null;
        }
        ArrayList<Integer> templateColors = new ArrayList<Integer>();
        for (int x = 0; x < templatePaletteImage.getWidth(); ++x) {
            templateColors.add(templatePaletteImage.getRGB(x, 0));
        }
        ArrayList<Integer> paletteColors = new ArrayList<Integer>();
        for (int x = 0; x < paletteImage.getWidth(); ++x) {
            paletteColors.add(paletteImage.getRGB(x, 0));
        }
        for (int y = 0; y < templateImage.getHeight(); ++y) {
            block7: for (int x = 0; x < templateImage.getWidth(); ++x) {
                for (int i = 0; i < templateColors.size(); ++i) {
                    if (templateImage.getRGB(x, y) != ((Integer)templateColors.get(i)).intValue()) continue;
                    templateImage.setRGB(x, y, (Integer)paletteColors.get(i));
                    continue block7;
                }
            }
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)templateImage, "PNG", os);
            return new ByteArrayInputStream(os.toByteArray());
        }
        catch (IOException e) {
            Smithee.LOGGER.warn("Error while creating texture " + textureName);
            e.printStackTrace();
            return null;
        }
    }

    public static int getMaterialFromPathIndex(String path) {
        int i;
        String material = "";
        String[] segments = path.split("_");
        for (i = 0; !ItemRegistry.MATERIALS.contains(material) && !ItemRegistry.EMBOSS_MATERIALS.contains(material) && i < segments.length; ++i) {
            if (i > 0) {
                material = material + "_";
            }
            material = material + segments[i];
        }
        if (i == segments.length) {
            return i;
        }
        int j = i;
        while (!ItemRegistry.MATERIALS.contains(material = material + "_" + segments[j]) && !ItemRegistry.EMBOSS_MATERIALS.contains(material) && ++j < segments.length) {
        }
        return j == segments.length ? i : j;
    }
}

